/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class DESKeyFactory
extends SecretKeyFactorySpi {
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DESKeySpec) {
                return new DESKey(((DESKeySpec)keySpec).getKey());
            }
            if (keySpec instanceof SecretKeySpec) {
                return new DESKey(((SecretKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class<?> clazz) throws InvalidKeySpecException {
        try {
            if (secretKey instanceof SecretKey && secretKey.getAlgorithm().equalsIgnoreCase("DES") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                if (clazz != null && DESKeySpec.class.isAssignableFrom(clazz)) {
                    return new DESKeySpec(secretKey.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        try {
            if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase("DES") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                if (secretKey instanceof DESKey) {
                    return secretKey;
                }
                DESKeySpec dESKeySpec = (DESKeySpec)this.engineGetKeySpec(secretKey, DESKeySpec.class);
                return this.engineGenerateSecret(dESKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

