/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ConstructorProperties;
import java.beans.NameGenerator;
import java.beans.Statement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

public class EventHandler
implements InvocationHandler {
    private Object target;
    private String action;
    private final String eventPropertyName;
    private final String listenerMethodName;
    private final AccessControlContext acc = AccessController.getContext();

    @ConstructorProperties(value={"target", "action", "eventPropertyName", "listenerMethodName"})
    public EventHandler(Object object, String string, String string2, String string3) {
        this.target = object;
        this.action = string;
        if (object == null) {
            throw new NullPointerException("target must be non-null");
        }
        if (string == null) {
            throw new NullPointerException("action must be non-null");
        }
        this.eventPropertyName = string2;
        this.listenerMethodName = string3;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getAction() {
        return this.action;
    }

    public String getEventPropertyName() {
        return this.eventPropertyName;
    }

    public String getListenerMethodName() {
        return this.listenerMethodName;
    }

    private Object applyGetters(Object object, String string) {
        if (string == null || string.equals("")) {
            return object;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            n = string.length();
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(Math.min(n + 1, string.length()));
        try {
            Method method = null;
            if (object != null) {
                method = Statement.getMethod(object.getClass(), "get" + NameGenerator.capitalize(string2), new Class[0]);
                if (method == null) {
                    method = Statement.getMethod(object.getClass(), "is" + NameGenerator.capitalize(string2), new Class[0]);
                }
                if (method == null) {
                    method = Statement.getMethod(object.getClass(), string2, new Class[0]);
                }
            }
            if (method == null) {
                throw new RuntimeException("No method called: " + string2 + " defined on " + object);
            }
            Object object2 = MethodUtil.invoke(method, object, new Object[0]);
            return this.applyGetters(object2, string3);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to call method: " + string2 + " on " + object, exception);
        }
    }

    @Override
    public Object invoke(final Object object, final Method method, final Object[] objectArray) {
        AccessControlContext accessControlContext = this.acc;
        if (accessControlContext == null && System.getSecurityManager() != null) {
            throw new SecurityException("AccessControlContext is not set");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return EventHandler.this.invokeInternal(object, method, objectArray);
            }
        }, accessControlContext);
    }

    private Object invokeInternal(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        if (method.getDeclaringClass() == Object.class) {
            if (string.equals("hashCode")) {
                return new Integer(System.identityHashCode(object));
            }
            if (string.equals("equals")) {
                return object == objectArray[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (string.equals("toString")) {
                return object.getClass().getName() + '@' + Integer.toHexString(object.hashCode());
            }
        }
        if (this.listenerMethodName == null || this.listenerMethodName.equals(string)) {
            Class[] classArray = null;
            Object[] objectArray2 = null;
            if (this.eventPropertyName == null) {
                objectArray2 = new Object[]{};
                classArray = new Class[]{};
            } else {
                Object object2 = this.applyGetters(objectArray[0], this.getEventPropertyName());
                objectArray2 = new Object[]{object2};
                classArray = new Class[]{object2 == null ? null : object2.getClass()};
            }
            try {
                Method method2;
                int n = this.action.lastIndexOf(46);
                if (n != -1) {
                    this.target = this.applyGetters(this.target, this.action.substring(0, n));
                    this.action = this.action.substring(n + 1);
                }
                if ((method2 = Statement.getMethod(this.target.getClass(), this.action, classArray)) == null) {
                    method2 = Statement.getMethod(this.target.getClass(), "set" + NameGenerator.capitalize(this.action), classArray);
                }
                if (method2 == null) {
                    String string2 = classArray.length == 0 ? " with no arguments" : " with argument " + classArray[0];
                    throw new RuntimeException("No method called " + this.action + " on " + this.target.getClass() + string2);
                }
                return MethodUtil.invoke(method2, this.target, objectArray2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
            }
        }
        return null;
    }

    public static <T> T create(Class<T> clazz, Object object, String string) {
        return EventHandler.create(clazz, object, string, null, null);
    }

    public static <T> T create(Class<T> clazz, Object object, String string, String string2) {
        return EventHandler.create(clazz, object, string, string2, null);
    }

    public static <T> T create(Class<T> clazz, Object object, String string, String string2, String string3) {
        final EventHandler eventHandler = new EventHandler(object, string, string2, string3);
        if (clazz == null) {
            throw new NullPointerException("listenerInterface must be non-null");
        }
        final ClassLoader classLoader = EventHandler.getClassLoader(clazz);
        final Class[] classArray = new Class[]{clazz};
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return Proxy.newProxyInstance(classLoader, classArray, eventHandler);
            }
        });
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        ReflectUtil.checkPackageAccess(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

