/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.text.CharacterIterator;
import java.text.Normalizer;
import sun.text.normalizer.NormalizerImpl;
import sun.text.normalizer.UCharacterIterator;
import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.UnicodeSet;
import sun.text.normalizer.Utility;

public final class NormalizerBase
implements Cloneable {
    private char[] buffer = new char[100];
    private int bufferStart = 0;
    private int bufferPos = 0;
    private int bufferLimit = 0;
    private UCharacterIterator text;
    private Mode mode = NFC;
    private int options = 0;
    private int currentIndex;
    private int nextIndex;
    public static final int UNICODE_3_2 = 32;
    public static final int DONE = -1;
    public static final Mode NONE = new Mode(1);
    public static final Mode NFD = new NFDMode(2);
    public static final Mode NFKD = new NFKDMode(3);
    public static final Mode NFC = new NFCMode(4);
    public static final Mode NFKC = new NFKCMode(5);
    public static final QuickCheckResult NO = new QuickCheckResult(0);
    public static final QuickCheckResult YES = new QuickCheckResult(1);
    public static final QuickCheckResult MAYBE = new QuickCheckResult(2);
    private static final int MAX_BUF_SIZE_COMPOSE = 2;
    private static final int MAX_BUF_SIZE_DECOMPOSE = 3;
    public static final int UNICODE_3_2_0_ORIGINAL = 262432;
    public static final int UNICODE_LATEST = 0;

    public NormalizerBase(String string, Mode mode, int n) {
        this.text = UCharacterIterator.getInstance(string);
        this.mode = mode;
        this.options = n;
    }

    public NormalizerBase(CharacterIterator characterIterator, Mode mode) {
        this(characterIterator, mode, 0);
    }

    public NormalizerBase(CharacterIterator characterIterator, Mode mode, int n) {
        this.text = UCharacterIterator.getInstance((CharacterIterator)characterIterator.clone());
        this.mode = mode;
        this.options = n;
    }

    public Object clone() {
        try {
            NormalizerBase normalizerBase = (NormalizerBase)super.clone();
            normalizerBase.text = (UCharacterIterator)this.text.clone();
            if (this.buffer != null) {
                normalizerBase.buffer = new char[this.buffer.length];
                System.arraycopy(this.buffer, 0, normalizerBase.buffer, 0, this.buffer.length);
            }
            return normalizerBase;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString(), cloneNotSupportedException);
        }
    }

    public static String compose(String string, boolean bl, int n) {
        char[] cArray;
        char[] cArray2;
        if (n == 262432) {
            String string2 = NormalizerImpl.convert(string);
            cArray2 = new char[string2.length() * 2];
            cArray = string2.toCharArray();
        } else {
            cArray2 = new char[string.length() * 2];
            cArray = string.toCharArray();
        }
        int n2 = 0;
        UnicodeSet unicodeSet = NormalizerImpl.getNX(n);
        n &= 0xFFFFCF00;
        if (bl) {
            n |= 0x1000;
        }
        while ((n2 = NormalizerImpl.compose(cArray, 0, cArray.length, cArray2, 0, cArray2.length, n, unicodeSet)) > cArray2.length) {
            cArray2 = new char[n2];
        }
        return new String(cArray2, 0, n2);
    }

    public static String decompose(String string, boolean bl) {
        return NormalizerBase.decompose(string, bl, 0);
    }

    public static String decompose(String string, boolean bl, int n) {
        int[] nArray = new int[1];
        int n2 = 0;
        UnicodeSet unicodeSet = NormalizerImpl.getNX(n);
        if (n == 262432) {
            String string2 = NormalizerImpl.convert(string);
            char[] cArray = new char[string2.length() * 3];
            while (true) {
                if ((n2 = NormalizerImpl.decompose(string2.toCharArray(), 0, string2.length(), cArray, 0, cArray.length, bl, nArray, unicodeSet)) <= cArray.length) {
                    return new String(cArray, 0, n2);
                }
                cArray = new char[n2];
            }
        }
        char[] cArray = new char[string.length() * 3];
        while ((n2 = NormalizerImpl.decompose(string.toCharArray(), 0, string.length(), cArray, 0, cArray.length, bl, nArray, unicodeSet)) > cArray.length) {
            cArray = new char[n2];
        }
        return new String(cArray, 0, n2);
    }

    public static int normalize(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, Mode mode, int n5) {
        int n6 = mode.normalize(cArray, n, n2, cArray2, n3, n4, n5);
        if (n6 <= n4 - n3) {
            return n6;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n6));
    }

    public int current() {
        if (this.bufferPos < this.bufferLimit || this.nextNormalize()) {
            return this.getCodePointAt(this.bufferPos);
        }
        return -1;
    }

    public int next() {
        if (this.bufferPos < this.bufferLimit || this.nextNormalize()) {
            int n = this.getCodePointAt(this.bufferPos);
            this.bufferPos += n > 65535 ? 2 : 1;
            return n;
        }
        return -1;
    }

    public int previous() {
        if (this.bufferPos > 0 || this.previousNormalize()) {
            int n = this.getCodePointAt(this.bufferPos - 1);
            this.bufferPos -= n > 65535 ? 2 : 1;
            return n;
        }
        return -1;
    }

    public void reset() {
        this.text.setIndex(0);
        this.nextIndex = 0;
        this.currentIndex = 0;
        this.clearBuffer();
    }

    public void setIndexOnly(int n) {
        this.text.setIndex(n);
        this.currentIndex = this.nextIndex = n;
        this.clearBuffer();
    }

    @Deprecated
    public int setIndex(int n) {
        this.setIndexOnly(n);
        return this.current();
    }

    @Deprecated
    public int getBeginIndex() {
        return 0;
    }

    @Deprecated
    public int getEndIndex() {
        return this.endIndex();
    }

    public int getIndex() {
        if (this.bufferPos < this.bufferLimit) {
            return this.currentIndex;
        }
        return this.nextIndex;
    }

    public int endIndex() {
        return this.text.getLength();
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setText(String string) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(string);
        if (uCharacterIterator == null) {
            throw new InternalError("Could not create a new UCharacterIterator");
        }
        this.text = uCharacterIterator;
        this.reset();
    }

    public void setText(CharacterIterator characterIterator) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(characterIterator);
        if (uCharacterIterator == null) {
            throw new InternalError("Could not create a new UCharacterIterator");
        }
        this.text = uCharacterIterator;
        this.nextIndex = 0;
        this.currentIndex = 0;
        this.clearBuffer();
    }

    private static long getPrevNorm32(UCharacterIterator uCharacterIterator, int n, int n2, char[] cArray) {
        int n3 = 0;
        n3 = uCharacterIterator.previous();
        if (n3 == -1) {
            return 0L;
        }
        cArray[0] = (char)n3;
        cArray[1] = '\u0000';
        if (cArray[0] < n) {
            return 0L;
        }
        if (!UTF16.isSurrogate(cArray[0])) {
            return NormalizerImpl.getNorm32(cArray[0]);
        }
        if (UTF16.isLeadSurrogate(cArray[0]) || uCharacterIterator.getIndex() == 0) {
            cArray[1] = (char)uCharacterIterator.current();
            return 0L;
        }
        cArray[1] = (char)uCharacterIterator.previous();
        if (UTF16.isLeadSurrogate(cArray[1])) {
            long l = NormalizerImpl.getNorm32(cArray[1]);
            if ((l & (long)n2) == 0L) {
                return 0L;
            }
            return NormalizerImpl.getNorm32FromSurrogatePair(l, cArray[0]);
        }
        uCharacterIterator.moveIndex(1);
        return 0L;
    }

    private static int findPreviousIterationBoundary(UCharacterIterator uCharacterIterator, IsPrevBoundary isPrevBoundary, int n, int n2, char[] cArray, int[] nArray) {
        char[] cArray2 = new char[2];
        nArray[0] = cArray.length;
        cArray2[0] = '\u0000';
        while (uCharacterIterator.getIndex() > 0 && cArray2[0] != '\uffffffff') {
            boolean bl = isPrevBoundary.isPrevBoundary(uCharacterIterator, n, n2, cArray2);
            if (nArray[0] < (cArray2[1] == '\u0000' ? 1 : 2)) {
                char[] cArray3 = new char[cArray.length * 2];
                System.arraycopy(cArray, nArray[0], cArray3, cArray3.length - (cArray.length - nArray[0]), cArray.length - nArray[0]);
                nArray[0] = nArray[0] + (cArray3.length - cArray.length);
                cArray = cArray3;
                cArray3 = null;
            }
            nArray[0] = nArray[0] - 1;
            cArray[nArray[0]] = cArray2[0];
            if (cArray2[1] != '\u0000') {
                nArray[0] = nArray[0] - 1;
                cArray[nArray[0]] = cArray2[1];
            }
            if (!bl) continue;
            break;
        }
        return cArray.length - nArray[0];
    }

    private static int previous(UCharacterIterator uCharacterIterator, char[] cArray, int n, int n2, Mode mode, boolean bl, boolean[] blArray, int n3) {
        int n4 = n2 - n;
        int n5 = 0;
        if (blArray != null) {
            blArray[0] = false;
        }
        char c = (char)mode.getMinC();
        int n6 = mode.getMask();
        IsPrevBoundary isPrevBoundary = mode.getPrevBoundary();
        if (isPrevBoundary == null) {
            n5 = 0;
            int n7 = uCharacterIterator.previous();
            if (n7 >= 0) {
                int n8;
                n5 = 1;
                if (UTF16.isTrailSurrogate((char)n7) && (n8 = uCharacterIterator.previous()) != -1) {
                    if (UTF16.isLeadSurrogate((char)n8)) {
                        if (n4 >= 2) {
                            cArray[1] = (char)n7;
                            n5 = 2;
                        }
                        n7 = n8;
                    } else {
                        uCharacterIterator.moveIndex(1);
                    }
                }
                if (n4 > 0) {
                    cArray[0] = (char)n7;
                }
            }
            return n5;
        }
        char[] cArray2 = new char[100];
        int[] nArray = new int[1];
        int n9 = NormalizerBase.findPreviousIterationBoundary(uCharacterIterator, isPrevBoundary, c, n6, cArray2, nArray);
        if (n9 > 0) {
            if (bl) {
                n5 = NormalizerBase.normalize(cArray2, nArray[0], nArray[0] + n9, cArray, n, n2, mode, n3);
                if (blArray != null) {
                    blArray[0] = n5 != n9 || Utility.arrayRegionMatches(cArray2, 0, cArray, n, n2);
                }
            } else if (n4 > 0) {
                System.arraycopy(cArray2, nArray[0], cArray, 0, n9 < n4 ? n9 : n4);
            }
        }
        return n5;
    }

    private static long getNextNorm32(UCharacterIterator uCharacterIterator, int n, int n2, int[] nArray) {
        nArray[0] = uCharacterIterator.next();
        nArray[1] = 0;
        if (nArray[0] < n) {
            return 0L;
        }
        long l = NormalizerImpl.getNorm32((char)nArray[0]);
        if (UTF16.isLeadSurrogate((char)nArray[0])) {
            if (uCharacterIterator.current() != -1 && UTF16.isTrailSurrogate((char)(nArray[1] = uCharacterIterator.current()))) {
                uCharacterIterator.moveIndex(1);
                if ((l & (long)n2) == 0L) {
                    return 0L;
                }
                return NormalizerImpl.getNorm32FromSurrogatePair(l, (char)nArray[1]);
            }
            return 0L;
        }
        return l;
    }

    private static int findNextIterationBoundary(UCharacterIterator uCharacterIterator, IsNextBoundary isNextBoundary, int n, int n2, char[] cArray) {
        if (uCharacterIterator.current() == -1) {
            return 0;
        }
        int[] nArray = new int[2];
        nArray[0] = uCharacterIterator.next();
        cArray[0] = (char)nArray[0];
        int n3 = 1;
        if (UTF16.isLeadSurrogate((char)nArray[0]) && uCharacterIterator.current() != -1) {
            nArray[1] = uCharacterIterator.next();
            if (UTF16.isTrailSurrogate((char)nArray[1])) {
                cArray[n3++] = (char)nArray[1];
            } else {
                uCharacterIterator.moveIndex(-1);
            }
        }
        while (uCharacterIterator.current() != -1) {
            if (isNextBoundary.isNextBoundary(uCharacterIterator, n, n2, nArray)) {
                uCharacterIterator.moveIndex(nArray[1] == 0 ? -1 : -2);
                break;
            }
            if (n3 + (nArray[1] == 0 ? 1 : 2) <= cArray.length) {
                cArray[n3++] = (char)nArray[0];
                if (nArray[1] == 0) continue;
                cArray[n3++] = (char)nArray[1];
                continue;
            }
            char[] cArray2 = new char[cArray.length * 2];
            System.arraycopy(cArray, 0, cArray2, 0, n3);
            cArray = cArray2;
            cArray[n3++] = (char)nArray[0];
            if (nArray[1] == 0) continue;
            cArray[n3++] = (char)nArray[1];
        }
        return n3;
    }

    private static int next(UCharacterIterator uCharacterIterator, char[] cArray, int n, int n2, Mode mode, boolean bl, boolean[] blArray, int n3) {
        int n4 = n2 - n;
        int n5 = 0;
        if (blArray != null) {
            blArray[0] = false;
        }
        char c = (char)mode.getMinC();
        int n6 = mode.getMask();
        IsNextBoundary isNextBoundary = mode.getNextBoundary();
        if (isNextBoundary == null) {
            n5 = 0;
            int n7 = uCharacterIterator.next();
            if (n7 != -1) {
                int n8;
                n5 = 1;
                if (UTF16.isLeadSurrogate((char)n7) && (n8 = uCharacterIterator.next()) != -1) {
                    if (UTF16.isTrailSurrogate((char)n8)) {
                        if (n4 >= 2) {
                            cArray[1] = (char)n8;
                            n5 = 2;
                        }
                    } else {
                        uCharacterIterator.moveIndex(-1);
                    }
                }
                if (n4 > 0) {
                    cArray[0] = (char)n7;
                }
            }
            return n5;
        }
        char[] cArray2 = new char[100];
        int[] nArray = new int[1];
        int n9 = NormalizerBase.findNextIterationBoundary(uCharacterIterator, isNextBoundary, c, n6, cArray2);
        if (n9 > 0) {
            if (bl) {
                n5 = mode.normalize(cArray2, nArray[0], n9, cArray, n, n2, n3);
                if (blArray != null) {
                    blArray[0] = n5 != n9 || Utility.arrayRegionMatches(cArray2, nArray[0], cArray, n, n5);
                }
            } else if (n4 > 0) {
                System.arraycopy(cArray2, 0, cArray, n, Math.min(n9, n4));
            }
        }
        return n5;
    }

    private void clearBuffer() {
        this.bufferPos = 0;
        this.bufferStart = 0;
        this.bufferLimit = 0;
    }

    private boolean nextNormalize() {
        this.clearBuffer();
        this.currentIndex = this.nextIndex;
        this.text.setIndex(this.nextIndex);
        this.bufferLimit = NormalizerBase.next(this.text, this.buffer, this.bufferStart, this.buffer.length, this.mode, true, null, this.options);
        this.nextIndex = this.text.getIndex();
        return this.bufferLimit > 0;
    }

    private boolean previousNormalize() {
        this.clearBuffer();
        this.nextIndex = this.currentIndex;
        this.text.setIndex(this.currentIndex);
        this.bufferLimit = NormalizerBase.previous(this.text, this.buffer, this.bufferStart, this.buffer.length, this.mode, true, null, this.options);
        this.currentIndex = this.text.getIndex();
        this.bufferPos = this.bufferLimit;
        return this.bufferLimit > 0;
    }

    private int getCodePointAt(int n) {
        if (UTF16.isSurrogate(this.buffer[n])) {
            if (UTF16.isLeadSurrogate(this.buffer[n])) {
                if (n + 1 < this.bufferLimit && UTF16.isTrailSurrogate(this.buffer[n + 1])) {
                    return UCharacterProperty.getRawSupplementary(this.buffer[n], this.buffer[n + 1]);
                }
            } else if (UTF16.isTrailSurrogate(this.buffer[n]) && n > 0 && UTF16.isLeadSurrogate(this.buffer[n - 1])) {
                return UCharacterProperty.getRawSupplementary(this.buffer[n - 1], this.buffer[n]);
            }
        }
        return this.buffer[n];
    }

    public static boolean isNFSkippable(int n, Mode mode) {
        return mode.isNFSkippable(n);
    }

    public NormalizerBase(String string, Mode mode) {
        this(string, mode, 0);
    }

    public static String normalize(String string, Normalizer.Form form) {
        return NormalizerBase.normalize(string, form, 0);
    }

    public static String normalize(String string, Normalizer.Form form, int n) {
        int n2 = string.length();
        boolean bl = true;
        if (n2 < 80) {
            for (int i = 0; i < n2; ++i) {
                if (string.charAt(i) <= '\u007f') continue;
                bl = false;
                break;
            }
        } else {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < n2; ++i) {
                if (cArray[i] <= '\u007f') continue;
                bl = false;
                break;
            }
        }
        switch (form) {
            case NFC: {
                return bl ? string : NFC.normalize(string, n);
            }
            case NFD: {
                return bl ? string : NFD.normalize(string, n);
            }
            case NFKC: {
                return bl ? string : NFKC.normalize(string, n);
            }
            case NFKD: {
                return bl ? string : NFKD.normalize(string, n);
            }
        }
        throw new IllegalArgumentException("Unexpected normalization form: " + (Object)((Object)form));
    }

    public static boolean isNormalized(String string, Normalizer.Form form) {
        return NormalizerBase.isNormalized(string, form, 0);
    }

    public static boolean isNormalized(String string, Normalizer.Form form, int n) {
        switch (form) {
            case NFC: {
                return NFC.quickCheck(string.toCharArray(), 0, string.length(), false, NormalizerImpl.getNX(n)) == YES;
            }
            case NFD: {
                return NFD.quickCheck(string.toCharArray(), 0, string.length(), false, NormalizerImpl.getNX(n)) == YES;
            }
            case NFKC: {
                return NFKC.quickCheck(string.toCharArray(), 0, string.length(), false, NormalizerImpl.getNX(n)) == YES;
            }
            case NFKD: {
                return NFKD.quickCheck(string.toCharArray(), 0, string.length(), false, NormalizerImpl.getNX(n)) == YES;
            }
        }
        throw new IllegalArgumentException("Unexpected normalization form: " + (Object)((Object)form));
    }

    private static final class IsNextTrueStarter
    implements IsNextBoundary {
        private IsNextTrueStarter() {
        }

        @Override
        public boolean isNextBoundary(UCharacterIterator uCharacterIterator, int n, int n2, int[] nArray) {
            int n3 = n2 << 2 & 0xF;
            long l = NormalizerBase.getNextNorm32(uCharacterIterator, n, n2 | n3, nArray);
            return NormalizerImpl.isTrueStarter(l, n2, n3);
        }
    }

    private static final class IsNextNFDSafe
    implements IsNextBoundary {
        private IsNextNFDSafe() {
        }

        @Override
        public boolean isNextBoundary(UCharacterIterator uCharacterIterator, int n, int n2, int[] nArray) {
            return NormalizerImpl.isNFDSafe(NormalizerBase.getNextNorm32(uCharacterIterator, n, n2, nArray), n2, n2 & 0x3F);
        }
    }

    private static interface IsNextBoundary {
        public boolean isNextBoundary(UCharacterIterator var1, int var2, int var3, int[] var4);
    }

    private static final class IsPrevTrueStarter
    implements IsPrevBoundary {
        private IsPrevTrueStarter() {
        }

        @Override
        public boolean isPrevBoundary(UCharacterIterator uCharacterIterator, int n, int n2, char[] cArray) {
            int n3 = n2 << 2 & 0xF;
            long l = NormalizerBase.getPrevNorm32(uCharacterIterator, n, n2 | n3, cArray);
            return NormalizerImpl.isTrueStarter(l, n2, n3);
        }
    }

    private static final class IsPrevNFDSafe
    implements IsPrevBoundary {
        private IsPrevNFDSafe() {
        }

        @Override
        public boolean isPrevBoundary(UCharacterIterator uCharacterIterator, int n, int n2, char[] cArray) {
            return NormalizerImpl.isNFDSafe(NormalizerBase.getPrevNorm32(uCharacterIterator, n, n2, cArray), n2, n2 & 0x3F);
        }
    }

    private static interface IsPrevBoundary {
        public boolean isPrevBoundary(UCharacterIterator var1, int var2, int var3, char[] var4);
    }

    public static final class QuickCheckResult {
        private int resultValue;

        private QuickCheckResult(int n) {
            this.resultValue = n;
        }
    }

    private static final class NFKCMode
    extends Mode {
        private NFKCMode(int n) {
            super(n);
        }

        @Override
        protected int normalize(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, UnicodeSet unicodeSet) {
            return NormalizerImpl.compose(cArray, n, n2, cArray2, n3, n4, 4096, unicodeSet);
        }

        @Override
        protected String normalize(String string, int n) {
            return NormalizerBase.compose(string, true, n);
        }

        @Override
        protected int getMinC() {
            return NormalizerImpl.getFromIndexesArr(7);
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevTrueStarter();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextTrueStarter();
        }

        @Override
        protected int getMask() {
            return 65314;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] cArray, int n, int n2, boolean bl, UnicodeSet unicodeSet) {
            return NormalizerImpl.quickCheck(cArray, n, n2, NormalizerImpl.getFromIndexesArr(7), 34, 4096, bl, unicodeSet);
        }

        @Override
        protected boolean isNFSkippable(int n) {
            return NormalizerImpl.isNFSkippable(n, this, 65474L);
        }
    }

    private static final class NFCMode
    extends Mode {
        private NFCMode(int n) {
            super(n);
        }

        @Override
        protected int normalize(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, UnicodeSet unicodeSet) {
            return NormalizerImpl.compose(cArray, n, n2, cArray2, n3, n4, 0, unicodeSet);
        }

        @Override
        protected String normalize(String string, int n) {
            return NormalizerBase.compose(string, false, n);
        }

        @Override
        protected int getMinC() {
            return NormalizerImpl.getFromIndexesArr(6);
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevTrueStarter();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextTrueStarter();
        }

        @Override
        protected int getMask() {
            return 65297;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] cArray, int n, int n2, boolean bl, UnicodeSet unicodeSet) {
            return NormalizerImpl.quickCheck(cArray, n, n2, NormalizerImpl.getFromIndexesArr(6), 17, 0, bl, unicodeSet);
        }

        @Override
        protected boolean isNFSkippable(int n) {
            return NormalizerImpl.isNFSkippable(n, this, 65473L);
        }
    }

    private static final class NFKDMode
    extends Mode {
        private NFKDMode(int n) {
            super(n);
        }

        @Override
        protected int normalize(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, UnicodeSet unicodeSet) {
            int[] nArray = new int[1];
            return NormalizerImpl.decompose(cArray, n, n2, cArray2, n3, n4, true, nArray, unicodeSet);
        }

        @Override
        protected String normalize(String string, int n) {
            return NormalizerBase.decompose(string, true, n);
        }

        @Override
        protected int getMinC() {
            return 768;
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevNFDSafe();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextNFDSafe();
        }

        @Override
        protected int getMask() {
            return 65288;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] cArray, int n, int n2, boolean bl, UnicodeSet unicodeSet) {
            return NormalizerImpl.quickCheck(cArray, n, n2, NormalizerImpl.getFromIndexesArr(9), 8, 4096, bl, unicodeSet);
        }

        @Override
        protected boolean isNFSkippable(int n) {
            return NormalizerImpl.isNFSkippable(n, this, 65288L);
        }
    }

    private static final class NFDMode
    extends Mode {
        private NFDMode(int n) {
            super(n);
        }

        @Override
        protected int normalize(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, UnicodeSet unicodeSet) {
            int[] nArray = new int[1];
            return NormalizerImpl.decompose(cArray, n, n2, cArray2, n3, n4, false, nArray, unicodeSet);
        }

        @Override
        protected String normalize(String string, int n) {
            return NormalizerBase.decompose(string, false, n);
        }

        @Override
        protected int getMinC() {
            return 768;
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevNFDSafe();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextNFDSafe();
        }

        @Override
        protected int getMask() {
            return 65284;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] cArray, int n, int n2, boolean bl, UnicodeSet unicodeSet) {
            return NormalizerImpl.quickCheck(cArray, n, n2, NormalizerImpl.getFromIndexesArr(8), 4, 0, bl, unicodeSet);
        }

        @Override
        protected boolean isNFSkippable(int n) {
            return NormalizerImpl.isNFSkippable(n, this, 65284L);
        }
    }

    public static class Mode {
        private int modeValue;

        private Mode(int n) {
            this.modeValue = n;
        }

        protected int normalize(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, UnicodeSet unicodeSet) {
            int n5 = n2 - n;
            int n6 = n4 - n3;
            if (n5 > n6) {
                return n5;
            }
            System.arraycopy(cArray, n, cArray2, n3, n5);
            return n5;
        }

        protected int normalize(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, int n5) {
            return this.normalize(cArray, n, n2, cArray2, n3, n4, NormalizerImpl.getNX(n5));
        }

        protected String normalize(String string, int n) {
            return string;
        }

        protected int getMinC() {
            return -1;
        }

        protected int getMask() {
            return -1;
        }

        protected IsPrevBoundary getPrevBoundary() {
            return null;
        }

        protected IsNextBoundary getNextBoundary() {
            return null;
        }

        protected QuickCheckResult quickCheck(char[] cArray, int n, int n2, boolean bl, UnicodeSet unicodeSet) {
            if (bl) {
                return MAYBE;
            }
            return NO;
        }

        protected boolean isNFSkippable(int n) {
            return true;
        }
    }
}

