/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.HashMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.ExpressionSlot;
import org.jfree.report.data.GlobalMasterRow;
import org.jfree.report.data.MasterDataRowChangeEvent;
import org.jfree.report.flow.ReportContext;

public final class ExpressionDataRow
implements DataRow {
    private ExpressionSlot[] expressions;
    private int length;
    private HashMap nameCache;
    private GlobalMasterRow masterRow;
    private ReportContext reportContext;

    public ExpressionDataRow(GlobalMasterRow globalMasterRow, ReportContext reportContext, int n) {
        this.masterRow = globalMasterRow;
        this.nameCache = new HashMap(n);
        this.expressions = new ExpressionSlot[n];
        this.reportContext = reportContext;
    }

    private ExpressionDataRow(GlobalMasterRow globalMasterRow, ExpressionDataRow expressionDataRow) throws CloneNotSupportedException {
        this.reportContext = expressionDataRow.reportContext;
        this.masterRow = globalMasterRow;
        this.nameCache = (HashMap)expressionDataRow.nameCache.clone();
        this.expressions = new ExpressionSlot[expressionDataRow.expressions.length];
        this.length = expressionDataRow.length;
        for (int i = 0; i < this.length; ++i) {
            ExpressionSlot expressionSlot = expressionDataRow.expressions[i];
            if (expressionSlot == null) continue;
            this.expressions[i] = (ExpressionSlot)expressionSlot.clone();
        }
    }

    private void ensureCapacity(int n) {
        int n2 = this.expressions.length;
        if (n2 > n) {
            return;
        }
        int n3 = Math.max(n2 * 2, n + 10);
        ExpressionSlot[] expressionSlotArray = new ExpressionSlot[n3];
        System.arraycopy(this.expressions, 0, expressionSlotArray, 0, this.length);
        this.expressions = expressionSlotArray;
    }

    public synchronized void pushExpression(ExpressionSlot expressionSlot) throws DataSourceException {
        if (expressionSlot == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.length + 1);
        this.expressions[this.length] = expressionSlot;
        String string = expressionSlot.getName();
        if (string != null) {
            this.nameCache.put(string, expressionSlot);
        }
        ++this.length;
        expressionSlot.updateDataRow(this.masterRow.getGlobalView());
        expressionSlot.advance();
        if (string != null) {
            Object object = expressionSlot.getValue();
            MasterDataRowChangeEvent masterDataRowChangeEvent = new MasterDataRowChangeEvent(1, string, object);
            this.masterRow.dataRowChanged(masterDataRowChangeEvent);
        }
    }

    public synchronized void pushExpressions(ExpressionSlot[] expressionSlotArray) throws DataSourceException {
        if (expressionSlotArray == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.length + expressionSlotArray.length);
        for (int i = 0; i < expressionSlotArray.length; ++i) {
            ExpressionSlot expressionSlot = expressionSlotArray[i];
            if (expressionSlot == null) continue;
            this.pushExpression(expressionSlot);
        }
    }

    public synchronized void popExpressions(int n) throws DataSourceException {
        for (int i = 0; i < n; ++i) {
            this.popExpression();
        }
    }

    public synchronized void popExpression() throws DataSourceException {
        if (this.length == 0) {
            return;
        }
        String string = this.expressions[this.length - 1].getName();
        boolean bl = this.expressions[this.length - 1].isPreserve();
        this.expressions[this.length - 1] = null;
        --this.length;
        if (string != null) {
            int n = -1;
            for (int i = this.length - 1; i >= 0; --i) {
                ExpressionSlot expressionSlot = this.expressions[i];
                if (!string.equals(expressionSlot.getName())) continue;
                n = i;
                break;
            }
            if (n == -1) {
                this.nameCache.remove(string);
            } else {
                this.nameCache.put(string, this.expressions[n]);
            }
            if (!bl) {
                MasterDataRowChangeEvent masterDataRowChangeEvent = new MasterDataRowChangeEvent(2, string, null);
                this.masterRow.dataRowChanged(masterDataRowChangeEvent);
            }
        }
    }

    public Object get(int n) throws DataSourceException {
        return this.expressions[n].getValue();
    }

    public Object get(String string) throws DataSourceException {
        ExpressionSlot expressionSlot = (ExpressionSlot)this.nameCache.get(string);
        if (expressionSlot == null) {
            return null;
        }
        return expressionSlot.getValue();
    }

    public String getColumnName(int n) {
        return this.expressions[n].getName();
    }

    public int getColumnCount() {
        return this.length;
    }

    public DataFlags getFlags(String string) {
        throw new UnsupportedOperationException();
    }

    public DataFlags getFlags(int n) {
        throw new UnsupportedOperationException();
    }

    public ExpressionDataRow advance(GlobalMasterRow globalMasterRow, boolean bl) throws DataSourceException {
        try {
            ExpressionDataRow expressionDataRow = new ExpressionDataRow(globalMasterRow, this);
            for (int i = expressionDataRow.length - 1; i >= 0; --i) {
                ExpressionSlot expressionSlot = expressionDataRow.expressions[i];
                expressionSlot.updateDataRow(globalMasterRow.getGlobalView());
                if (!bl || bl && expressionSlot.isDeepTraversing()) {
                    expressionSlot.advance();
                }
                Object object = expressionSlot.getValue();
                String string = expressionSlot.getName();
                if (string == null) continue;
                MasterDataRowChangeEvent masterDataRowChangeEvent = new MasterDataRowChangeEvent(3, string, object);
                globalMasterRow.dataRowChanged(masterDataRowChangeEvent);
            }
            return expressionDataRow;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new DataSourceException("Cloning failed", cloneNotSupportedException);
        }
    }

    public ExpressionDataRow derive(GlobalMasterRow globalMasterRow) throws DataSourceException {
        try {
            return new ExpressionDataRow(globalMasterRow, this);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new DataSourceException("Cloning failed", cloneNotSupportedException);
        }
    }

    public ExpressionSlot[] getSlots() {
        ExpressionSlot[] expressionSlotArray = new ExpressionSlot[this.length];
        System.arraycopy(this.expressions, 0, expressionSlotArray, 0, this.length);
        return expressionSlotArray;
    }
}

