/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.expressions.Expression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.ElementLayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;

public class SectionLayoutController
extends ElementLayoutController {
    private Node[] nodes;
    private int index;

    protected FlowController startData(ReportTarget reportTarget, FlowController flowController) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        Section section = (Section)this.getElement();
        return LayoutControllerUtil.processFlowOperations(flowController, section.getOperationBefore());
    }

    protected LayoutController processContent(ReportTarget reportTarget) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        FlowController flowController = this.getFlowController();
        Node[] nodeArray = this.getNodes();
        int n = this.getIndex();
        if (n < nodeArray.length) {
            Node node = nodeArray[n];
            SectionLayoutController sectionLayoutController = (SectionLayoutController)this.clone();
            return this.processChild(sectionLayoutController, node, flowController);
        }
        SectionLayoutController sectionLayoutController = (SectionLayoutController)this.clone();
        sectionLayoutController.setProcessingState(3);
        return sectionLayoutController;
    }

    protected LayoutController processChild(SectionLayoutController sectionLayoutController, Node node, FlowController flowController) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        ReportContext reportContext = flowController.getReportContext();
        LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
        if (this.isDisplayable(node)) {
            sectionLayoutController.setProcessingState(2);
            return layoutControllerFactory.create(flowController, node, sectionLayoutController);
        }
        sectionLayoutController.setProcessingState(2);
        LayoutController layoutController = layoutControllerFactory.create(flowController, node, sectionLayoutController);
        return LayoutControllerUtil.skipInvisibleElement(layoutController);
    }

    protected boolean isDisplayable(Node node) throws DataSourceException {
        if (!node.isEnabled()) {
            return false;
        }
        Expression expression = node.getDisplayCondition();
        if (expression == null) {
            return true;
        }
        Object object = LayoutControllerUtil.evaluateExpression(this.getFlowController(), node, expression);
        return Boolean.TRUE.equals(object);
    }

    protected LayoutController finishElement(ReportTarget reportTarget) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        Object object;
        FlowController flowController = this.handleDefaultEndElement(reportTarget);
        Section section = (Section)this.getElement();
        flowController = this.finishData(reportTarget, flowController);
        if (section.isRepeat() && (object = this.tryRepeatingCommit(flowController)) != null) {
            SectionLayoutController sectionLayoutController = (SectionLayoutController)this.clone();
            sectionLayoutController.setProcessingState(0);
            sectionLayoutController.setFlowController((FlowController)object);
            sectionLayoutController.resetSectionForRepeat();
            return sectionLayoutController;
        }
        object = (SectionLayoutController)this.clone();
        ((ElementLayoutController)object).setProcessingState(4);
        ((ElementLayoutController)object).setFlowController(flowController);
        return object;
    }

    protected void resetSectionForRepeat() {
        this.setIndex(0);
    }

    protected FlowController finishData(ReportTarget reportTarget, FlowController flowController) throws DataSourceException, ReportProcessingException {
        Section section = (Section)this.getElement();
        return LayoutControllerUtil.processFlowOperations(flowController, section.getOperationAfter());
    }

    public LayoutController join(FlowController flowController) {
        Cloneable cloneable;
        int n;
        Node[] nodeArray = this.getNodes();
        for (n = this.getIndex() + 1; n < nodeArray.length && !((Node)(cloneable = nodeArray[n])).isEnabled(); ++n) {
        }
        if (n < nodeArray.length) {
            cloneable = (SectionLayoutController)this.clone();
            ((ElementLayoutController)cloneable).setProcessingState(1);
            ((ElementLayoutController)cloneable).setFlowController(flowController);
            ((SectionLayoutController)cloneable).setIndex(n);
            return cloneable;
        }
        cloneable = (SectionLayoutController)this.clone();
        ((ElementLayoutController)cloneable).setProcessingState(3);
        ((ElementLayoutController)cloneable).setFlowController(flowController);
        return cloneable;
    }

    public Node[] getNodes() {
        if (this.nodes == null) {
            Section section = (Section)this.getElement();
            this.nodes = section.getNodeArray();
        }
        return this.nodes;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }
}

