/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.BeanUtility;
import org.jfree.report.util.beans.ValueConverter;

public class GenericValueConverter
implements ValueConverter {
    private PropertyDescriptor propertyDescriptor;
    private PropertyEditor propertyEditor;

    public GenericValueConverter(PropertyDescriptor propertyDescriptor) throws IntrospectionException {
        if (propertyDescriptor == null) {
            throw new NullPointerException("PropertyDescriptor must not be null.");
        }
        if (propertyDescriptor.getPropertyEditorClass() == null) {
            throw new IntrospectionException("Property has no editor.");
        }
        this.propertyDescriptor = propertyDescriptor;
        this.propertyEditor = this.createPropertyEditor(propertyDescriptor);
    }

    private PropertyEditor createPropertyEditor(PropertyDescriptor propertyDescriptor) throws IntrospectionException {
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        try {
            return (PropertyEditor)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IntrospectionException("Unable to create PropertyEditor.");
        }
    }

    public String toAttributeValue(Object object) throws BeanException {
        if (!BeanUtility.getPropertyType(this.propertyDescriptor).isInstance(object)) {
            throw new ClassCastException("Give me a real type.");
        }
        this.propertyEditor.setValue(object);
        return this.propertyEditor.getAsText();
    }

    public Object toPropertyValue(String string) {
        this.propertyEditor.setAsText(string);
        return this.propertyEditor.getValue();
    }
}

