/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XDialog;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.MainThreadDialogExecutor;
import com.sun.star.wiki.WikiDialog;
import com.sun.star.wiki.WikiEditSettingDialog;
import com.sun.star.wiki.WikiEditorImpl;
import java.util.Map;

public class WikiPropDialog
extends WikiDialog {
    private WikiEditorImpl m_aWikiEditor;
    private static final String sSendMethod = "Send";
    private static final String sWikiListMethod = "WikiListChange";
    private static final String sArticleTextMethod = "ArticleTextChange";
    private static final String sAddWikiMethod = "AddWiki";
    private final String[] m_pMethods = new String[]{"Send", "WikiListChange", "ArticleTextChange", "AddWiki"};
    private String m_sWikiTitle = "";
    private String m_sWikiEngineURL = "";
    protected String m_sWikiComment = "";
    protected boolean m_bWikiMinorEdit = false;

    public WikiPropDialog(XComponentContext xContext, String DialogURL, WikiEditorImpl aWikiEditorForThrobber) {
        super(xContext, DialogURL);
        super.setMethods(this.m_pMethods);
        if (aWikiEditorForThrobber != null) {
            this.InsertThrobber(224, 122, 10, 10);
            this.m_aWikiEditor = aWikiEditorForThrobber;
        }
        this.InitStrings(xContext);
        this.InitShowBrowser();
        this.InitControls();
    }

    private void InitControls() {
        try {
            this.GetPropSet("CommentText").setPropertyValue("AutoVScroll", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void InitStrings(XComponentContext xContext) {
        try {
            this.SetTitle(Helper.GetLocalizedString(xContext, 6));
            this.GetPropSet("Label1").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 20));
            this.GetPropSet("FixedLine2").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 7));
            this.GetPropSet("Label2").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 21));
            this.GetPropSet("Label3").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 22));
            this.GetPropSet("MinorCheck").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 23));
            this.GetPropSet("BrowserCheck").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 24));
            this.GetPropSet("AddButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 12));
            this.GetPropSet("SendButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 14));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void InitShowBrowser() {
        try {
            this.GetPropSet("BrowserCheck").setPropertyValue("State", (Object)(Helper.GetShowInBrowserByDefault(this.m_xContext) ? (short)1 : 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean show() {
        this.EnableControls(true);
        boolean bResult = super.show();
        if (bResult && Helper.GetShowInBrowserByDefault(this.m_xContext)) {
            Helper.ShowURLInBrowser(this.m_xContext, this.m_sWikiEngineURL + "index.php?title=" + this.m_sWikiTitle);
        }
        return bResult;
    }

    public synchronized void ThreadStop(boolean bSelf) {
        boolean bShowError = !bSelf && this.m_aThread != null && !this.m_bThreadFinished;
        super.ThreadStop(bSelf);
        if (bShowError) {
            Helper.ShowError(this.m_xContext, this.m_xDialog, 6, 30, null, false);
        }
    }

    public void fillWikiList() {
        String[] WikiList = this.m_aSettings.getWikiURLs();
        try {
            XPropertySet xPS = this.GetPropSet("WikiList");
            xPS.setPropertyValue("StringItemList", (Object)WikiList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void fillDocList() {
        XPropertySet xPS = this.GetPropSet("ArticleText");
        try {
            short[] sel = (short[])this.GetPropSet("WikiList").getPropertyValue("SelectedItems");
            xPS.setPropertyValue("StringItemList", (Object)this.m_aSettings.getWikiDocList(sel[0]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String GetWikiTitle() {
        return this.m_sWikiTitle;
    }

    public void SetWikiTitle(String sArticle) {
        this.m_sWikiTitle = sArticle;
        try {
            XPropertySet xPS = this.GetPropSet("ArticleText");
            xPS.setPropertyValue("Text", (Object)sArticle);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void switchSendButtonIfNecessary() {
        XPropertySet xSendButton = this.GetPropSet("SendButton");
        if (xSendButton != null) {
            XPropertySet xWikiListProps = this.GetPropSet("WikiList");
            XPropertySet xArticleProps = this.GetPropSet("ArticleText");
            if (xWikiListProps != null && xArticleProps != null) {
                try {
                    short[] pSel = (short[])this.GetPropSet("WikiList").getPropertyValue("SelectedItems");
                    String sArticle = (String)xArticleProps.getPropertyValue("Text");
                    if (pSel != null && pSel.length > 0 && sArticle != null && sArticle.length() != 0) {
                        xSendButton.setPropertyValue("Enabled", (Object)Boolean.TRUE);
                    } else {
                        xSendButton.setPropertyValue("Enabled", (Object)Boolean.FALSE);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void EnableControls(boolean bEnable) {
        try {
            String[] pControls = new String[]{"WikiList", "ArticleText", "CommentText", "MinorCheck", "BrowserCheck", "HelpButton", "AddButton"};
            for (int nInd = 0; nInd < pControls.length; ++nInd) {
                this.GetPropSet(pControls[nInd]).setPropertyValue("Enabled", (Object)bEnable);
            }
            if (bEnable) {
                this.SetFocusTo("WikiList");
                this.switchSendButtonIfNecessary();
            } else {
                this.GetPropSet("SendButton").setPropertyValue("Enabled", (Object)bEnable);
                this.SetFocusTo("CancelButton");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean callHandlerMethod(XDialog xDialog, Object EventObject2, String MethodName) {
        if (MethodName.equals(sSendMethod)) {
            try {
                XPropertySet aWikiListProps = this.GetPropSet("WikiList");
                XPropertySet aArticleTextProps = this.GetPropSet("ArticleText");
                XPropertySet aCommentTextProps = this.GetPropSet("CommentText");
                XPropertySet aMinorCheckProps = this.GetPropSet("MinorCheck");
                XPropertySet aBrowserCheckProps = this.GetPropSet("BrowserCheck");
                short[] sel = (short[])aWikiListProps.getPropertyValue("SelectedItems");
                String[] items = (String[])aWikiListProps.getPropertyValue("StringItemList");
                this.m_sWikiEngineURL = items[sel[0]];
                this.m_sWikiTitle = (String)aArticleTextProps.getPropertyValue("Text");
                this.m_sWikiComment = (String)aCommentTextProps.getPropertyValue("Text");
                short minorState = (Short)aMinorCheckProps.getPropertyValue("State");
                this.m_bWikiMinorEdit = minorState != 0;
                short nBrowserState = (Short)aBrowserCheckProps.getPropertyValue("State");
                Helper.SetShowInBrowserByDefault(this.m_xContext, nBrowserState != 0);
                this.EnableControls(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            final XDialog xDialogToClose = xDialog;
            final XComponentContext xContext = this.m_xContext;
            this.SetThrobberVisible(true);
            this.SetThrobberActive(true);
            final Map<String, String> aWikiSettings = this.m_aSettings.getSettingByUrl(this.m_sWikiEngineURL);
            if (Helper.AllowThreadUsage(this.m_xContext)) {
                this.m_aThread = new Thread("com.sun.star.thread.WikiEditorSendingThread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            if (WikiPropDialog.this.m_aWikiEditor != null) {
                                Thread.yield();
                                WikiPropDialog.this.m_bAction = WikiPropDialog.this.m_aWikiEditor.SendArticleImpl(WikiPropDialog.this, aWikiSettings);
                            }
                        }
                        finally {
                            WikiPropDialog.this.EnableControls(true);
                            WikiPropDialog.this.SetThrobberActive(false);
                            WikiPropDialog.this.SetThrobberVisible(false);
                            WikiPropDialog.this.ThreadStop(true);
                            if (WikiPropDialog.this.m_bAction) {
                                MainThreadDialogExecutor.Close(xContext, xDialogToClose);
                            }
                        }
                    }
                };
                this.m_aThread.start();
            } else {
                try {
                    if (this.m_aWikiEditor != null) {
                        this.m_bAction = this.m_aWikiEditor.SendArticleImpl(this, aWikiSettings);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.EnableControls(true);
                    this.SetThrobberActive(false);
                    this.SetThrobberVisible(false);
                    if (this.m_bAction) {
                        xDialogToClose.endExecute();
                    }
                }
            }
            return true;
        }
        if (MethodName.equals(sWikiListMethod)) {
            this.fillDocList();
            this.switchSendButtonIfNecessary();
            return true;
        }
        if (MethodName.equals(sArticleTextMethod)) {
            this.switchSendButtonIfNecessary();
            return true;
        }
        if (MethodName.equals(sAddWikiMethod)) {
            WikiEditSettingDialog xAddDialog = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application");
            if (xAddDialog.show()) {
                this.fillWikiList();
            }
            xAddDialog.DisposeDialog();
            return true;
        }
        return false;
    }

    public void windowClosed(EventObject e) {
        this.ThreadStop(false);
    }
}

