/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.SectionLayoutController;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.model.OfficeGroup;
import org.libreoffice.report.pentaho.model.OfficeReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeTableTemplateLayoutController
extends SectionLayoutController {
    private Node[] nodes;

    @Override
    public void initialize(Object node, FlowController flowController, LayoutController parent) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        Section section = new Section();
        section.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
        section.setType("template");
        super.initialize(section, flowController, parent);
        OfficeReport report = (OfficeReport)node;
        ArrayList<Node> tables = new ArrayList<Node>();
        if (report.getPageHeader() != null) {
            this.addFromSection(tables, (Section)report.getPageHeader());
        }
        if (report.getReportHeader() != null) {
            this.addFromSection(tables, (Section)report.getReportHeader());
        }
        this.addPBody(tables, (Section)report.getPreBodySection());
        this.addFromBody(tables, (Section)report.getBodySection());
        this.addPBody(tables, (Section)report.getPostBodySection());
        if (report.getReportFooter() != null) {
            this.addFromSection(tables, (Section)report.getReportFooter());
        }
        if (report.getPageFooter() != null) {
            this.addFromSection(tables, (Section)report.getPageFooter());
        }
        this.nodes = tables.toArray(new Node[tables.size()]);
    }

    private void addPBody(List<Node> tables, Section section) {
        if (section != null) {
            Node[] nodeArray = section.getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                tables.add(node);
            }
        }
    }

    private void addFromBody(List<Node> tables, Section section) {
        Node[] nodeArray = section.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            if (!(node instanceof Section)) continue;
            Section child = (Section)node;
            if (node instanceof OfficeGroup) {
                this.addFromGroup(tables, child);
                continue;
            }
            this.addFromSection(tables, child);
        }
    }

    private void addFromGroup(List<Node> tables, Section section) {
        Node[] nodeArray = section.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            if (!(node instanceof Section)) continue;
            Section element = (Section)node;
            if ("http://jfreereport.sourceforge.net/namespaces/engine".equals(element.getNamespace()) && "group-body".equals(element.getType())) {
                this.addFromBody(tables, element);
                continue;
            }
            this.addFromSection(tables, element);
        }
    }

    private void addFromSection(List<Node> tables, Section section) {
        Node[] nodeArray = section.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Element element;
            Node node = nodeArray[i];
            if (!(node instanceof Element) || !"urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals((element = (Element)node).getNamespace()) || !"table".equals(element.getType())) continue;
            tables.add(element);
        }
    }

    @Override
    public Node[] getNodes() {
        return this.nodes;
    }
}

