/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.util;

import java.util.HashMap;
import java.util.Map;
import org.libreoffice.report.JobDefinitionException;
import org.libreoffice.report.JobProperties;
import org.libreoffice.report.ReportEngineMetaData;

public class DefaultJobProperties
implements JobProperties {
    private final ReportEngineMetaData metaData;
    private final Map<String, Object> properties;

    public DefaultJobProperties(ReportEngineMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.properties = new HashMap<String, Object>();
        this.metaData = metaData;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) throws JobDefinitionException {
        Class type = this.metaData.getParameterType(key);
        if (type == null) {
            throw new JobDefinitionException("The parameter name is not known: " + key);
        }
        if (!type.isInstance(value)) {
            throw new JobDefinitionException("The parameter value is not understood");
        }
        this.properties.put(key, value);
    }

    public JobProperties copy() {
        DefaultJobProperties props = new DefaultJobProperties(this.metaData);
        props.properties.putAll(this.properties);
        return props;
    }
}

