/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;

public class ParagraphPoolBox
extends InlineRenderBox {
    private RenderLength lineHeight;

    public ParagraphPoolBox(BoxDefinition boxDefinition) {
        super(boxDefinition);
    }

    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        super.appyStyle(layoutContext, outputProcessorMetaData);
        CSSValue cSSValue = layoutContext.getValue(LineStyleKeys.LINE_HEIGHT);
        this.lineHeight = RenderLength.convertToInternal(cSSValue, layoutContext, outputProcessorMetaData);
    }

    public RenderLength getLineHeight() {
        return this.lineHeight;
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        RenderBox renderBox = this.getParent();
        super.close();
        if (renderBox != null) {
            renderBox.close();
        }
    }

    public void trim() {
        RenderNode renderNode = this.getFirstChild();
        while (renderNode != null && renderNode.isIgnorableForRendering()) {
            this.remove(renderNode);
            renderNode = this.getFirstChild();
        }
        renderNode = this.getLastChild();
        while (renderNode != null && renderNode.isIgnorableForRendering()) {
            this.remove(renderNode);
            renderNode = this.getLastChild();
        }
    }

    public void setParent(RenderBox renderBox) {
        super.setParent(renderBox);
    }
}

