/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.page;

import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;

public class PageGridUtility {
    private PageGridUtility() {
    }

    public static PageSize lookupPageSize(CSSValue cSSValue, OutputProcessorMetaData outputProcessorMetaData) {
        if (!(cSSValue instanceof CSSValuePair)) {
            PageSize pageSize = outputProcessorMetaData.getDefaultPageSize();
            return pageSize;
        }
        CSSValuePair cSSValuePair = (CSSValuePair)cSSValue;
        CSSValue cSSValue2 = cSSValuePair.getFirstValue();
        if (!(cSSValue2 instanceof CSSNumericValue)) {
            PageSize pageSize = outputProcessorMetaData.getDefaultPageSize();
            return pageSize;
        }
        CSSValue cSSValue3 = cSSValuePair.getSecondValue();
        if (!(cSSValue3 instanceof CSSNumericValue)) {
            PageSize pageSize = outputProcessorMetaData.getDefaultPageSize();
            return pageSize;
        }
        double d = CSSValueResolverUtility.convertLengthToDouble(cSSValue2, null, outputProcessorMetaData);
        double d2 = CSSValueResolverUtility.convertLengthToDouble(cSSValue3, null, outputProcessorMetaData);
        if (d < 1.0 || d2 < 1.0) {
            PageSize pageSize = outputProcessorMetaData.getDefaultPageSize();
            return pageSize;
        }
        return new PageSize(d, d2);
    }
}

