/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;

public class BoxShifter {
    public void shiftBox(RenderBox renderBox, long l) {
        if (l == 0L) {
            return;
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Cannot shift upwards: " + l);
        }
        renderBox.setY(renderBox.getY() + l);
        this.shiftBoxInternal(renderBox, l);
    }

    public void shiftBoxUnchecked(RenderBox renderBox, long l) {
        if (l == 0L) {
            return;
        }
        renderBox.setY(renderBox.getY() + l);
        this.shiftBoxInternal(renderBox, l);
    }

    private void shiftBoxInternal(RenderBox renderBox, long l) {
        for (RenderNode renderNode = renderBox.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            renderNode.setY(renderNode.getY() + l);
            if (!(renderNode instanceof RenderBox)) continue;
            this.shiftBoxInternal((RenderBox)renderNode, l);
        }
    }

    public void extendHeight(RenderNode renderNode, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Cannot shrink elements.");
        }
        if (renderNode == null || l == 0L) {
            return;
        }
        renderNode.setHeight(renderNode.getHeight() + l);
        for (RenderBox renderBox = renderNode.getParent(); renderBox != null; renderBox = renderBox.getParent()) {
            renderBox.setHeight(renderBox.getHeight() + l);
        }
    }
}

