/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.io.Serializable;

public class LongList
implements Serializable,
Cloneable {
    private static final long[] EMPTY_ARRAY = new long[0];
    private long[] data;
    private int size;
    private int increment;

    public LongList(int n) {
        this.data = new long[n];
        this.increment = n;
    }

    private void ensureCapacity(int n) {
        if (this.data.length <= n) {
            long[] lArray = new long[Math.max(this.data.length + this.increment, n + 1)];
            System.arraycopy(this.data, 0, lArray, 0, this.size);
            this.data = lArray;
        }
    }

    public void add(long l) {
        this.ensureCapacity(this.size);
        this.data[this.size] = l;
        ++this.size;
    }

    public void set(int n, long l) {
        this.ensureCapacity(n);
        this.data[n] = l;
        if (n >= this.size) {
            this.size = n + 1;
        }
    }

    public long get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Illegal Index: " + n + " Max:" + this.size);
        }
        return this.data[n];
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public long[] toArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        return (long[])this.data.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        LongList longList = (LongList)super.clone();
        longList.data = (long[])this.data.clone();
        return this.data;
    }
}

