/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.itext;

import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.fonts.cache.FirstLevelFontCache;
import org.pentaho.reporting.libraries.fonts.itext.ITextFontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.itext.ITextFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class ITextFontStorage
implements FontStorage {
    private ITextFontRegistry registry;
    private ITextFontMetricsFactory metricsFactory;
    private EncodingFontKey lookupKey = new EncodingFontKey();
    private FirstLevelFontCache knownMetrics;
    private String defaultEncoding;
    private int hits;
    private int misses;

    public ITextFontStorage() {
        this.registry = new ITextFontRegistry();
        this.registry.initialize();
        this.knownMetrics = new FirstLevelFontCache(this.registry.getSecondLevelCache());
        this.metricsFactory = (ITextFontMetricsFactory)this.registry.createMetricsFactory();
    }

    public ITextFontStorage(ITextFontRegistry registry) {
        this(registry, null);
    }

    public ITextFontStorage(ITextFontRegistry registry, String encoding) {
        this.knownMetrics = new FirstLevelFontCache(registry.getSecondLevelCache());
        this.registry = registry;
        this.defaultEncoding = encoding;
        this.metricsFactory = (ITextFontMetricsFactory)registry.createMetricsFactory();
    }

    public FontRegistry getFontRegistry() {
        return this.registry;
    }

    public FontMetrics getFontMetrics(FontIdentifier rawRecord, FontContext context) {
        if (rawRecord == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        String contextEncoding = context.getEncoding();
        String effectiveEncoding = contextEncoding == null ? this.defaultEncoding : contextEncoding;
        this.lookupKey.setAliased(context.isAntiAliased());
        this.lookupKey.setFontSize(context.getFontSize());
        this.lookupKey.setIdentifier(rawRecord);
        this.lookupKey.setFractional(context.isFractionalMetrics());
        this.lookupKey.setEncoding(effectiveEncoding);
        FontMetrics cachedMetrics = this.knownMetrics.getFontMetrics(this.lookupKey);
        if (cachedMetrics != null) {
            ++this.hits;
            return cachedMetrics;
        }
        ++this.misses;
        EncodingFontContextWrapper contextWrapper = new EncodingFontContextWrapper(context, effectiveEncoding);
        FontMetrics metrics = this.metricsFactory.createMetrics(rawRecord, contextWrapper);
        EncodingFontKey key = new EncodingFontKey(rawRecord, context.isAntiAliased(), context.isFractionalMetrics(), context.getFontSize(), effectiveEncoding);
        this.knownMetrics.putFontMetrics(key, metrics);
        return metrics;
    }

    public void commit() {
        DebugLog.log((Object)("Font-Storage: hits=" + this.hits + ", misses=" + this.misses));
        this.metricsFactory.close();
        this.knownMetrics.commit();
    }

    private static class EncodingFontKey
    extends FontKey {
        private String encoding;

        public EncodingFontKey(FontIdentifier identifier, boolean aliased, boolean fractional, double fontSize, String encoding) {
            super(identifier, aliased, fractional, fontSize);
            this.encoding = encoding;
        }

        public EncodingFontKey() {
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EncodingFontKey that = (EncodingFontKey)o;
            return !(this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
            return result;
        }
    }

    private static class EncodingFontContextWrapper
    implements FontContext {
        private FontContext context;
        private String defaultEncoding;

        private EncodingFontContextWrapper(FontContext context, String defaultEncoding) {
            this.context = context;
            this.defaultEncoding = defaultEncoding;
        }

        public String getEncoding() {
            return this.defaultEncoding;
        }

        public boolean isEmbedded() {
            return this.context.isEmbedded();
        }

        public boolean isAntiAliased() {
            return this.context.isAntiAliased();
        }

        public boolean isFractionalMetrics() {
            return this.context.isFractionalMetrics();
        }

        public double getFontSize() {
            return this.context.getFontSize();
        }
    }
}

