/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.unoloader;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public final class UnoClassLoader
extends URLClassLoader {
    public UnoClassLoader(URL base, URL[] classPath, ClassLoader parent) throws MalformedURLException {
        super(UnoClassLoader.createUrls(base, classPath), parent);
    }

    public ClassLoader getClassLoader(URL jar, Attributes mainAttributes) throws MalformedURLException {
        String path;
        String string = path = mainAttributes == null ? null : mainAttributes.getValue("UNO-Type-Path");
        if (path == null) {
            path = "<>";
        }
        int i = 0;
        while (i < path.length()) {
            String url;
            int j;
            while (i < path.length() && path.charAt(i) == ' ') {
                ++i;
            }
            if (i >= path.length()) continue;
            if (path.charAt(i) == '<') {
                j = path.indexOf(62, i + 1);
                if (j < 0) {
                    url = path.substring(i + 1);
                    i = path.length();
                } else {
                    url = path.substring(i + 1, j);
                    i = j + 1;
                }
            } else {
                j = path.indexOf(32, i + 1);
                if (j < 0) {
                    j = path.length();
                }
                url = path.substring(i, j);
                i = j;
            }
            this.addURL(new URL(jar, url));
        }
        return URLClassLoader.newInstance(new URL[]{jar}, this);
    }

    public void execute(URL jar, String[] arguments) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String name;
        Attributes attr = UnoClassLoader.getJarMainAttributes(jar);
        String string = name = attr == null ? null : attr.getValue(Attributes.Name.MAIN_CLASS);
        if (name == null) {
            throw new ClassNotFoundException(jar + " does not specify a main class");
        }
        try {
            this.getClassLoader(jar, attr).loadClass(name.replace('/', '.')).getMethod("main", String[].class).invoke(null, new Object[]{arguments});
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("impossible " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attributes getJarMainAttributes(URL jar) throws IOException {
        Manifest mf;
        JarInputStream s = new JarInputStream(jar.openStream());
        try {
            mf = s.getManifest();
        }
        finally {
            s.close();
        }
        return mf == null ? null : mf.getMainAttributes();
    }

    private static URL[] createUrls(URL base, URL[] classPath) throws MalformedURLException {
        int JARS = 4;
        URL[] urls = new URL[4 + (classPath == null ? 0 : classPath.length)];
        urls[0] = new URL(base, "java_uno.jar");
        urls[1] = new URL(base, "juh.jar");
        urls[2] = new URL(base, "jurt.jar");
        urls[3] = new URL(base, "ridl.jar");
        if (classPath != null) {
            System.arraycopy(classPath, 0, urls, 4, classPath.length);
        }
        return urls;
    }
}

