/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.protocols.urp.Cache;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.Enum;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IFieldDescription;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XInterface;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

final class Marshal {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final DataOutput output = new DataOutputStream(this.buffer);
    private final IBridge bridge;
    private final Cache objectIdCache;
    private final Cache threadIdCache;
    private final Cache typeCache;

    public Marshal(IBridge bridge, short cacheSize) {
        this.bridge = bridge;
        this.objectIdCache = new Cache(cacheSize);
        this.threadIdCache = new Cache(cacheSize);
        this.typeCache = new Cache(cacheSize);
    }

    public void write8Bit(int value) {
        try {
            this.output.writeByte(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write16Bit(int value) {
        try {
            this.output.writeShort(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeObjectId(String objectId) {
        try {
            if (objectId == null) {
                this.writeStringValue(null);
                this.write16Bit(65535);
            } else {
                boolean[] found = new boolean[1];
                int index = this.objectIdCache.add(found, objectId);
                this.writeStringValue(found[0] ? null : objectId);
                this.write16Bit(index);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeInterface(XInterface object, Type type) {
        this.writeObjectId((String)this.bridge.mapInterfaceTo(object, type));
    }

    public void writeThreadId(ThreadId threadId) {
        try {
            byte[] data = threadId.getBytes();
            boolean[] found = new boolean[1];
            int index = this.threadIdCache.add(found, data);
            if (found[0]) {
                this.writeCompressedNumber(0);
            } else {
                this.writeCompressedNumber(data.length);
                this.writeBytes(data);
            }
            this.write16Bit(index);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeType(TypeDescription type) {
        try {
            TypeClass typeClass = type.getTypeClass();
            if (TypeDescription.isTypeClassSimple(typeClass)) {
                this.write8Bit(typeClass.getValue());
            } else {
                boolean[] found = new boolean[1];
                int index = this.typeCache.add(found, type.getTypeName());
                this.write8Bit(typeClass.getValue() | (found[0] ? 0 : 128));
                this.write16Bit(index);
                if (!found[0]) {
                    this.writeStringValue(type.getTypeName());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeValue(TypeDescription type, Object value) {
        try {
            switch (type.getTypeClass().getValue()) {
                case 0: {
                    break;
                }
                case 2: {
                    this.writeBooleanValue((Boolean)value);
                    break;
                }
                case 3: {
                    this.writeByteValue((Byte)value);
                    break;
                }
                case 4: 
                case 5: {
                    this.writeShortValue((Short)value);
                    break;
                }
                case 6: 
                case 7: {
                    this.writeLongValue((Integer)value);
                    break;
                }
                case 8: 
                case 9: {
                    this.writeHyperValue((Long)value);
                    break;
                }
                case 10: {
                    this.writeFloatValue((Float)value);
                    break;
                }
                case 11: {
                    this.writeDoubleValue((Double)value);
                    break;
                }
                case 1: {
                    this.writeCharValue((Character)value);
                    break;
                }
                case 12: {
                    this.writeStringValue((String)value);
                    break;
                }
                case 13: {
                    this.writeTypeValue((Type)value);
                    break;
                }
                case 14: {
                    this.writeAnyValue(value);
                    break;
                }
                case 20: {
                    this.writeSequenceValue(type, value);
                    break;
                }
                case 15: {
                    this.writeEnumValue(type, (Enum)value);
                    break;
                }
                case 17: {
                    this.writeStructValue(type, value);
                    break;
                }
                case 19: {
                    this.writeExceptionValue(type, (Exception)value);
                    break;
                }
                case 22: {
                    this.writeInterfaceValue(type, (XInterface)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad type descriptor " + type);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] reset() {
        byte[] data = this.buffer.toByteArray();
        this.buffer.reset();
        return data;
    }

    private void writeBooleanValue(Boolean value) throws IOException {
        this.output.writeBoolean(value != null && value != false);
    }

    private void writeByteValue(Byte value) {
        this.write8Bit(value == null ? (byte)0 : value);
    }

    private void writeShortValue(Short value) {
        this.write16Bit(value == null ? (short)0 : value);
    }

    private void writeLongValue(Integer value) throws IOException {
        this.write32Bit(value == null ? 0 : value);
    }

    private void writeHyperValue(Long value) throws IOException {
        this.output.writeLong(value == null ? 0L : value);
    }

    private void writeFloatValue(Float value) throws IOException {
        this.output.writeFloat(value == null ? 0.0f : value.floatValue());
    }

    private void writeDoubleValue(Double value) throws IOException {
        this.output.writeDouble(value == null ? 0.0 : value);
    }

    private void writeCharValue(Character value) throws IOException {
        this.output.writeChar(value == null ? (char)'\u0000' : value.charValue());
    }

    private void writeStringValue(String value) throws IOException {
        if (value == null) {
            this.writeCompressedNumber(0);
        } else {
            byte[] data = value.getBytes("UTF8");
            this.writeCompressedNumber(data.length);
            this.writeBytes(data);
        }
    }

    private void writeTypeValue(Type value) throws ClassNotFoundException {
        this.writeType(TypeDescription.getTypeDescription(value == null ? Type.VOID : value));
    }

    private void writeAnyValue(Object value) throws ClassNotFoundException {
        TypeDescription type;
        if (value == null || value instanceof XInterface) {
            type = TypeDescription.getTypeDescription(XInterface.class);
        } else if (value instanceof Any) {
            Any any = (Any)value;
            type = TypeDescription.getTypeDescription(any.getType());
            value = any.getObject();
        } else {
            if (value.getClass() == Object.class) {
                throw new IllegalArgumentException("Object instance does not represent UNO value");
            }
            type = TypeDescription.getTypeDescription(value.getClass());
        }
        this.writeType(type);
        this.writeValue(type, value);
    }

    private void writeSequenceValue(TypeDescription type, Object value) throws IOException {
        if (value == null) {
            this.writeCompressedNumber(0);
        } else {
            TypeDescription ctype = (TypeDescription)type.getComponentType();
            if (ctype.getTypeClass() == TypeClass.BYTE) {
                byte[] data = (byte[])value;
                this.writeCompressedNumber(data.length);
                this.writeBytes(data);
            } else {
                int len = Array.getLength(value);
                this.writeCompressedNumber(len);
                for (int i = 0; i < len; ++i) {
                    this.writeValue(ctype, Array.get(value, i));
                }
            }
        }
    }

    private void writeEnumValue(TypeDescription type, Enum value) throws IllegalAccessException, IOException, InvocationTargetException, NoSuchMethodException {
        int n = value == null ? ((Enum)type.getZClass().getMethod("getDefault", null).invoke(null, (Object[])null)).getValue() : value.getValue();
        this.write32Bit(n);
    }

    private void writeStructValue(TypeDescription type, Object value) throws IllegalAccessException {
        IFieldDescription[] fields = type.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            this.writeValue((TypeDescription)fields[i].getTypeDescription(), value == null ? null : fields[i].getField().get(value));
        }
    }

    private void writeExceptionValue(TypeDescription type, Exception value) throws IllegalAccessException, IOException {
        this.writeStringValue(value == null ? null : value.getMessage());
        this.writeStructValue(type, value);
    }

    private void writeInterfaceValue(TypeDescription type, XInterface value) {
        this.writeInterface(value, new Type(type));
    }

    private void write32Bit(int value) throws IOException {
        this.output.writeInt(value);
    }

    private void writeCompressedNumber(int number) throws IOException {
        if (number >= 0 && number < 255) {
            this.write8Bit(number);
        } else {
            this.write8Bit(255);
            this.write32Bit(number);
        }
    }

    private void writeBytes(byte[] data) throws IOException {
        this.output.write(data);
    }
}

