/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.TextEvent;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XRadioButton;
import com.sun.star.awt.XTextListener;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertyContainer;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.HelpIds;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.QueryMetaData;
import com.sun.star.wizards.db.SQLQueryComposer;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.WizardDialog;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilterComponent {
    private final Integer IStep;
    private final int RowCount;
    private static String[] sLogicOperators;
    private final XRadioButton optMatchAny;
    private final String slblFieldNames;
    private final String slblOperators;
    private final String slblValue;
    private WizardDialog CurUnoDialog;
    private static final int BaseID = 2300;
    private final String sIncSuffix;
    private final ControlRow[] oControlRows;
    private final String sDuplicateCondition;
    private static final int SOOPTORMODE = 100;
    private static final int SOOPTANDMODE = 101;
    private QueryMetaData oQueryMetaData;
    private int iDateFormat;
    private int iTimeFormat;
    private PropertyValue[][] filterconditions;
    private short curtabindex;
    private static final int SO_FIRSTFIELDNAME = 1;
    private static final int SO_SECONDFIELDNAME = 2;
    private static final int SO_THIRDFIELDNAME = 3;
    private static final int SO_FOURTHFIELDNAME = 4;
    private int[] SO_FIELDNAMELIST = new int[]{1, 2, 3, 4};
    private static final int SO_FIRSTCONDITION = 5;
    private static final int SO_SECONDCONDITION = 6;
    private static final int SO_THIRDCONDITION = 7;
    private static final int SO_FOURTHCONDITION = 8;
    private int[] SO_CONDITIONLIST = new int[]{5, 6, 7, 8};
    private static final int SO_FIRSTTEXTFIELD = 1;
    private static final int SO_SECONDTEXTFIELD = 2;
    private static final int SO_THIRDTEXTFIELD = 3;
    private static final int SO_FOURTHTEXTFIELD = 4;
    private int[] SO_TEXTFIELDLIST = new int[]{1, 2, 3, 4};
    private static final int SO_FIRSTBOOLFIELDNAME = 257;
    private static final int SO_SECONDBOOLFIELDNAME = 258;
    private static final int SO_THIRDBOOLFIELDNAME = 259;
    private static final int SO_FOURTHBOOLFIELDNAME = 260;
    private int SOI_MATCHALL = 0;
    private int SOI_MATCHANY = 1;

    private static String getIndexNumber(String _sStr) {
        return _sStr.substring(_sStr.length() - 1, _sStr.length());
    }

    private void togglefollowingControlRow(String _scurName) {
        int Index = Integer.parseInt(FilterComponent.getIndexNumber(_scurName));
        if (Index < this.oControlRows.length) {
            boolean bValue = this.oControlRows[Index - 1].isConditionComplete();
            this.oControlRows[Index].setEnabled(bValue);
        }
    }

    private String getControlName(Object _oSourceevent) {
        try {
            XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)_oSourceevent);
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControl.getModel());
            return AnyConverter.toString((Object)xPSet.getPropertyValue(PropertyNames.PROPERTY_NAME));
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(System.err);
            return PropertyNames.EMPTY_STRING;
        }
    }

    public PropertyValue[][] getFilterConditions() {
        int nFilterCount = this.getFilterCount();
        if (nFilterCount > 0) {
            SQLQueryComposer composer = this.oQueryMetaData.getSQLQueryComposer();
            try {
                String serviceName = "com.sun.star.beans.PropertyBag";
                XPropertyContainer column = (XPropertyContainer)UnoRuntime.queryInterface(XPropertyContainer.class, (Object)this.oQueryMetaData.xMSF.createInstance("com.sun.star.beans.PropertyBag"));
                column.addProperty("Type", (short)2, (Object)12);
                column.addProperty(PropertyNames.PROPERTY_NAME, (short)2, (Object)PropertyNames.EMPTY_STRING);
                column.addProperty("Value", (short)129, null);
                XPropertySet columnSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)column);
                if (composer.getQuery().length() == 0) {
                    StringBuilder sql = new StringBuilder();
                    sql.append(composer.getSelectClause(true));
                    sql.append(' ');
                    sql.append((CharSequence)composer.getFromClause());
                    composer.getQueryComposer().setElementaryQuery(sql.toString());
                }
                composer.getQueryComposer().setStructuredFilter((PropertyValue[][])new PropertyValue[0][]);
                for (int i = 0; i < this.RowCount; ++i) {
                    ControlRow currentControlRow = this.oControlRows[i];
                    if (!currentControlRow.isEnabled() || !currentControlRow.isConditionComplete()) continue;
                    String sFieldName = currentControlRow.getSelectedFieldName();
                    short nOperator = currentControlRow.getSelectedOperator();
                    FieldColumn aFieldColumn = this.oQueryMetaData.getFieldColumnByDisplayName(sFieldName);
                    columnSet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)aFieldColumn.getFieldName());
                    columnSet.setPropertyValue("Type", aFieldColumn.getXColumnPropertySet().getPropertyValue("Type"));
                    Object value = currentControlRow.getValue();
                    switch (aFieldColumn.getFieldType()) {
                        case 91: 
                        case 93: {
                            value = (Double)value - (double)this.oQueryMetaData.getNullDateCorrection();
                        }
                    }
                    column.removeProperty("Value");
                    short operator = currentControlRow.getSelectedOperator();
                    if (operator == 9 || operator == 10 || AnyConverter.isVoid((Object)value)) {
                        column.addProperty("Value", (short)129, (Object)"");
                        value = new Any(new Type(TypeClass.VOID), null);
                    } else {
                        column.addProperty("Value", (short)129, value);
                    }
                    columnSet.setPropertyValue("Value", value);
                    composer.getQueryComposer().appendFilterByColumn(columnSet, this.getfilterstate() == this.SOI_MATCHALL, (int)nOperator);
                }
                this.filterconditions = composer.getNormalizedStructuredFilter();
                int[] iduplicate = JavaTools.getDuplicateFieldIndex(this.filterconditions);
                if (iduplicate[0] != -1) {
                    PropertyValue aduplicatecondition = this.filterconditions[iduplicate[0]][iduplicate[1]];
                    String smsgDuplicateCondition = FilterComponent.getDisplayCondition(this.sDuplicateCondition, aduplicatecondition, null);
                    this.CurUnoDialog.showMessageBox("WarningBox", 0x400000, smsgDuplicateCondition);
                    this.CurUnoDialog.vetoableChange(new PropertyChangeEvent(this.CurUnoDialog, "Steps", 1, 2));
                    return new PropertyValue[0][];
                }
            }
            catch (com.sun.star.uno.Exception ex) {
                Logger.getLogger(FilterComponent.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.filterconditions = new PropertyValue[0][0];
        }
        return this.filterconditions;
    }

    public static String getDisplayCondition(String _BaseString, PropertyValue _filtercondition, QueryMetaData _CurDBMetaData) {
        try {
            String FieldName;
            if (_CurDBMetaData != null) {
                FieldColumn CurDBFieldColumn = _CurDBMetaData.getFieldColumnByFieldName(_filtercondition.Name);
                FieldName = CurDBFieldColumn.getFieldTitle();
            } else {
                FieldName = _filtercondition.Name;
            }
            String sreturn = JavaTools.replaceSubString(_BaseString, FieldName, "<FIELDNAME>");
            String soperator = sLogicOperators[_filtercondition.Handle - 1];
            sreturn = JavaTools.replaceSubString(sreturn, soperator, "<LOGICOPERATOR>");
            String sDisplayValue = PropertyNames.EMPTY_STRING;
            if (_filtercondition.Handle != 9 && _filtercondition.Handle != 10 && !AnyConverter.isVoid((Object)_filtercondition.Value)) {
                sDisplayValue = AnyConverter.toString((Object)_filtercondition.Value);
            }
            sreturn = JavaTools.replaceSubString(sreturn, sDisplayValue, "<VALUE>");
            return sreturn;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(System.err);
            return PropertyNames.EMPTY_STRING;
        }
    }

    private int getfilterstate() {
        boolean bisany = true;
        int ifilterstate = this.SOI_MATCHALL;
        bisany = this.optMatchAny.getState();
        ifilterstate = bisany ? this.SOI_MATCHANY : this.SOI_MATCHALL;
        return ifilterstate;
    }

    private int getFilterCount() {
        int a = 0;
        for (int i = 0; i < this.RowCount; ++i) {
            if (!this.oControlRows[i].isEnabled() || !this.oControlRows[i].isConditionComplete()) continue;
            ++a;
        }
        return a;
    }

    public FilterComponent(WizardDialog CurUnoDialog, int iStep, int iPosX, int iPosY, int FilterCount, QueryMetaData _oQueryMetaData, int _firstHelpID) {
        int curHelpID = _firstHelpID;
        this.IStep = iStep;
        this.curtabindex = UnoDialog.setInitialTabindex(iStep);
        this.CurUnoDialog = CurUnoDialog;
        this.RowCount = FilterCount;
        this.oQueryMetaData = _oQueryMetaData;
        this.sIncSuffix = Desktop.getIncrementSuffix(CurUnoDialog.getDlgNameAccess(), "optMatchAll");
        String soptMatchAll = CurUnoDialog.m_oResource.getResText(2309);
        String soptMatchAny = CurUnoDialog.m_oResource.getResText(2310);
        this.slblFieldNames = CurUnoDialog.m_oResource.getResText(2317);
        this.slblOperators = CurUnoDialog.m_oResource.getResText(2324);
        this.slblValue = CurUnoDialog.m_oResource.getResText(2325);
        sLogicOperators = CurUnoDialog.m_oResource.getResArray(2326, 10);
        this.sDuplicateCondition = CurUnoDialog.m_oResource.getResText(2389);
        Object[] objectArray = new Object[9];
        objectArray[0] = 9;
        objectArray[1] = HelpIds.getHelpIdString(curHelpID++);
        objectArray[2] = soptMatchAll;
        objectArray[3] = iPosX;
        objectArray[4] = iPosY;
        objectArray[5] = (short)1;
        objectArray[6] = this.IStep;
        short s = this.curtabindex;
        this.curtabindex = (short)(s + 1);
        objectArray[7] = s;
        objectArray[8] = 203;
        CurUnoDialog.insertRadioButton("optMatchAll" + this.sIncSuffix, 101, new ItemListenerImpl(), new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STATE, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray);
        Object[] objectArray2 = new Object[8];
        objectArray2[0] = 9;
        objectArray2[1] = HelpIds.getHelpIdString(curHelpID++);
        objectArray2[2] = soptMatchAny;
        objectArray2[3] = iPosX;
        objectArray2[4] = iPosY + 12;
        objectArray2[5] = this.IStep;
        short s2 = this.curtabindex;
        this.curtabindex = (short)(s2 + 1);
        objectArray2[6] = s2;
        objectArray2[7] = 203;
        this.optMatchAny = CurUnoDialog.insertRadioButton("optMatchAny" + this.sIncSuffix, 100, new ItemListenerImpl(), new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray2);
        this.getfilterstate();
        this.oControlRows = new ControlRow[FilterCount];
        for (int i = 0; i < FilterCount; ++i) {
            boolean bEnabled = i == 0;
            this.oControlRows[i] = new ControlRow(iPosX, iPosY + 20, i, bEnabled, curHelpID + i * 3);
            iPosY += 43;
        }
    }

    public void initialize(PropertyValue[][] _filterconditions, String[] _fieldnames) {
        int i;
        for (i = 0; i < this.RowCount; ++i) {
            this.oControlRows[i].setFieldNames(_fieldnames);
        }
        this.filterconditions = _filterconditions;
        if (_filterconditions.length == 1) {
            PropertyValue[] curfilterconditions = this.filterconditions[0];
            for (i = 0; i < curfilterconditions.length; ++i) {
                this.oControlRows[i].setCondition(this.filterconditions[0][i]);
            }
        } else {
            for (i = 0; i < this.filterconditions.length; ++i) {
                this.oControlRows[i].setCondition(this.filterconditions[i][0]);
            }
        }
        while (i < this.oControlRows.length) {
            this.oControlRows[i].settovoid();
            boolean bdoenable = i > 0 ? this.oControlRows[i - 1].isConditionComplete() : true;
            this.oControlRows[i].setEnabled(bdoenable);
            ++i;
        }
    }

    public void addNumberFormats() {
        this.iDateFormat = this.oQueryMetaData.getNumberFormatter().defineNumberFormat("YYYY-MM-DD");
        this.iTimeFormat = this.oQueryMetaData.getNumberFormatter().defineNumberFormat("HH:MM:SS");
        this.oQueryMetaData.getNumberFormatter().defineNumberFormat("YYYY-MM-DD HH:MM:SS");
    }

    static /* synthetic */ short access$1808(FilterComponent x0) {
        short s = x0.curtabindex;
        x0.curtabindex = (short)(s + 1);
        return s;
    }

    private final class ControlRow {
        private static final int SOLSTFIELDNAME = 3;
        private static final int SOLSTOPERATOR = 4;
        private static final int SOTXTVALUE = 5;
        private XInterface[] ControlElements = new XInterface[6];
        private boolean m_bEnabled;
        private String[] FieldNames;

        private ControlRow(int iCompPosX, int iCompPosY, int Index, boolean _bEnabled, int _firstRowHelpID) {
            int nFieldWidth = 71;
            int nOperatorWidth = 70;
            int nValueWidth = 44;
            int nPosX1 = iCompPosX + 10;
            int nPosX2 = iCompPosX + 10 + nFieldWidth + 6;
            int nPosX3 = iCompPosX + 10 + nFieldWidth + 6 + nOperatorWidth + 6;
            try {
                String sCompSuffix = FilterComponent.this.sIncSuffix + "_" + (Index + 1);
                this.m_bEnabled = _bEnabled;
                this.ControlElements[0] = FilterComponent.this.CurUnoDialog.insertLabel("lblFieldNames" + sCompSuffix, new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{this.isEnabled(), 9, FilterComponent.this.slblFieldNames, nPosX1, iCompPosY + 13, FilterComponent.this.IStep, FilterComponent.access$1808(FilterComponent.this), nFieldWidth});
                this.ControlElements[1] = FilterComponent.this.CurUnoDialog.insertLabel("lblOperators" + sCompSuffix, new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{this.isEnabled(), 9, FilterComponent.this.slblOperators, nPosX2, iCompPosY + 13, FilterComponent.this.IStep, FilterComponent.access$1808(FilterComponent.this), nOperatorWidth});
                this.ControlElements[2] = FilterComponent.this.CurUnoDialog.insertLabel("lblValue" + sCompSuffix, new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{this.isEnabled(), 9, FilterComponent.this.slblValue, nPosX3, iCompPosY + 13, FilterComponent.this.IStep, FilterComponent.access$1808(FilterComponent.this), nValueWidth});
                this.ControlElements[3] = FilterComponent.this.CurUnoDialog.insertListBox("lstFieldName" + sCompSuffix, FilterComponent.this.SO_FIELDNAMELIST[Index], null, new ItemListenerImpl(), new String[]{PropertyNames.PROPERTY_ENABLED, "Dropdown", PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, "LineCount", PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{this.isEnabled(), Boolean.TRUE, 13, HelpIds.getHelpIdString(_firstRowHelpID++), UnoDialog.getListBoxLineCount(), nPosX1, iCompPosY + 23, FilterComponent.this.IStep, FilterComponent.access$1808(FilterComponent.this), nFieldWidth});
                this.ControlElements[4] = FilterComponent.this.CurUnoDialog.insertListBox("lstOperator" + sCompSuffix, FilterComponent.this.SO_CONDITIONLIST[Index], null, new ItemListenerImpl(), new String[]{PropertyNames.PROPERTY_ENABLED, "Dropdown", PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, "LineCount", PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.STRING_ITEM_LIST, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{this.isEnabled(), Boolean.TRUE, 13, HelpIds.getHelpIdString(_firstRowHelpID++), (short)sLogicOperators.length, nPosX2, iCompPosY + 23, FilterComponent.this.IStep, sLogicOperators, FilterComponent.access$1808(FilterComponent.this), nOperatorWidth});
                this.ControlElements[5] = FilterComponent.this.CurUnoDialog.insertFormattedField("txtValue" + sCompSuffix, FilterComponent.this.SO_TEXTFIELDLIST[Index], new TextListenerImpl(), new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{this.isEnabled(), 13, HelpIds.getHelpIdString(_firstRowHelpID++), nPosX3, iCompPosY + 23, FilterComponent.this.IStep, FilterComponent.access$1808(FilterComponent.this), nValueWidth});
            }
            catch (com.sun.star.uno.Exception exception) {
                exception.printStackTrace(System.err);
            }
        }

        private boolean isConditionComplete() {
            try {
                short[] SelFields = (short[])AnyConverter.toArray((Object)Helper.getUnoPropertyValue(UnoDialog.getModel(this.ControlElements[3]), PropertyNames.SELECTED_ITEMS));
                if (SelFields.length > 0) {
                    Object oValue;
                    short nSelOperator = this.getSelectedOperator();
                    if (nSelOperator == 9 || nSelOperator == 10) {
                        Helper.setUnoPropertyValue(UnoDialog.getModel(this.ControlElements[2]), PropertyNames.PROPERTY_ENABLED, Boolean.FALSE);
                        Helper.setUnoPropertyValue(UnoDialog.getModel(this.ControlElements[5]), PropertyNames.PROPERTY_ENABLED, Boolean.FALSE);
                        return true;
                    }
                    Helper.setUnoPropertyValue(UnoDialog.getModel(this.ControlElements[2]), PropertyNames.PROPERTY_ENABLED, Boolean.TRUE);
                    Helper.setUnoPropertyValue(UnoDialog.getModel(this.ControlElements[5]), PropertyNames.PROPERTY_ENABLED, Boolean.TRUE);
                    if (nSelOperator != -1 && !AnyConverter.isVoid((Object)(oValue = Helper.getUnoPropertyValue(UnoDialog.getModel(this.ControlElements[5]), "EffectiveValue")))) {
                        String sValue = String.valueOf(oValue);
                        return !sValue.equals(PropertyNames.EMPTY_STRING);
                    }
                }
                return false;
            }
            catch (IllegalArgumentException exception) {
                exception.printStackTrace(System.err);
                return false;
            }
        }

        private void setCondition(PropertyValue _filtercondition) {
            try {
                XListBox xFieldsListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)this.ControlElements[3]);
                xFieldsListBox.selectItem(_filtercondition.Name, true);
                XListBox xOperatorListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)this.ControlElements[4]);
                xOperatorListBox.selectItemPos((short)(_filtercondition.Handle - 1), true);
                if (AnyConverter.isString((Object)_filtercondition.Value)) {
                    String sValue = AnyConverter.toString((Object)_filtercondition.Value);
                    if (sValue.indexOf("{D '") > -1) {
                        sValue = JavaTools.replaceSubString(sValue, PropertyNames.EMPTY_STRING, "{D '");
                        sValue = JavaTools.replaceSubString(sValue, PropertyNames.EMPTY_STRING, "' }");
                        try {
                            FilterComponent.this.oQueryMetaData.getNumberFormatter().convertStringToNumber(FilterComponent.this.iDateFormat, sValue);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(FilterComponent.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else if (sValue.indexOf("{T '") > -1) {
                        sValue = JavaTools.replaceSubString(sValue, PropertyNames.EMPTY_STRING, "{T '");
                        sValue = JavaTools.replaceSubString(sValue, PropertyNames.EMPTY_STRING, "' }");
                        try {
                            FilterComponent.this.oQueryMetaData.getNumberFormatter().convertStringToNumber(FilterComponent.this.iTimeFormat, sValue);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(FilterComponent.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                } else if (AnyConverter.isBoolean((Object)_filtercondition.Value)) {
                    boolean b = AnyConverter.toBoolean((Object)_filtercondition.Value);
                    double nValue = 0.0;
                    if (b) {
                        nValue = 1.0;
                    }
                    Helper.setUnoPropertyValue(UnoDialog.getModel(this.ControlElements[5]), "EffectiveValue", nValue);
                } else {
                    Helper.setUnoPropertyValue(UnoDialog.getModel(this.ControlElements[5]), "EffectiveValue", _filtercondition.Value);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace(System.err);
            }
        }

        private void setFieldNames(String[] _FieldNames) {
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.ControlElements[3]), PropertyNames.STRING_ITEM_LIST, _FieldNames);
            this.FieldNames = _FieldNames;
        }

        private boolean isEnabled() {
            return this.m_bEnabled;
        }

        private void settovoid() {
            WizardDialog.deselectListBox(this.ControlElements[3]);
            WizardDialog.deselectListBox(this.ControlElements[4]);
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.ControlElements[5]), "EffectiveValue", Any.VOID);
        }

        private void setEnabled(boolean _bEnabled) {
            for (int i = 0; i < this.ControlElements.length; ++i) {
                Helper.setUnoPropertyValue(UnoDialog.getModel(this.ControlElements[i]), PropertyNames.PROPERTY_ENABLED, _bEnabled);
            }
            this.m_bEnabled = _bEnabled;
            if (this.isEnabled()) {
                short[] iselected = new short[]{};
                try {
                    iselected = (short[])AnyConverter.toArray((Object)Helper.getUnoPropertyValue(UnoDialog.getModel(this.ControlElements[4]), PropertyNames.SELECTED_ITEMS));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.err);
                }
                if (iselected.length == 0) {
                    Helper.setUnoPropertyValue(UnoDialog.getModel(this.ControlElements[4]), PropertyNames.SELECTED_ITEMS, new short[]{0});
                }
            } else if (!this.isConditionComplete()) {
                WizardDialog.deselectListBox(this.ControlElements[4]);
            }
        }

        private String getSelectedFieldName() {
            try {
                short[] SelFields = (short[])AnyConverter.toArray((Object)Helper.getUnoPropertyValue(UnoDialog.getModel(this.ControlElements[3]), PropertyNames.SELECTED_ITEMS));
                return this.FieldNames[SelFields[0]];
            }
            catch (IllegalArgumentException exception) {
                exception.printStackTrace(System.err);
                return null;
            }
        }

        private short getSelectedOperator() {
            try {
                short[] SelFields = (short[])AnyConverter.toArray((Object)Helper.getUnoPropertyValue(UnoDialog.getModel(this.ControlElements[4]), PropertyNames.SELECTED_ITEMS));
                switch (SelFields[0]) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 6;
                    }
                    case 6: {
                        return 7;
                    }
                    case 7: {
                        return 8;
                    }
                    case 8: {
                        return 9;
                    }
                    case 9: {
                        return 10;
                    }
                }
                return -1;
            }
            catch (IllegalArgumentException exception) {
                exception.printStackTrace(System.err);
                return -1;
            }
        }

        private Object getValue() {
            return Helper.getUnoPropertyValue(UnoDialog.getModel(this.ControlElements[5]), "EffectiveValue");
        }
    }

    class TextListenerImpl
    implements XTextListener {
        TextListenerImpl() {
        }

        public void textChanged(TextEvent EventObject2) {
            String sName = FilterComponent.this.getControlName(EventObject2.Source);
            FilterComponent.this.togglefollowingControlRow(sName);
        }

        public void disposing(EventObject eventObject) {
        }
    }

    class ItemListenerImpl
    implements XItemListener {
        ItemListenerImpl() {
        }

        public void itemStateChanged(ItemEvent EventObject2) {
            int iKey = FilterComponent.this.CurUnoDialog.getControlKey(EventObject2.Source, ((FilterComponent)FilterComponent.this).CurUnoDialog.ControlList);
            String sControlName = PropertyNames.EMPTY_STRING;
            switch (iKey) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    sControlName = FilterComponent.this.getControlName(EventObject2.Source);
                    String sControlNameSuffix = FilterComponent.this.sIncSuffix + "_" + FilterComponent.getIndexNumber(sControlName);
                    XListBox xCurFieldListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)((FilterComponent)FilterComponent.this).CurUnoDialog.xDlgContainer.getControl(sControlName));
                    String CurDisplayFieldName = xCurFieldListBox.getSelectedItem();
                    FieldColumn CurFieldColumn = FilterComponent.this.oQueryMetaData.getFieldColumnByDisplayName(CurDisplayFieldName);
                    String sControlNameTextValue = "txtValue" + sControlNameSuffix;
                    XControl xValueControl = ((FilterComponent)FilterComponent.this).CurUnoDialog.xDlgContainer.getControl(sControlNameTextValue);
                    XInterface xValueModel = (XInterface)UnoDialog.getModel(xValueControl);
                    Helper.setUnoPropertyValue(xValueModel, "TreatAsNumber", CurFieldColumn.isNumberFormat());
                    NumberFormatter aNumberFormatter = FilterComponent.this.oQueryMetaData.getNumberFormatter();
                    aNumberFormatter.setNumberFormat(xValueModel, CurFieldColumn.getDBFormatKey(), aNumberFormatter);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 257: 
                case 258: 
                case 259: 
                case 260: {
                    sControlName = FilterComponent.this.getControlName(EventObject2.Source);
                    break;
                }
                case 100: 
                case 101: {
                    return;
                }
            }
            FilterComponent.this.togglefollowingControlRow(sControlName);
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

