/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import org.openoffice.xmerge.merger.Iterator;

public final class ObjectArrayIterator
implements Iterator {
    private Object[] objArray;
    private int currentPosition;

    public ObjectArrayIterator(Object[] objArray) {
        if (objArray != null) {
            this.objArray = new Object[objArray.length];
            System.arraycopy(objArray, 0, this.objArray, 0, objArray.length);
            this.currentPosition = 0;
        } else {
            this.objArray = new Object[0];
        }
    }

    public Object next() {
        if (this.currentPosition < this.objArray.length - 1) {
            ++this.currentPosition;
            return this.currentElement();
        }
        return null;
    }

    public Object previous() {
        if (this.currentPosition > 0) {
            --this.currentPosition;
            return this.currentElement();
        }
        return null;
    }

    public Object start() {
        this.currentPosition = 0;
        return this.currentElement();
    }

    public Object end() {
        if (this.objArray.length > 0) {
            this.currentPosition = this.objArray.length - 1;
        }
        return this.currentElement();
    }

    public Object currentElement() {
        if (this.objArray.length > 0) {
            return this.objArray[this.currentPosition];
        }
        return null;
    }

    public void replace(Object object) {
        this.objArray[this.currentPosition] = object;
    }

    public void insert(Object object) {
        Object[] objArray2 = new Object[this.objArray.length + 1];
        if (this.currentPosition > 0) {
            System.arraycopy(this.objArray, 0, objArray2, 0, this.currentPosition);
        }
        objArray2[this.currentPosition] = object;
        System.arraycopy(this.objArray, this.currentPosition, objArray2, this.currentPosition + 1, this.objArray.length - this.currentPosition);
        this.objArray = objArray2;
        ++this.currentPosition;
    }

    public void append(Object object) {
        Object[] objArray2 = new Object[this.objArray.length + 1];
        int newPosition = this.currentPosition + 1;
        System.arraycopy(this.objArray, 0, objArray2, 0, newPosition);
        objArray2[newPosition] = object;
        if (this.currentPosition < this.objArray.length - 1) {
            System.arraycopy(this.objArray, newPosition, objArray2, newPosition + 1, this.objArray.length - newPosition);
        }
        this.objArray = objArray2;
    }

    public void remove() {
        Object[] objArray2 = new Object[this.objArray.length - 1];
        if (this.currentPosition > 0) {
            System.arraycopy(this.objArray, 0, objArray2, 0, this.currentPosition);
        }
        if (this.currentPosition < this.objArray.length - 1) {
            System.arraycopy(this.objArray, this.currentPosition + 1, objArray2, this.currentPosition, this.objArray.length - this.currentPosition - 1);
        }
        this.objArray = objArray2;
        if (this.currentPosition == this.objArray.length) {
            --this.currentPosition;
        }
    }

    public int elementCount() {
        return this.objArray.length;
    }

    public boolean equivalent(Object obj1, Object obj2) {
        return obj1.equals(obj2);
    }

    public void refresh() {
    }
}

