/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.util.IntegerCache;

public class StaticDataRow
implements DataRow {
    private String[] names;
    private Object[] values;
    private Map nameCache;

    protected StaticDataRow() {
    }

    protected StaticDataRow(StaticDataRow staticDataRow) {
        if (staticDataRow == null) {
            throw new NullPointerException();
        }
        this.nameCache = staticDataRow.nameCache;
        this.names = staticDataRow.names;
        this.values = staticDataRow.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticDataRow(DataRow dataRow) throws DataSourceException {
        if (dataRow == null) {
            throw new NullPointerException();
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        DataRow dataRow2 = dataRow;
        synchronized (dataRow2) {
            int n = dataRow.getColumnCount();
            this.names = new String[n];
            this.values = new Object[dataRow.getColumnCount()];
            for (int i = 0; i < n; ++i) {
                this.names[i] = dataRow.getColumnName(i);
                this.values[i] = dataRow.get(i);
                if (this.names[i] == null) continue;
                hashMap.put(this.names[i], IntegerCache.getInteger(i));
            }
        }
        this.nameCache = Collections.unmodifiableMap(hashMap);
    }

    public StaticDataRow(String[] stringArray, Object[] objectArray) {
        this.setData(stringArray, objectArray);
    }

    protected void setData(String[] stringArray, Object[] objectArray) {
        int n;
        if (stringArray == null) {
            throw new NullPointerException();
        }
        if (objectArray == null) {
            throw new NullPointerException();
        }
        if (stringArray.length == objectArray.length) {
            n = stringArray.length;
            this.names = (String[])stringArray.clone();
            this.values = (Object[])objectArray.clone();
        } else {
            n = Math.min(stringArray.length, objectArray.length);
            this.names = new String[n];
            this.values = new Object[n];
            System.arraycopy(stringArray, 0, this.names, 0, n);
            System.arraycopy(objectArray, 0, this.values, 0, n);
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            hashMap.put(string, IntegerCache.getInteger(i));
        }
        this.nameCache = Collections.unmodifiableMap(hashMap);
    }

    protected void updateData(Object[] objectArray) {
        if (objectArray.length != this.values.length) {
            throw new IllegalArgumentException("You should preserve the number of columns.");
        }
        this.values = (Object[])objectArray.clone();
    }

    public Object get(int n) throws DataSourceException {
        return this.values[n];
    }

    public Object get(String string) throws DataSourceException {
        Integer n = (Integer)this.nameCache.get(string);
        if (n == null) {
            return null;
        }
        return this.values[n];
    }

    public String getColumnName(int n) throws DataSourceException {
        return this.names[n];
    }

    public int getColumnCount() throws DataSourceException {
        return this.values.length;
    }

    public DataFlags getFlags(String string) throws DataSourceException {
        return new DefaultDataFlags(string, this.get(string), false);
    }

    public DataFlags getFlags(int n) throws DataSourceException {
        return new DefaultDataFlags(this.names[n], this.values[n], false);
    }
}

