/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.tools.jmx;

import com.sun.tools.visualvm.tools.jmx.CachedMBeanServerConnection;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.MBeanCacheListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.Timer;
import org.openide.util.RequestProcessor;

public final class CachedMBeanServerConnectionFactory {
    private static final Map<Integer, Map<MBeanServerConnection, WeakReference<CachedMBeanServerConnection>>> snapshots = new HashMap<Integer, Map<MBeanServerConnection, WeakReference<CachedMBeanServerConnection>>>();

    private CachedMBeanServerConnectionFactory() {
    }

    public static CachedMBeanServerConnection getCachedMBeanServerConnection(MBeanServerConnection mbsc) {
        return CachedMBeanServerConnectionFactory.getCachedMBeanServerConnection(mbsc, 0);
    }

    public static CachedMBeanServerConnection getCachedMBeanServerConnection(MBeanServerConnection mbsc, int interval) throws IllegalArgumentException {
        if (interval < 0) {
            throw new IllegalArgumentException("interval cannot be negative");
        }
        return CachedMBeanServerConnectionFactory.retrieveCachedMBeanServerConnection(mbsc, interval);
    }

    public static CachedMBeanServerConnection getCachedMBeanServerConnection(JmxModel jmx) {
        return CachedMBeanServerConnectionFactory.getCachedMBeanServerConnection(jmx.getMBeanServerConnection(), 0);
    }

    public static CachedMBeanServerConnection getCachedMBeanServerConnection(JmxModel jmx, int interval) throws IllegalArgumentException {
        return CachedMBeanServerConnectionFactory.getCachedMBeanServerConnection(jmx.getMBeanServerConnection(), interval);
    }

    private static synchronized CachedMBeanServerConnection retrieveCachedMBeanServerConnection(MBeanServerConnection mbsc, int interval) {
        CachedMBeanServerConnection cmbsc;
        Map<MBeanServerConnection, WeakReference<CachedMBeanServerConnection>> mbscMap = snapshots.get(interval);
        if (mbscMap == null) {
            CachedMBeanServerConnection cmbsc2 = Snapshot.newSnapshot(mbsc, interval);
            WeakHashMap<MBeanServerConnection, WeakReference<CachedMBeanServerConnection>> mbscMapNew = new WeakHashMap<MBeanServerConnection, WeakReference<CachedMBeanServerConnection>>();
            mbscMapNew.put(mbsc, new WeakReference<CachedMBeanServerConnection>(cmbsc2));
            snapshots.put(interval, mbscMapNew);
            return cmbsc2;
        }
        WeakReference<CachedMBeanServerConnection> cmbscRef = mbscMap.get(mbsc);
        CachedMBeanServerConnection cachedMBeanServerConnection = cmbsc = cmbscRef == null ? null : (CachedMBeanServerConnection)cmbscRef.get();
        if (cmbsc == null) {
            cmbsc = Snapshot.newSnapshot(mbsc, interval);
            mbscMap.put(mbsc, new WeakReference<CachedMBeanServerConnection>(cmbsc));
        }
        return cmbsc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SnapshotInvocationHandler
    implements InvocationHandler {
        private final MBeanServerConnection conn;
        private final int interval;
        private Timer timer = null;
        private Map<ObjectName, NameValueMap> cachedValues = SnapshotInvocationHandler.newMap();
        private Map<ObjectName, Set<String>> cachedNames = SnapshotInvocationHandler.newMap();
        private List<MBeanCacheListener> listenerList = new CopyOnWriteArrayList<MBeanCacheListener>();
        private volatile boolean flushRunning;

        SnapshotInvocationHandler(MBeanServerConnection conn, int interval) {
            this.conn = conn;
            this.interval = interval;
            if (interval > 0) {
                this.timer = new Timer(interval, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SnapshotInvocationHandler.this.intervalElapsed();
                    }
                });
                this.timer.setCoalesce(true);
                this.timer.start();
            }
        }

        void intervalElapsed() {
            if (this.flushRunning) {
                return;
            }
            this.flushRunning = true;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SnapshotInvocationHandler.this.flush();
                    SnapshotInvocationHandler.this.connectionPinger();
                    SnapshotInvocationHandler.this.notifyListeners();
                    SnapshotInvocationHandler.this.flushRunning = false;
                }
            });
        }

        void notifyListeners() {
            for (MBeanCacheListener listener : this.listenerList) {
                listener.flushed();
            }
        }

        private void connectionPinger() {
            try {
                this.conn.getDefaultDomain();
            }
            catch (Exception e) {
                this.timer.stop();
                this.listenerList.clear();
                this.cachedValues.clear();
                this.cachedNames.clear();
                Collection values = snapshots.values();
                for (Map value : values) {
                    value.remove(this.conn);
                }
            }
        }

        synchronized void flush() {
            this.cachedValues = SnapshotInvocationHandler.newMap();
        }

        int getInterval() {
            return this.interval;
        }

        void addMBeanCacheListener(MBeanCacheListener listener) {
            this.listenerList.add(listener);
        }

        void removeMBeanCacheListener(MBeanCacheListener listener) {
            this.listenerList.remove(listener);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getAttribute")) {
                return this.getAttribute((ObjectName)args[0], (String)args[1]);
            }
            if (methodName.equals("getAttributes")) {
                return this.getAttributes((ObjectName)args[0], (String[])args[1]);
            }
            if (methodName.equals("flush")) {
                this.flush();
                return null;
            }
            if (methodName.equals("getInterval")) {
                return this.getInterval();
            }
            if (methodName.equals("addMBeanCacheListener")) {
                this.addMBeanCacheListener((MBeanCacheListener)args[0]);
                return null;
            }
            if (methodName.equals("removeMBeanCacheListener")) {
                this.removeMBeanCacheListener((MBeanCacheListener)args[0]);
                return null;
            }
            try {
                return method.invoke((Object)this.conn, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private Object getAttribute(ObjectName objName, String attrName) throws MBeanException, InstanceNotFoundException, AttributeNotFoundException, ReflectionException, IOException {
            NameValueMap values = this.getCachedAttributes(objName, Collections.singleton(attrName));
            Object value = values.get(attrName);
            if (value != null || values.containsKey(attrName)) {
                return value;
            }
            return this.conn.getAttribute(objName, attrName);
        }

        private AttributeList getAttributes(ObjectName objName, String[] attrNames) throws InstanceNotFoundException, ReflectionException, IOException {
            NameValueMap values = this.getCachedAttributes(objName, new TreeSet<String>(Arrays.asList(attrNames)));
            AttributeList list = new AttributeList();
            for (String attrName : attrNames) {
                Object value = values.get(attrName);
                if (value == null && !values.containsKey(attrName)) continue;
                list.add(new Attribute(attrName, value));
            }
            return list;
        }

        private synchronized NameValueMap getCachedAttributes(ObjectName objName, Set<String> attrNames) throws InstanceNotFoundException, ReflectionException, IOException {
            NameValueMap values = this.cachedValues.get(objName);
            if (values != null && values.keySet().containsAll(attrNames)) {
                return values;
            }
            attrNames = new TreeSet<String>(attrNames);
            Set<String> oldNames = this.cachedNames.get(objName);
            if (oldNames != null) {
                attrNames.addAll(oldNames);
            }
            values = new NameValueMap();
            AttributeList attrs = this.conn.getAttributes(objName, attrNames.toArray(new String[attrNames.size()]));
            for (Attribute attr : attrs.asList()) {
                values.put(attr.getName(), attr.getValue());
            }
            this.cachedValues.put(objName, values);
            this.cachedNames.put(objName, attrNames);
            return values;
        }

        private static <K, V> Map<K, V> newMap() {
            return new HashMap();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class NameValueMap
        extends HashMap<String, Object> {
            private NameValueMap() {
            }
        }
    }

    static class Snapshot {
        private Snapshot() {
        }

        public static CachedMBeanServerConnection newSnapshot(MBeanServerConnection mbsc, int interval) {
            SnapshotInvocationHandler ih = new SnapshotInvocationHandler(mbsc, interval);
            return (CachedMBeanServerConnection)Proxy.newProxyInstance(Snapshot.class.getClassLoader(), new Class[]{CachedMBeanServerConnection.class}, (InvocationHandler)ih);
        }
    }
}

