/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.basic;

import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.basic.ArrayValueView;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class StringDetailsProvider
extends DetailsProvider.Basic {
    static final String STRING_MASK = "java.lang.String";
    static final String BUILDERS_MASK = "java.lang.AbstractStringBuilder+";

    public StringDetailsProvider() {
        super(STRING_MASK, BUILDERS_MASK);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        if (STRING_MASK.equals(string)) {
            int n = DetailsUtils.getIntFieldValue(instance, "offset", 0);
            int n2 = DetailsUtils.getIntFieldValue(instance, "count", -1);
            return DetailsUtils.getPrimitiveArrayFieldString(instance, "value", n, n2, null, "...");
        }
        if (BUILDERS_MASK.equals(string)) {
            int n = DetailsUtils.getIntFieldValue(instance, "count", -1);
            return DetailsUtils.getPrimitiveArrayFieldString(instance, "value", 0, n, null, "...");
        }
        return null;
    }

    @Override
    public DetailsProvider.View getDetailsView(String string, Instance instance, Heap heap) {
        return new ArrayValueView(string, instance, heap);
    }
}

