/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class RootClassLoadedCommand
extends Command {
    private int[] allLoadedClassLoaderIds;
    private String[] allLoadedClassNames;
    private byte[][] cachedClassFileBytes;
    private int[] parentLoaderIds;
    private int classCount;

    public RootClassLoadedCommand(String[] stringArray, int[] nArray, byte[][] byArray, int n, int[] nArray2) {
        super(17);
        this.allLoadedClassNames = stringArray;
        this.allLoadedClassLoaderIds = nArray;
        this.cachedClassFileBytes = byArray;
        this.classCount = n;
        this.parentLoaderIds = nArray2;
    }

    RootClassLoadedCommand() {
        super(17);
    }

    public int[] getAllLoadedClassLoaderIds() {
        return this.allLoadedClassLoaderIds;
    }

    public String[] getAllLoadedClassNames() {
        return this.allLoadedClassNames;
    }

    public byte[][] getCachedClassFileBytes() {
        byte[][] byArray = this.cachedClassFileBytes;
        this.cachedClassFileBytes = null;
        return byArray;
    }

    public int[] getParentLoaderIds() {
        int[] nArray = new int[this.parentLoaderIds.length];
        System.arraycopy(this.parentLoaderIds, 0, nArray, 0, this.parentLoaderIds.length);
        return nArray;
    }

    public String toString() {
        return super.toString();
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n;
        int n2 = objectInputStream.readInt();
        this.allLoadedClassNames = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.allLoadedClassNames[n] = objectInputStream.readUTF();
        }
        this.allLoadedClassLoaderIds = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.allLoadedClassLoaderIds[n] = objectInputStream.readInt();
        }
        n2 = objectInputStream.readInt();
        if (n2 == 0) {
            this.cachedClassFileBytes = null;
        } else {
            this.cachedClassFileBytes = new byte[n2][];
            for (n = 0; n < n2; ++n) {
                int n3 = objectInputStream.readInt();
                if (n3 == 0) continue;
                this.cachedClassFileBytes[n] = new byte[n3];
                objectInputStream.readFully(this.cachedClassFileBytes[n]);
            }
        }
        n2 = objectInputStream.readInt();
        this.parentLoaderIds = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.parentLoaderIds[n] = objectInputStream.readInt();
        }
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.writeInt(this.classCount);
        for (n = 0; n < this.classCount; ++n) {
            objectOutputStream.writeUTF(this.allLoadedClassNames[n]);
        }
        for (n = 0; n < this.classCount; ++n) {
            int n2 = this.allLoadedClassLoaderIds[n];
            if (n2 == -1) {
                n2 = 0;
            }
            objectOutputStream.writeInt(n2);
        }
        if (this.cachedClassFileBytes == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.classCount);
            for (n = 0; n < this.classCount; ++n) {
                if (this.cachedClassFileBytes[n] == null) {
                    objectOutputStream.writeInt(0);
                    continue;
                }
                objectOutputStream.writeInt(this.cachedClassFileBytes[n].length);
                objectOutputStream.write(this.cachedClassFileBytes[n]);
            }
        }
        objectOutputStream.writeInt(this.parentLoaderIds.length);
        for (n = 0; n < this.parentLoaderIds.length; ++n) {
            objectOutputStream.writeInt(this.parentLoaderIds[n]);
        }
        this.allLoadedClassNames = null;
        this.allLoadedClassLoaderIds = null;
        this.cachedClassFileBytes = null;
        this.parentLoaderIds = null;
    }
}

