/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.gnome;

import com.sun.jna.Pointer;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.keyring.gnome.GnomeKeyringLibrary;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.util.NbBundle;

public class GnomeProvider
implements KeyringProvider {
    private static final Logger LOG = Logger.getLogger(GnomeProvider.class.getName());
    private static final String KEY = "key";
    private static String[] ERRORS = new String[]{"OK", "DENIED", "NO_KEYRING_DAEMON", "ALREADY_UNLOCKED", "NO_SUCH_KEYRING", "BAD_ARGUMENTS", "IO_ERROR", "CANCELLED", "KEYRING_ALREADY_EXISTS", "NO_MATCH"};

    public boolean enabled() {
        Object object;
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            LOG.fine("native keyring integration disabled");
            return false;
        }
        boolean bl = false;
        for (String string : System.getenv().keySet()) {
            if (!string.startsWith("GNOME_KEYRING_")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            LOG.fine("no GNOME_KEYRING_* environment variable set");
            return false;
        }
        try {
            object = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.windows.view.ui.Bundle").getString("CTL_MainWindow_Title_No_Project"), "\u2026");
        }
        catch (MissingResourceException missingResourceException) {
            object = "NetBeans";
        }
        try {
            GnomeKeyringLibrary.LIBRARY.g_set_application_name((String)object);
            if (!GnomeKeyringLibrary.LIBRARY.gnome_keyring_is_available()) {
                return false;
            }
            this.read("NoNeXiStEnT");
            return true;
        }
        catch (Throwable throwable) {
            LOG.log(Level.FINE, null, throwable);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public char[] read(String string) {
        Pointer[] pointerArray = new Pointer[1];
        Pointer pointer = GnomeKeyringLibrary.LIBRARY.g_array_new(0, 0, GnomeKeyringLibrary.GnomeKeyringAttribute_SIZE);
        try {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_append_string(pointer, KEY, string);
            GnomeProvider.error(GnomeKeyringLibrary.LIBRARY.gnome_keyring_find_items_sync(0, pointer, pointerArray));
        }
        finally {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_free(pointer);
        }
        if (pointerArray[0] != null) {
            try {
                if (GnomeKeyringLibrary.LIBRARY.g_list_length(pointerArray[0]) > 0) {
                    GnomeKeyringLibrary.GnomeKeyringFound gnomeKeyringFound = GnomeKeyringLibrary.LIBRARY.g_list_nth_data(pointerArray[0], 0);
                    if (gnomeKeyringFound != null) {
                        if (gnomeKeyringFound.secret != null) {
                            char[] cArray = gnomeKeyringFound.secret.toCharArray();
                            return cArray;
                        }
                        LOG.warning("#183670: GnomeKeyringFound.secret == null");
                        this.delete(string);
                    } else {
                        LOG.warning("#183670: GList<GnomeKeyringFound>[0].result == null");
                    }
                }
            }
            finally {
                GnomeKeyringLibrary.LIBRARY.gnome_keyring_found_list_free(pointerArray[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string, char[] cArray, String string2) {
        Pointer pointer = GnomeKeyringLibrary.LIBRARY.g_array_new(0, 0, GnomeKeyringLibrary.GnomeKeyringAttribute_SIZE);
        try {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_append_string(pointer, KEY, string);
            int[] nArray = new int[1];
            GnomeProvider.error(GnomeKeyringLibrary.LIBRARY.gnome_keyring_item_create_sync(null, 0, string2 != null ? string2 : string, pointer, new String(cArray), true, nArray));
        }
        finally {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_free(pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String string) {
        int n;
        Pointer[] pointerArray = new Pointer[1];
        Pointer pointer = GnomeKeyringLibrary.LIBRARY.g_array_new(0, 0, GnomeKeyringLibrary.GnomeKeyringAttribute_SIZE);
        try {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_append_string(pointer, KEY, string);
            GnomeProvider.error(GnomeKeyringLibrary.LIBRARY.gnome_keyring_find_items_sync(0, pointer, pointerArray));
        }
        finally {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_attribute_list_free(pointer);
        }
        if (pointerArray[0] == null) {
            return;
        }
        try {
            if (GnomeKeyringLibrary.LIBRARY.g_list_length(pointerArray[0]) > 0) {
                GnomeKeyringLibrary.GnomeKeyringFound gnomeKeyringFound = GnomeKeyringLibrary.LIBRARY.g_list_nth_data(pointerArray[0], 0);
                n = gnomeKeyringFound.item_id;
            } else {
                n = 0;
            }
        }
        finally {
            GnomeKeyringLibrary.LIBRARY.gnome_keyring_found_list_free(pointerArray[0]);
        }
        if (n > 0) {
            if ("SunOS".equals(System.getProperty("os.name")) && "5.10".equals(System.getProperty("os.version"))) {
                this.save(string, new char[0], null);
            } else {
                GnomeProvider.error(GnomeKeyringLibrary.LIBRARY.gnome_keyring_item_delete_sync(null, n));
            }
        }
    }

    private static void error(int n) {
        if (n != 0 && n != 9) {
            LOG.log(Level.WARNING, "gnome-keyring error: {0}", ERRORS[n]);
        }
    }
}

