/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.HeapHistogram;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.core.ui.components.Spacer;
import com.sun.tools.visualvm.heapdump.HeapDumpSupport;
import com.sun.tools.visualvm.profiling.presets.PresetSelector;
import com.sun.tools.visualvm.profiling.presets.ProfilerPresets;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshot;
import com.sun.tools.visualvm.sampler.AbstractSamplerSupport;
import com.sun.tools.visualvm.sampler.cpu.CPUSamplerSupport;
import com.sun.tools.visualvm.sampler.cpu.CPUSettingsSupport;
import com.sun.tools.visualvm.sampler.cpu.ThreadInfoProvider;
import com.sun.tools.visualvm.sampler.cpu.ThreadsCPU;
import com.sun.tools.visualvm.sampler.memory.MemorySamplerSupport;
import com.sun.tools.visualvm.sampler.memory.MemorySettingsSupport;
import com.sun.tools.visualvm.sampler.memory.ThreadsMemory;
import com.sun.tools.visualvm.threaddump.ThreadDumpSupport;
import com.sun.tools.visualvm.tools.attach.AttachModel;
import com.sun.tools.visualvm.tools.attach.AttachModelFactory;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeansFactory;
import com.sun.tools.visualvm.uisupport.HTMLLabel;
import com.sun.tools.visualvm.uisupport.HTMLTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.management.MemoryMXBean;
import java.net.URL;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class SamplerImpl {
    private static final Logger LOGGER = Logger.getLogger(SamplerImpl.class.getName());
    private Application application;
    private Timer timer;
    private HTMLTextArea summaryArea;
    private String cpuStatus = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Checking_Availability");
    private String memoryStatus = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Checking_Availability");
    private boolean cpuProfilingSupported;
    private AbstractSamplerSupport cpuSampler;
    private CPUSettingsSupport cpuSettings;
    private boolean memoryProfilingSupported;
    private AbstractSamplerSupport memorySampler;
    private MemorySettingsSupport memorySettings;
    private PresetSelector refSelector;
    private DataViewComponent dvc;
    private String currentName;
    private DataViewComponent.DetailsView[] currentViews;
    private State state = State.TRANSITION;
    private JPanel view;
    private JLabel modeLabel;
    private JToggleButton cpuButton;
    private JToggleButton memoryButton;
    private JButton stopButton;
    private JLabel statusLabel;
    private HTMLLabel statusValueLabel;
    private static int refLabelHeight = -1;

    SamplerImpl(Application application) {
        this.application = application;
        this.cpuSettings = new CPUSettingsSupport(){

            @Override
            public boolean presetValid() {
                return SamplerImpl.this.cpuSettings.settingsValid() && SamplerImpl.this.memorySettings.settingsValid();
            }

            @Override
            public PresetSelector createSelector(Runnable presetSynchronizer) {
                return SamplerImpl.this.createSelector(presetSynchronizer);
            }
        };
        this.memorySettings = new MemorySettingsSupport(){

            @Override
            public boolean presetValid() {
                return SamplerImpl.this.cpuSettings.settingsValid() && SamplerImpl.this.memorySettings.settingsValid();
            }

            @Override
            public PresetSelector createSelector(Runnable presetSynchronizer) {
                return SamplerImpl.this.createSelector(presetSynchronizer);
            }
        };
    }

    private PresetSelector createSelector(Runnable presetSynchronizer) {
        PresetSelector selector = ProfilerPresets.getInstance().createSelector(this.application, this.refSelector, presetSynchronizer);
        this.refSelector = this.refSelector == null ? selector : null;
        return selector;
    }

    DataViewComponent.MasterView getMasterView() {
        this.initComponents();
        this.setState(State.INACTIVE);
        HierarchyListener hl = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && SamplerImpl.this.view.isShowing()) {
                    SamplerImpl.this.initializeCpuSampling();
                    SamplerImpl.this.initializeMemorySampling();
                    SamplerImpl.this.view.removeHierarchyListener(this);
                }
            }
        };
        this.view.addHierarchyListener(hl);
        return new DataViewComponent.MasterView(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Sampler"), null, (JComponent)this.view);
    }

    void setDataViewComponent(DataViewComponent dvc) {
        this.dvc = dvc;
        this.setCurrentViews(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Information"), this.createSummaryView());
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Settings"), true), 2);
        dvc.addDetailsView(this.cpuSettings.getDetailsView(), 2);
        dvc.addDetailsView(this.memorySettings.getDetailsView(), 2);
        dvc.hideDetailsArea(2);
    }

    void removed() {
        this.terminate();
    }

    void applicationFinished() {
        this.terminate();
    }

    private synchronized void terminate() {
        State currentState = this.getState();
        if (this.cpuSampler != null) {
            if (State.CPU.equals((Object)currentState)) {
                this.cpuSampler.stopSampling();
            }
            this.cpuSampler.terminate();
        }
        if (this.memorySampler != null) {
            if (State.MEMORY.equals((Object)currentState)) {
                this.memorySampler.stopSampling();
            }
            this.memorySampler.terminate();
        }
        this.setState(State.TERMINATED);
        this.dvc = null;
    }

    private void setCurrentViews(String name, DataViewComponent.DetailsView[] views) {
        if (this.dvc == null) {
            return;
        }
        if (this.currentName == null || !this.currentName.equals(name)) {
            this.dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(name, false), 1);
            this.currentName = name;
        }
        if (this.currentViews != views) {
            if (this.currentViews != null) {
                for (DataViewComponent.DetailsView detailsView : this.currentViews) {
                    this.dvc.removeDetailsView(detailsView);
                }
            }
            if (views != null) {
                for (DataViewComponent.DetailsView detailsView : views) {
                    this.dvc.addDetailsView(detailsView, 1);
                }
            }
            this.currentViews = views;
        }
    }

    private synchronized void setState(State state) {
        if (this.state.equals((Object)state)) {
            return;
        }
        this.state = state;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SamplerImpl.this.updateStatus();
                SamplerImpl.this.updateSettings();
                SamplerImpl.this.updateButtons();
            }
        });
    }

    private synchronized State getState() {
        return this.state;
    }

    private void updateStatus() {
        if (this.statusValueLabel != null) {
            String status = NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Undefined");
            switch (this.getState()) {
                case TERMINATED: {
                    status = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Application_terminated");
                    break;
                }
                case INACTIVE: {
                    status = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Sampling_inactive");
                    break;
                }
                case CPU: {
                    status = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Cpu_progress");
                    break;
                }
                case MEMORY: {
                    status = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Memory_progress");
                    break;
                }
                case TRANSITION: {
                    status = NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Refreshing");
                }
            }
            this.statusValueLabel.setText(status);
        }
    }

    private void updateSettings() {
        if (this.cpuSettings != null && this.memorySettings != null) {
            switch (this.getState()) {
                case TERMINATED: 
                case INACTIVE: {
                    this.cpuSettings.setEnabled(true);
                    this.memorySettings.setEnabled(true);
                    break;
                }
                case CPU: 
                case MEMORY: 
                case TRANSITION: {
                    this.cpuSettings.setEnabled(false);
                    this.memorySettings.setEnabled(false);
                }
            }
        }
    }

    private void updateButtons() {
        if (this.cpuButton != null && this.memoryButton != null && this.stopButton != null) {
            switch (this.getState()) {
                case TERMINATED: {
                    this.cpuButton.setSelected(false);
                    this.cpuButton.setEnabled(false);
                    this.memoryButton.setSelected(false);
                    this.memoryButton.setEnabled(false);
                    this.stopButton.setEnabled(false);
                    break;
                }
                case INACTIVE: {
                    this.cpuButton.setSelected(false);
                    this.cpuButton.setEnabled(this.cpuProfilingSupported);
                    this.memoryButton.setSelected(false);
                    this.memoryButton.setEnabled(this.memoryProfilingSupported);
                    this.stopButton.setEnabled(false);
                    break;
                }
                case CPU: {
                    this.cpuButton.setSelected(true);
                    this.cpuButton.setEnabled(true);
                    this.memoryButton.setSelected(false);
                    this.memoryButton.setEnabled(this.memoryProfilingSupported);
                    this.stopButton.setEnabled(true);
                    break;
                }
                case MEMORY: {
                    this.cpuButton.setSelected(false);
                    this.cpuButton.setEnabled(this.cpuProfilingSupported);
                    this.memoryButton.setSelected(true);
                    this.memoryButton.setEnabled(true);
                    this.stopButton.setEnabled(true);
                    break;
                }
                case TRANSITION: {
                    this.cpuButton.setEnabled(false);
                    this.memoryButton.setEnabled(false);
                    this.stopButton.setEnabled(false);
                }
            }
        }
    }

    private void handleCPUProfiling() {
        State currentState = this.getState();
        if (currentState.equals((Object)State.CPU) || currentState.equals((Object)State.TERMINATED) || currentState.equals((Object)State.TRANSITION)) {
            return;
        }
        this.setState(State.TRANSITION);
        final Runnable sessionStarter = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SamplerImpl.this.setCurrentViews(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Cpu_samples"), SamplerImpl.this.cpuSampler.getDetailsView());
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                SamplerImpl.this.cpuSettings.saveSettings();
                                SamplerImpl.this.setState(SamplerImpl.this.cpuSampler.startSampling(SamplerImpl.this.cpuSettings.getSettings(), SamplerImpl.this.cpuSettings.getSamplingRate(), SamplerImpl.this.cpuSettings.getRefreshRate()) ? State.CPU : State.INACTIVE);
                            }
                        });
                    }
                });
            }
        };
        if (currentState.equals((Object)State.MEMORY)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SamplerImpl.this.memorySampler.stopSampling();
                    sessionStarter.run();
                }
            });
        } else {
            sessionStarter.run();
        }
    }

    private void handleMemoryProfiling() {
        State currentState = this.getState();
        if (currentState.equals((Object)State.MEMORY) || currentState.equals((Object)State.TERMINATED) || currentState.equals((Object)State.TRANSITION)) {
            return;
        }
        this.setState(State.TRANSITION);
        final Runnable sessionStarter = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SamplerImpl.this.setCurrentViews(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Memory_samples"), SamplerImpl.this.memorySampler.getDetailsView());
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                SamplerImpl.this.memorySettings.saveSettings();
                                SamplerImpl.this.setState(SamplerImpl.this.memorySampler.startSampling(SamplerImpl.this.memorySettings.getSettings(), SamplerImpl.this.memorySettings.getSamplingRate(), SamplerImpl.this.memorySettings.getRefreshRate()) ? State.MEMORY : State.INACTIVE);
                            }
                        });
                    }
                });
            }
        };
        if (currentState.equals((Object)State.CPU)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SamplerImpl.this.cpuSampler.stopSampling();
                    sessionStarter.run();
                }
            });
        } else {
            sessionStarter.run();
        }
    }

    private void handleStopProfiling() {
        State currentState = this.getState();
        if (currentState.equals((Object)State.INACTIVE) || currentState.equals((Object)State.TERMINATED) || currentState.equals((Object)State.TRANSITION)) {
            return;
        }
        this.setState(State.TRANSITION);
        if (currentState.equals((Object)State.CPU)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SamplerImpl.this.cpuSampler.stopSampling();
                    SamplerImpl.this.setState(State.INACTIVE);
                }
            });
        } else if (currentState.equals((Object)State.MEMORY)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SamplerImpl.this.memorySampler.stopSampling();
                    SamplerImpl.this.setState(State.INACTIVE);
                }
            });
        }
    }

    private void initializeCpuSampling() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ThreadInfoProvider ti = new ThreadInfoProvider(SamplerImpl.this.application);
                final String status = ti.getStatus();
                if (status != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SamplerImpl.this.cpuStatus = status;
                            SamplerImpl.this.refreshSummary();
                        }
                    });
                    return;
                }
                CPUSamplerSupport.SnapshotDumper snapshotDumper = new CPUSamplerSupport.SnapshotDumper(){

                    @Override
                    public void takeSnapshot(final boolean openView) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                LoadedSnapshot ls = null;
                                try {
                                    ls = this.takeNPSSnapshot(SamplerImpl.this.application.getStorage().getDirectory());
                                }
                                catch (CPUResultsSnapshot.NoDataAvailableException e) {
                                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SamplerImpl.class, (String)"MSG_No_save_data_cpu"), 2));
                                }
                                catch (Throwable t) {
                                    LOGGER.log(Level.WARNING, "Failed to save profiler snapshot for " + SamplerImpl.this.application, t);
                                }
                                if (ls != null) {
                                    ProfilerSnapshot ps = ProfilerSnapshot.createSnapshot((File)ls.getFile(), (DataSource)SamplerImpl.this.application);
                                    SamplerImpl.this.application.getRepository().addDataSource((DataSource)ps);
                                    if (openView) {
                                        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)ps);
                                    }
                                }
                            }
                        });
                    }
                };
                ThreadsCPU tcpu = new ThreadsCPU(ti.getThreadMXBean(), JmxModelFactory.getJmxModelFor((Application)SamplerImpl.this.application).getMBeanServerConnection());
                try {
                    tcpu.getThreadsCPUInfo();
                }
                catch (Exception ex) {
                    tcpu = null;
                }
                final ThreadDumpSupport tds = ThreadDumpSupport.getInstance();
                final String noThreadDump = tds.supportsThreadDump(SamplerImpl.this.application) ? null : NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Thread_dump_unsupported");
                final String noThreadCPU = tcpu != null ? null : NbBundle.getMessage(SamplerImpl.class, (String)"MSG_ThreadCPU_unsupported");
                CPUSamplerSupport.ThreadDumper threadDumper = noThreadDump != null ? null : new CPUSamplerSupport.ThreadDumper(){

                    @Override
                    public void takeThreadDump(boolean openView) {
                        tds.takeThreadDump(SamplerImpl.this.application, openView);
                    }
                };
                SamplerImpl.this.cpuSampler = new CPUSamplerSupport(ti, tcpu, snapshotDumper, threadDumper){

                    @Override
                    protected Timer getTimer() {
                        return SamplerImpl.this.getTimer();
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String avail = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Available");
                        if (noThreadDump != null || noThreadCPU != null) {
                            String[] msgs = new String[2];
                            int i = 0;
                            if (noThreadDump != null) {
                                msgs[i++] = noThreadDump;
                            }
                            if (noThreadCPU != null) {
                                msgs[i++] = noThreadCPU;
                            }
                            if (i == 1) {
                                avail = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Available_details", (Object)msgs[0]);
                            } else if (i == 2) {
                                avail = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Available_details2", (Object)msgs[0], (Object)msgs[1]);
                            }
                        }
                        SamplerImpl.this.cpuStatus = avail + " " + NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Press_cpu");
                        SamplerImpl.this.cpuProfilingSupported = true;
                        SamplerImpl.this.refreshSummary();
                        SamplerImpl.this.updateButtons();
                        SamplerImpl.this.updateSettings();
                    }
                });
            }
        });
    }

    private void initializeMemorySampling() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                JvmMXBeans mxbeans;
                boolean hasPermGenHisto;
                if (SamplerImpl.this.application.getState() != 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SamplerImpl.this.memoryStatus = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Unavailable");
                            SamplerImpl.this.refreshSummary();
                        }
                    });
                    return;
                }
                Jvm jvm = JvmFactory.getJVMFor((Application)SamplerImpl.this.application);
                try {
                    HeapHistogram histogram = jvm.takeHeapHistogram();
                    if (histogram == null) {
                        if (!SamplerImpl.this.application.isLocalApplication()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SamplerImpl.this.memoryStatus = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Unavailable_remote");
                                    SamplerImpl.this.refreshSummary();
                                }
                            });
                            return;
                        }
                        if (!JvmFactory.getJVMFor((Application)SamplerImpl.this.application).isAttachable()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SamplerImpl.this.memoryStatus = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Unavailable_connect_jdk");
                                    SamplerImpl.this.refreshSummary();
                                }
                            });
                            return;
                        }
                        AttachModel attachModel = AttachModelFactory.getAttachFor((Application)SamplerImpl.this.application);
                        if (attachModel == null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SamplerImpl.this.memoryStatus = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Unavailable_connect_log");
                                    SamplerImpl.this.refreshSummary();
                                }
                            });
                            LOGGER.log(Level.WARNING, "AttachModelFactory.getAttachFor(application) returns null for " + SamplerImpl.this.application);
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SamplerImpl.this.memoryStatus = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Unavailable_read_log");
                                SamplerImpl.this.refreshSummary();
                            }
                        });
                        LOGGER.log(Level.WARNING, "attachModel.takeHeapHistogram() returns null for " + SamplerImpl.this.application);
                        return;
                    }
                    hasPermGenHisto = !histogram.getPermGenHistogram().isEmpty();
                }
                catch (Throwable t) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SamplerImpl.this.memoryStatus = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Unavailable_read_log");
                            SamplerImpl.this.refreshSummary();
                        }
                    });
                    LOGGER.log(Level.WARNING, "attachModel.takeHeapHistogram() throws Throwable for " + SamplerImpl.this.application, t);
                    return;
                }
                MemoryMXBean memoryBean = null;
                ThreadsMemory threadsMemory = null;
                JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)SamplerImpl.this.application);
                if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED && (mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel)) != null) {
                    memoryBean = mxbeans.getMemoryMXBean();
                    try {
                        threadsMemory = new ThreadsMemory(mxbeans.getThreadMXBean(), jmxModel.getMBeanServerConnection());
                        threadsMemory.getThreadsMemoryInfo();
                    }
                    catch (Exception ex) {
                        threadsMemory = null;
                    }
                }
                final String noPerformGC = memoryBean == null ? NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Gc_unsupported") : null;
                final String noThreadMem = threadsMemory == null ? NbBundle.getMessage(SamplerImpl.class, (String)"MSG_ThreadMemory_unsupported") : null;
                final HeapDumpSupport hds = HeapDumpSupport.getInstance();
                final boolean local = SamplerImpl.this.application.isLocalApplication();
                boolean supportsHD = local ? hds.supportsHeapDump(SamplerImpl.this.application) : hds.supportsRemoteHeapDump(SamplerImpl.this.application);
                final String noHeapDump = supportsHD ? null : NbBundle.getMessage(SamplerImpl.class, (String)"MSG_HeapDump_unsupported");
                MemorySamplerSupport.SnapshotDumper snapshotDumper = new MemorySamplerSupport.SnapshotDumper(){

                    @Override
                    public void takeSnapshot(final boolean openView) {
                        final 7 dumper = this;
                        RequestProcessor.getDefault().post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                LoadedSnapshot ls = null;
                                FilterOutputStream dos = null;
                                try {
                                    long time = System.currentTimeMillis();
                                    AllocMemoryResultsSnapshot snapshot = dumper.createSnapshot(time);
                                    if (snapshot == null) {
                                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SamplerImpl.class, (String)"MSG_No_save_data_memory"), 2));
                                    } else {
                                        ls = new LoadedSnapshot((ResultsSnapshot)snapshot, ProfilingSettingsPresets.createMemoryPreset(), null, null);
                                        File file = Utils.getUniqueFile((File)SamplerImpl.this.application.getStorage().getDirectory(), (String)Long.toString(time), (String)".nps");
                                        dos = new DataOutputStream(new FileOutputStream(file));
                                        ls.save((DataOutputStream)dos);
                                        ls.setFile(file);
                                        ls.setSaved(true);
                                    }
                                }
                                catch (Throwable t) {
                                    LOGGER.log(Level.WARNING, "Failed to save profiler snapshot for " + SamplerImpl.this.application, t);
                                }
                                finally {
                                    try {
                                        if (dos != null) {
                                            dos.close();
                                        }
                                    }
                                    catch (IOException e) {
                                        LOGGER.log(Level.WARNING, "Problem closing output stream for  " + dos, e);
                                    }
                                }
                                if (ls != null) {
                                    ProfilerSnapshot ps = ProfilerSnapshot.createSnapshot((File)ls.getFile(), (DataSource)SamplerImpl.this.application);
                                    SamplerImpl.this.application.getRepository().addDataSource((DataSource)ps);
                                    if (openView) {
                                        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)ps);
                                    }
                                }
                            }
                        });
                    }
                };
                MemorySamplerSupport.HeapDumper heapDumper = noHeapDump != null ? null : new MemorySamplerSupport.HeapDumper(){

                    @Override
                    public void takeHeapDump(boolean openView) {
                        if (local) {
                            hds.takeHeapDump(SamplerImpl.this.application, openView);
                        } else {
                            hds.takeRemoteHeapDump(SamplerImpl.this.application, null, openView);
                        }
                    }
                };
                SamplerImpl.this.memorySampler = new MemorySamplerSupport(jvm, hasPermGenHisto, threadsMemory, memoryBean, snapshotDumper, heapDumper){

                    @Override
                    protected Timer getTimer() {
                        return SamplerImpl.this.getTimer();
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String avail = NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Available");
                        if (noPerformGC != null || noHeapDump != null || noThreadMem != null) {
                            String[] msgs = new String[3];
                            int i = 0;
                            if (noHeapDump != null) {
                                msgs[i++] = noHeapDump;
                            }
                            if (noPerformGC != null) {
                                msgs[i++] = noPerformGC;
                            }
                            if (noThreadMem != null) {
                                msgs[i++] = noThreadMem;
                            }
                            avail = i == 1 ? NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Available_details", (Object)msgs[0]) : (i == 2 ? NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Available_details2", (Object)msgs[0], (Object)msgs[1]) : NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Available_details3", (Object)msgs[0], (Object)msgs[1], (Object)msgs[2]));
                        }
                        SamplerImpl.this.memoryStatus = avail + " " + NbBundle.getMessage(SamplerImpl.class, (String)"MSG_Press_mem");
                        SamplerImpl.this.memoryProfilingSupported = true;
                        SamplerImpl.this.refreshSummary();
                        SamplerImpl.this.updateButtons();
                        SamplerImpl.this.updateSettings();
                    }
                });
            }
        });
    }

    private synchronized Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer("Sampler timer for " + DataSourceDescriptorFactory.getDescriptor((DataSource)this.application).getName());
        }
        return this.timer;
    }

    private DataViewComponent.DetailsView[] createSummaryView() {
        this.summaryArea = new HTMLTextArea();
        this.summaryArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.refreshSummary();
        return new DataViewComponent.DetailsView[]{new DataViewComponent.DetailsView(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Summary"), null, 10, (JComponent)new ScrollableContainer((JComponent)this.summaryArea), null)};
    }

    private void refreshSummary() {
        StringBuilder builder = new StringBuilder();
        SamplerImpl.addCpuHeader(builder);
        builder.append(this.cpuStatus);
        SamplerImpl.addMemoryHeader(builder);
        builder.append(this.memoryStatus);
        int selStart = this.summaryArea.getSelectionStart();
        int selEnd = this.summaryArea.getSelectionEnd();
        this.summaryArea.setText(builder.toString());
        this.summaryArea.select(selStart, selEnd);
    }

    private static void addCpuHeader(StringBuilder builder) {
        builder.append(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Cpu_sampling"));
    }

    private static void addMemoryHeader(StringBuilder builder) {
        builder.append(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Memory_sampling"));
    }

    private void initComponents() {
        this.view = new JPanel(new GridBagLayout());
        this.view.setOpaque(false);
        this.view.setBorder(BorderFactory.createEmptyBorder(11, 5, 8, 5));
        this.modeLabel = new JLabel(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Profile"));
        this.modeLabel.setFont(this.modeLabel.getFont().deriveFont(1));
        Dimension d = this.modeLabel.getPreferredSize();
        this.modeLabel.setText(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Sample"));
        d.width = Math.max(d.width, this.modeLabel.getPreferredSize().width);
        this.modeLabel.setPreferredSize(d);
        this.modeLabel.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(4, 8, 0, 0);
        this.view.add((Component)this.modeLabel, constraints);
        this.cpuButton = new OneWayToggleButton(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Cpu"));
        this.cpuButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/cpu.png", (boolean)true)));
        this.cpuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SamplerImpl.this.handleCPUProfiling();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(4, 8, 0, 0);
        this.view.add((Component)this.cpuButton, constraints);
        this.memoryButton = new OneWayToggleButton(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Memory"));
        this.memoryButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/memory.png", (boolean)true)));
        this.memoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SamplerImpl.this.handleMemoryProfiling();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(4, 8, 0, 0);
        this.view.add((Component)this.memoryButton, constraints);
        this.stopButton = new JButton(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Stop"));
        this.stopButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/stop.png", (boolean)true)));
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SamplerImpl.this.handleStopProfiling();
            }
        });
        this.stopButton.setEnabled(false);
        this.stopButton.setDefaultCapable(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 4;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(4, 8, 0, 0);
        this.view.add((Component)this.stopButton, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 5;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.view.add((Component)Spacer.create(), constraints);
        this.statusLabel = new JLabel(NbBundle.getMessage(SamplerImpl.class, (String)"LBL_Status"));
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
        this.statusLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(6, 8, 4, 0);
        this.view.add((Component)this.statusLabel, constraints);
        this.statusValueLabel = new HTMLLabel(){

            public void setText(String text) {
                super.setText("<nobr>" + text + "</nobr>");
            }

            protected void showURL(URL url) {
            }

            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = SamplerImpl.getRefLabelHeight();
                return dim;
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.statusValueLabel.setOpaque(false);
        this.statusValueLabel.setFocusable(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(6, 8, 4, 8);
        this.view.add((Component)this.statusValueLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.view.add((Component)Spacer.create(), constraints);
        Dimension cpuD = this.cpuButton.getPreferredSize();
        Dimension memoryD = this.memoryButton.getPreferredSize();
        Dimension stopD = this.stopButton.getPreferredSize();
        Dimension maxD = new Dimension(Math.max(cpuD.width, memoryD.width), Math.max(cpuD.height, memoryD.height));
        maxD = new Dimension(Math.max(maxD.width, stopD.width), Math.max(maxD.height, stopD.height));
        this.cpuButton.setPreferredSize(maxD);
        this.cpuButton.setMinimumSize(maxD);
        this.memoryButton.setPreferredSize(maxD);
        this.memoryButton.setMinimumSize(maxD);
        this.stopButton.setPreferredSize(maxD);
        this.stopButton.setMinimumSize(maxD);
    }

    private static int getRefLabelHeight() {
        if (refLabelHeight == -1) {
            refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;
        }
        return refLabelHeight;
    }

    private static final class OneWayToggleButton
    extends JToggleButton {
        public OneWayToggleButton(String text) {
            super(text);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (!this.isSelected()) {
                super.processMouseEvent(e);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (!this.isSelected()) {
                super.processKeyEvent(e);
            }
        }
    }

    private static enum State {
        TERMINATED,
        INACTIVE,
        CPU,
        MEMORY,
        TRANSITION;

    }
}

