/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.memory;

import com.sun.tools.visualvm.sampler.AbstractSamplerSupport;
import com.sun.tools.visualvm.sampler.memory.MemorySamplerSupport;
import com.sun.tools.visualvm.sampler.memory.MemoryView;
import com.sun.tools.visualvm.sampler.memory.ThreadsMemoryInfo;
import com.sun.tools.visualvm.uisupport.HTMLTextArea;
import com.sun.tools.visualvm.uisupport.SeparatorLine;
import com.sun.tools.visualvm.uisupport.TransparentToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadInfo;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class ThreadsMemoryView
extends JPanel {
    private final AbstractSamplerSupport.Refresher refresher;
    private boolean forceRefresh = false;
    private final MemoryMXBean memoryBean;
    private final MemorySamplerSupport.HeapDumper heapDumper;
    private HTMLTextArea area;
    private AbstractButton deltaButton;
    private AbstractButton pauseButton;
    private AbstractButton refreshButton;
    private AbstractButton gcButton;
    private AbstractButton heapdumpButton;
    private JExtendedTable resTable;
    private ExtendedTableModel resTableModel;
    private JExtendedTablePanel resTablePanel;
    private FilterComponent filterComponent;
    private CustomBarCellRenderer customBarCellRenderer;
    private LabelTableCellRenderer labelTableCellRenderer;
    private LabelBracketTableCellRenderer labelBracketTableCellRenderer;
    private String filterString = "";
    private int filterType = 20;
    private List<ThreadInfo> threads;
    private List<Long> allocatedBytes;
    private List<Long> allocatedBytesPerSec;
    private ThreadsMemoryInfo currentThreadsInfo;
    private ThreadsMemoryInfo baseThreadsInfo;
    private List<Integer> filteredSortedIndexes = new ArrayList<Integer>();
    private int totalThreads = -1;
    private long totalBytes;
    private long baseTotalBytes = -1L;
    private int sortingColumn = 1;
    private boolean sortOrder = false;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private Class[] columnTypes;
    private int[] columnWidths;
    private int minNamesColumnWidth;

    ThreadsMemoryView(AbstractSamplerSupport.Refresher refresher, MemoryMXBean memoryBean, MemorySamplerSupport.HeapDumper heapDumper) {
        this.refresher = refresher;
        this.memoryBean = memoryBean;
        this.heapDumper = heapDumper;
        this.initColumnsData();
        this.initComponents();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ThreadsMemoryView.this.isShowing()) {
                    ThreadsMemoryView.this.refresher.refresh();
                }
            }
        });
    }

    void initSession() {
    }

    boolean isPaused() {
        return this.pauseButton.isSelected() && !this.forceRefresh;
    }

    boolean isEmpty() {
        return this.resTableModel.getRowCount() == 0;
    }

    void refresh(ThreadsMemoryInfo info) {
        if (this.isPaused()) {
            return;
        }
        this.forceRefresh = false;
        this.threads = info.getThreads();
        this.allocatedBytes = info.getAllocatedBytes();
        this.totalBytes = info.getTotalBytes();
        if (this.currentThreadsInfo != null) {
            this.allocatedBytesPerSec = this.currentThreadsInfo.getAllocatedBytesPerSecond(info);
        }
        this.currentThreadsInfo = info;
        if (this.deltaButton.isSelected()) {
            if (this.baseThreadsInfo == null) {
                this.baseThreadsInfo = info;
                this.baseTotalBytes = this.totalBytes;
                this.columnRenderers[2] = this.labelTableCellRenderer;
                this.updateColumnRenderers();
            }
            this.totalThreads = this.threads.size() - this.baseThreadsInfo.getThreads().size();
            this.allocatedBytes = this.baseThreadsInfo.getAllocatedDiffBytes(info);
            this.totalBytes = this.baseThreadsInfo.getTotalDiffBytes();
        } else {
            if (this.baseThreadsInfo != null) {
                this.baseThreadsInfo = null;
                this.baseTotalBytes = -1L;
                this.columnRenderers[2] = this.labelBracketTableCellRenderer;
                this.updateColumnRenderers();
            }
            this.allocatedBytes = info.getAllocatedBytes();
            this.totalBytes = info.getTotalBytes();
            this.totalThreads = this.threads.size();
        }
        this.customBarCellRenderer.setMaximum(this.totalBytes);
        this.updateData(false);
        this.refreshUI();
    }

    void terminate() {
        this.pauseButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.deltaButton.setEnabled(false);
        this.gcButton.setEnabled(false);
        this.heapdumpButton.setEnabled(false);
    }

    private void updateData(boolean sortOnly) {
        int selectedRow = this.resTable.getSelectedRow();
        String selectedRowContents = null;
        if (selectedRow != -1) {
            selectedRowContents = (String)this.resTable.getValueAt(selectedRow, 0);
        }
        if (!sortOnly) {
            this.filterData();
        }
        this.sortData();
        this.resTableModel.fireTableDataChanged();
        if (selectedRowContents != null) {
            this.resTable.selectRowByContents(selectedRowContents, 0, false);
        }
    }

    private void filterData() {
        this.filteredSortedIndexes.clear();
        String[] filterStrings = FilterComponent.getFilterValues((String)this.filterString);
        if (this.filterType == 0 || filterStrings == null || filterStrings[0].equals("")) {
            for (int i = 0; i < this.threads.size(); ++i) {
                this.filteredSortedIndexes.add(i);
            }
        } else {
            for (int i = 0; i < this.threads.size(); ++i) {
                if (!ThreadsMemoryView.passedFilters(this.threads.get(i).getThreadName(), filterStrings, this.filterType)) continue;
                this.filteredSortedIndexes.add(i);
            }
        }
    }

    private static boolean passedFilters(String value, String[] filters, int type) {
        for (int i = 0; i < filters.length; ++i) {
            if (!ThreadsMemoryView.passedFilter(value, filters[i], type)) continue;
            return true;
        }
        return false;
    }

    private static boolean passedFilter(String value, String filter, int type) {
        switch (type) {
            case 10: {
                return value.regionMatches(true, 0, filter, 0, filter.length());
            }
            case 20: {
                return value.toLowerCase().indexOf(filter.toLowerCase()) != -1;
            }
            case 30: {
                return value.regionMatches(true, value.length() - filter.length(), filter, 0, filter.length());
            }
            case 40: {
                return value.equalsIgnoreCase(filter);
            }
            case 50: {
                return value.matches(filter);
            }
        }
        return false;
    }

    private void sortData() {
        Collections.sort(this.filteredSortedIndexes, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer index1 = (Integer)o1;
                Integer index2 = (Integer)o2;
                switch (ThreadsMemoryView.this.sortingColumn) {
                    case 0: {
                        ThreadInfo ti1 = (ThreadInfo)ThreadsMemoryView.this.threads.get(index1);
                        ThreadInfo ti2 = (ThreadInfo)ThreadsMemoryView.this.threads.get(index2);
                        return ThreadsMemoryView.this.sortOrder ? Long.valueOf(ti1.getThreadId()).compareTo(ti2.getThreadId()) : Long.valueOf(ti2.getThreadId()).compareTo(ti1.getThreadId());
                    }
                    case 1: 
                    case 2: {
                        Long alloc1 = (Long)ThreadsMemoryView.this.allocatedBytes.get(index1);
                        Long alloc2 = (Long)ThreadsMemoryView.this.allocatedBytes.get(index2);
                        return ThreadsMemoryView.this.sortOrder ? alloc1.compareTo(alloc2) : alloc2.compareTo(alloc1);
                    }
                    case 3: {
                        Long allocSec1 = (Long)ThreadsMemoryView.this.allocatedBytesPerSec.get(index1);
                        Long allocSec2 = (Long)ThreadsMemoryView.this.allocatedBytesPerSec.get(index2);
                        return ThreadsMemoryView.this.sortOrder ? allocSec1.compareTo(allocSec2) : allocSec2.compareTo(allocSec1);
                    }
                }
                return 0;
            }
        });
    }

    private JExtendedTable initTable() {
        this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

            public String getColumnName(int col) {
                return ThreadsMemoryView.this.columnNames[col];
            }

            public int getRowCount() {
                return ThreadsMemoryView.this.filteredSortedIndexes.size();
            }

            public int getColumnCount() {
                return ThreadsMemoryView.this.columnNames.length;
            }

            public Class getColumnClass(int col) {
                return ThreadsMemoryView.this.columnTypes[col];
            }

            public Object getValueAt(int row, int col) {
                int index = (Integer)ThreadsMemoryView.this.filteredSortedIndexes.get(row);
                long alloc = (Long)ThreadsMemoryView.this.allocatedBytes.get(index);
                boolean deltas = ThreadsMemoryView.this.baseThreadsInfo != null;
                NumberFormat formatter = NumberFormat.getInstance();
                switch (col) {
                    case 0: {
                        ThreadInfo threadInfo = (ThreadInfo)ThreadsMemoryView.this.threads.get(index);
                        return threadInfo.getThreadName();
                    }
                    case 1: {
                        return alloc;
                    }
                    case 2: {
                        if (deltas) {
                            return alloc > 0L ? "+" + formatter.format(alloc) : formatter.format(alloc);
                        }
                        return alloc == 0L ? "0 (0.0%)" : formatter.format(alloc) + " (" + this.getPercentValue(alloc, ThreadsMemoryView.this.totalBytes) + "%)";
                    }
                    case 3: {
                        if (ThreadsMemoryView.this.allocatedBytesPerSec != null) {
                            return formatter.format((Long)ThreadsMemoryView.this.allocatedBytesPerSec.get(index));
                        }
                        return "0";
                    }
                }
                return null;
            }

            private String getPercentValue(float value, float basevalue) {
                int basis = (int)(value / basevalue * 1000.0f);
                int percent = basis / 10;
                int permille = basis % 10;
                return "" + percent + "." + permille;
            }

            public String getColumnToolTipText(int col) {
                return ThreadsMemoryView.this.columnToolTips[col];
            }

            public void sortByColumn(int column, boolean order) {
                ThreadsMemoryView.this.sortingColumn = column;
                ThreadsMemoryView.this.sortOrder = order;
                ThreadsMemoryView.this.updateData(true);
            }

            public boolean getInitialSorting(int column) {
                switch (column) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }
        });
        this.resTable = new JExtendedTable((TableModel)this.resTableModel){

            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                for (int i = 0; i < ThreadsMemoryView.this.resTableModel.getColumnCount(); ++i) {
                    int index = ThreadsMemoryView.this.resTableModel.getRealColumn(i);
                    if (index == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += this.getColumnModel().getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    this.getColumnModel().getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, ThreadsMemoryView.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.resTableModel.setTable((JTable)this.resTable);
        this.resTableModel.setInitialSorting(this.sortingColumn, this.sortOrder);
        this.resTable.setRowSelectionAllowed(true);
        this.resTable.setSelectionMode(0);
        this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.resTable.setShowHorizontalLines(false);
        this.resTable.setShowVerticalLines(true);
        this.resTable.setRowMargin(0);
        this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.resTable.getAccessibleContext().setAccessibleName("");
        this.resTable.getAccessibleContext().setAccessibleDescription("");
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>(this.resTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.resTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet(this.resTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.resTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        return this.resTable;
    }

    protected void initColumnsData() {
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 13;
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        this.customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        this.labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnNames = new String[]{NbBundle.getMessage(MemoryView.class, (String)"COL_Thread_name"), NbBundle.getMessage(MemoryView.class, (String)"COL_ABytes_rel"), NbBundle.getMessage(MemoryView.class, (String)"COL_ABytes"), NbBundle.getMessage(MemoryView.class, (String)"COL_ABytes_Sec")};
        this.columnToolTips = new String[]{NbBundle.getMessage(MemoryView.class, (String)"COL_Thread_name"), NbBundle.getMessage(MemoryView.class, (String)"COL_ABytes_rel"), NbBundle.getMessage(MemoryView.class, (String)"COL_ABytes"), NbBundle.getMessage(MemoryView.class, (String)"COL_ABytes_Sec")};
        this.columnTypes = new Class[]{String.class, Number.class, String.class, String.class};
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, this.customBarCellRenderer, this.labelBracketTableCellRenderer, this.labelTableCellRenderer};
        this.columnWidths = new int[]{maxWidth, maxWidth, maxWidth, maxWidth};
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index == 0) {
                colModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            }
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void updateColumnRenderers() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[this.resTableModel.getRealColumn(i)]);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        TransparentToolBar toolBar = new TransparentToolBar();
        this.pauseButton = new JToggleButton(){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                boolean selected = ThreadsMemoryView.this.pauseButton.isSelected();
                ThreadsMemoryView.this.refreshButton.setEnabled(selected);
                if (!selected) {
                    ThreadsMemoryView.this.refresher.refresh();
                }
            }
        };
        this.pauseButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/pause.png", (boolean)true)));
        this.pauseButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Pause_results"));
        this.pauseButton.setOpaque(false);
        toolBar.addItem((Component)this.pauseButton);
        this.refreshButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                ThreadsMemoryView.this.forceRefresh = true;
                ThreadsMemoryView.this.refresher.refresh();
            }
        };
        this.refreshButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/update.png", (boolean)true)));
        this.refreshButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Update_results"));
        this.refreshButton.setEnabled(this.pauseButton.isSelected());
        this.refreshButton.setOpaque(false);
        toolBar.addItem((Component)this.refreshButton);
        toolBar.addSeparator();
        this.deltaButton = new JToggleButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_Deltas")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                ThreadsMemoryView.this.refresher.refresh();
            }
        };
        this.deltaButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Deltas"));
        this.deltaButton.setOpaque(false);
        toolBar.addItem((Component)this.deltaButton);
        toolBar.addFiller();
        this.gcButton = new JButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_Gc")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ThreadsMemoryView.this.memoryBean.gc();
                        }
                        catch (Exception e) {
                            this.setEnabled(false);
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                });
            }
        };
        this.gcButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Gc"));
        this.gcButton.setOpaque(false);
        this.gcButton.setEnabled(this.memoryBean != null);
        toolBar.addItem((Component)this.gcButton);
        this.heapdumpButton = new JButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_HeapDump")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                ThreadsMemoryView.this.heapDumper.takeHeapDump((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }
        };
        this.heapdumpButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_HeapDump"));
        this.heapdumpButton.setOpaque(false);
        this.heapdumpButton.setEnabled(this.heapDumper != null);
        toolBar.addItem((Component)this.heapdumpButton);
        int maxHeight = this.pauseButton.getPreferredSize().height;
        maxHeight = Math.max(maxHeight, this.refreshButton.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.deltaButton.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.gcButton.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.heapdumpButton.getPreferredSize().height);
        int width = this.pauseButton.getPreferredSize().width;
        Dimension size = new Dimension(maxHeight, maxHeight);
        this.pauseButton.setMinimumSize(size);
        this.pauseButton.setPreferredSize(size);
        this.pauseButton.setMaximumSize(size);
        width = this.refreshButton.getPreferredSize().width;
        size = new Dimension(maxHeight, maxHeight);
        this.refreshButton.setMinimumSize(size);
        this.refreshButton.setPreferredSize(size);
        this.refreshButton.setMaximumSize(size);
        width = this.deltaButton.getPreferredSize().width;
        size = new Dimension(width + 5, maxHeight);
        this.deltaButton.setMinimumSize(size);
        this.deltaButton.setPreferredSize(size);
        this.deltaButton.setMaximumSize(size);
        width = this.gcButton.getPreferredSize().width;
        size = new Dimension(width + 5, maxHeight);
        this.gcButton.setMinimumSize(size);
        this.gcButton.setPreferredSize(size);
        this.gcButton.setMaximumSize(size);
        width = this.heapdumpButton.getPreferredSize().width;
        size = new Dimension(width + 5, maxHeight);
        this.heapdumpButton.setMinimumSize(size);
        this.heapdumpButton.setPreferredSize(size);
        this.heapdumpButton.setMaximumSize(size);
        JPanel resultsPanel = new JPanel(new BorderLayout());
        resultsPanel.setOpaque(false);
        JPanel areaPanel = new JPanel(new BorderLayout());
        areaPanel.setOpaque(false);
        this.area = new HTMLTextArea();
        this.area.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.refreshUI();
        areaPanel.add((Component)this.area, "North");
        areaPanel.add((Component)new SeparatorLine(true), "South");
        resultsPanel.add((Component)areaPanel, "North");
        this.add((Component)TransparentToolBar.withSeparator((TransparentToolBar)toolBar), "North");
        this.resTable = this.initTable();
        this.resTable.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ThreadsMemoryView.this.revalidate();
            }
        });
        this.resTablePanel = new JExtendedTablePanel(this.resTable);
        this.resTablePanel.clearBorders();
        resultsPanel.add((Component)this.resTablePanel, "Center");
        this.add((Component)resultsPanel, "Center");
        this.initFilterPanel();
    }

    private void initFilterPanel() {
        this.filterComponent = FilterComponent.create((boolean)true, (boolean)true);
        this.filterComponent.setFilter(this.filterString, this.filterType);
        this.filterComponent.setHint(NbBundle.getMessage(MemoryView.class, (String)"LBL_Thread_filter"));
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ThreadsMemoryView.this.filterString = ThreadsMemoryView.this.filterComponent.getFilterValue();
                ThreadsMemoryView.this.filterType = ThreadsMemoryView.this.filterComponent.getFilterType();
                ThreadsMemoryView.this.updateData(false);
            }
        });
        this.add((Component)this.filterComponent.getComponent(), "South");
    }

    private void refreshUI() {
        int selStart = this.area.getSelectionStart();
        int selEnd = this.area.getSelectionEnd();
        this.area.setText(this.getBasicTelemetry());
        this.area.select(selStart, selEnd);
    }

    private String getBasicTelemetry() {
        String sThreads;
        boolean deltas;
        boolean bl = deltas = this.baseThreadsInfo != null;
        String string = this.totalThreads == -1 ? "" : (sThreads = (deltas && this.totalThreads > 0 ? "+" : "") + NumberFormat.getInstance().format(this.totalThreads));
        String sBytes = this.totalBytes == -1L ? "" : (deltas && this.totalBytes > 0L ? "+" : "") + NumberFormat.getInstance().format(this.totalBytes);
        String ssThreads = NbBundle.getMessage(MemoryView.class, (String)"LBL_Threads", (Object)sThreads);
        String ssBytes = NbBundle.getMessage(MemoryView.class, (String)"LBL_ABytes", (Object)sBytes);
        return "<nobr>" + ssThreads + "&nbsp;&nbsp;&nbsp;&nbsp;" + ssBytes + "</nobr>";
    }
}

