/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.search.provider.SearchListener;
import org.openide.filesystems.FileObject;

public class BufferedCharSequence
implements CharSequence {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.search.BufferedCharSequence");
    public static final int K = 1024;
    public static final int MAX_FILE_SIZE = Integer.MAX_VALUE;
    private static final int MAX_SOURCE_BUFFER_SIZE = 16384;
    public static final int MAX_SUBSEQUENCE_LENGTH = 4096;
    private static final int MIN_SINK_BUFFER_SIZE = 16;
    private Source source;
    private Sink sink;
    private final CharsetDecoder decoder;
    private SearchListener listener;
    private long maxReadOffset = 0L;
    private CoderResult coderResult;
    private boolean isClosed = false;
    private volatile boolean isTerminated = false;
    private int position = 0;

    @Deprecated
    public BufferedCharSequence(InputStream inputStream, CharsetDecoder charsetDecoder, long l) {
        this.source = new Source(inputStream, l);
        this.decoder = charsetDecoder;
        this.sink = new Sink(this.source);
    }

    public BufferedCharSequence(FileObject fileObject, CharsetDecoder charsetDecoder, long l) {
        this.source = new Source(fileObject, l);
        this.decoder = charsetDecoder;
        this.sink = new Sink(this.source);
        LOG.log(Level.FINER, "<init> {0}; decoder = {1}; {2}", new Object[]{this.source, this.decoder, this.sink});
    }

    private BufferedCharSequence(BufferedCharSequence bufferedCharSequence) {
        this.source = bufferedCharSequence.source;
        this.sink = bufferedCharSequence.sink;
        this.decoder = bufferedCharSequence.decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public int getMaxBufferSize() {
        return this.source.maxBufferSize;
    }

    public void setMaxBufferSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.source.maxBufferSize = n;
    }

    public void setSearchListener(SearchListener searchListener) {
        this.listener = searchListener;
    }

    public BufferedCharSequence reset() throws SourceIOException {
        this.source.reset();
        this.sink.reset();
        this.decoder.reset();
        this.coderResult = CoderResult.UNDERFLOW;
        return this;
    }

    public synchronized BufferedCharSequence close() throws IOException {
        if (!this.isClosed) {
            this.reset();
            this.source.close();
            this.source = null;
            this.sink = null;
            this.coderResult = null;
            this.listener = null;
            this.isClosed = true;
        }
        return this;
    }

    void terminate() {
        this.isTerminated = true;
    }

    public BufferedCharSequence duplicate() {
        this.checkState();
        return new BufferedCharSequence(this);
    }

    @Override
    public int length() {
        this.checkState();
        this.reset();
        int n = 0;
        try {
            while (this.sink.next()) {
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new SourceIOException(characterCodingException);
        }
        n = this.sink.buffer.scope.end;
        return n;
    }

    @Override
    public char charAt(int n) throws IndexOutOfBoundsException {
        if (this.isTerminated) {
            throw new TerminatedException();
        }
        this.checkState();
        String string = this.check(n);
        if (string != null) {
            throw new IndexOutOfBoundsException(string);
        }
        return this.getCharAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) throws IndexOutOfBoundsException {
        this.checkState();
        String string = this.check(n, n2);
        if (string != null) {
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = this.getLength(n, n2);
        if (n3 > 4096) {
            throw new IndexOutOfBoundsException("requested subSequence has a big length (" + n3 + ") > " + 4096);
        }
        CharSequence charSequence = this.getSubSequence(n, n2);
        return charSequence;
    }

    @Override
    public String toString() {
        this.checkState();
        return this.subSequence(0, this.length()).toString();
    }

    public final int position() {
        this.checkState();
        return this.position;
    }

    public final int changePosition(int n) {
        int n2 = this.position;
        this.position = n;
        return n2;
    }

    public char nextChar() throws IndexOutOfBoundsException {
        this.checkState();
        return this.charAt(this.position++);
    }

    public final BufferedCharSequence rewind() {
        this.checkState();
        this.position = 0;
        return this;
    }

    public String nextLineText() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            while (true) {
                char c = this.nextChar();
                switch (c) {
                    case '\n': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        return stringBuilder.toString();
                    }
                    case '\r': {
                        if (this.charAt(this.position) == '\n') {
                            this.nextChar();
                        }
                        return stringBuilder.toString();
                    }
                }
                stringBuilder.append(c);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return stringBuilder.toString();
        }
    }

    public String getLineText(int n) {
        int n2 = this.changePosition(n);
        String string = this.nextLineText();
        this.changePosition(n2);
        return string;
    }

    private char getCharAt(int n) throws IndexOutOfBoundsException {
        if (this.sink.buffer.scope.isBefore(n)) {
            this.reset();
        }
        while (!this.sink.buffer.scope.isInside(n)) {
            boolean bl;
            try {
                bl = this.sink.next();
            }
            catch (CharacterCodingException characterCodingException) {
                throw new SourceIOException(characterCodingException);
            }
            if (this.listener != null && (long)this.sink.buffer.scope.start > this.maxReadOffset) {
                this.maxReadOffset = this.sink.buffer.scope.start;
                this.listener.fileContentMatchingProgress(this.source.fo.getPath(), this.maxReadOffset);
            }
            if (bl) continue;
            throw new IndexOutOfBoundsException("index is " + n + " > lenght");
        }
        return this.sink.charAt(n);
    }

    private CharSequence getSubSequence(int n, int n2) throws IndexOutOfBoundsException {
        StringBuilder stringBuilder = new StringBuilder(this.getLength(n, n2));
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(this.charAt(i));
        }
        return stringBuilder.toString();
    }

    private int getLength(int n, int n2) {
        return n2 - n;
    }

    private void checkState() {
        if (this.isClosed) {
            String string = "BufferedCharSequence is closed";
            throw new IllegalStateException(string);
        }
    }

    private String check(int n) {
        if (n < 0) {
            return "index = " + n;
        }
        return null;
    }

    private String check(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2) {
            return "start = " + n + ", end = " + n2;
        }
        return null;
    }

    static class TerminatedException
    extends RuntimeException {
    }

    public static class SourceIOException
    extends RuntimeException {
        public SourceIOException(IOException iOException) {
            super(iOException);
        }
    }

    private class Sink {
        private Buffer buffer;
        private boolean wasEndOfInput;

        public Sink(Source source) {
            int n = source.getCapacity();
            this.buffer = this.newBuffer(n);
        }

        public String toString() {
            return "sink = [" + this.buffer + "]";
        }

        public void reset() {
            this.wasEndOfInput = false;
            this.buffer.reset();
        }

        public char charAt(int n) throws IndexOutOfBoundsException {
            assert (n >= 0);
            return this.buffer.getCharAt(n);
        }

        private boolean next() throws CharacterCodingException {
            if (this.wasEndOfInput) {
                return false;
            }
            CharBuffer charBuffer = this.buffer.clear();
            boolean bl = this.wasEndOfInput;
            do {
                if (BufferedCharSequence.this.coderResult == CoderResult.UNDERFLOW) {
                    bl = BufferedCharSequence.this.source.readNext();
                }
                BufferedCharSequence.this.coderResult = BufferedCharSequence.this.decoder.decode(BufferedCharSequence.this.source.buffer, charBuffer, bl);
                if (BufferedCharSequence.this.coderResult.isOverflow()) {
                    charBuffer = this.buffer.growBuffer();
                }
                this.checkError(BufferedCharSequence.this.coderResult);
            } while (charBuffer.position() == 0 && BufferedCharSequence.this.coderResult.isUnderflow() && !bl);
            if (bl) {
                while ((BufferedCharSequence.this.coderResult = BufferedCharSequence.this.decoder.flush(charBuffer)) == CoderResult.OVERFLOW) {
                    charBuffer = this.buffer.growBuffer();
                }
                this.checkError(BufferedCharSequence.this.coderResult);
            }
            this.buffer.adjustScope();
            this.wasEndOfInput = bl;
            return !this.buffer.scope.isEmpty();
        }

        private void checkError(CoderResult coderResult) throws CharacterCodingException {
            if (coderResult.isError()) {
                coderResult.throwException();
            }
        }

        private Buffer newBuffer(int n) {
            return new Buffer(n);
        }

        private class Buffer {
            private CharBuffer charBuffer;
            private Scope scope = new Scope();

            public Buffer(int n) {
                this.allocate(n);
                this.reset();
            }

            public String toString() {
                return "buffer[capacity = " + this.charBuffer.capacity() + "]";
            }

            public CharBuffer growBuffer() {
                int n = this.charBuffer.capacity();
                CharBuffer charBuffer = CharBuffer.allocate(n << 1);
                this.charBuffer.flip();
                charBuffer.put(this.charBuffer);
                this.charBuffer = charBuffer;
                LOG.finer("The sink char buffer capacity has been grown: " + n + " -> " + this.charBuffer.capacity());
                return this.charBuffer;
            }

            private void allocate(int n) {
                if (n == 0) {
                    this.charBuffer = CharBuffer.allocate(0);
                    return;
                }
                int n2 = this.bufferSize(n);
                this.charBuffer = CharBuffer.allocate(n2);
            }

            private int bufferSize(int n) {
                int n2 = (int)((float)n * BufferedCharSequence.this.decoder.averageCharsPerByte());
                return n2 < 16 ? 16 : n2;
            }

            private char getCharAt(int n) {
                int n2 = this.charBuffer.position();
                this.charBuffer.position(0);
                char c = this.charBuffer.charAt(n - this.scope.start);
                this.charBuffer.position(n2);
                return c;
            }

            private void reset() {
                this.scope.reset();
                this.charBuffer.clear();
            }

            private void flip() {
                this.charBuffer.flip();
            }

            private CharBuffer clear() {
                this.charBuffer.clear();
                return this.charBuffer;
            }

            private void adjustScope() {
                this.scope.start = this.scope.end == -1 ? 0 : this.scope.end;
                this.flip();
                this.scope.end = this.scope.start + this.charBuffer.limit();
            }

            private class Scope {
                public static final int EOF = -1;
                private int start;
                private int end;

                private Scope() {
                }

                public boolean isInside(int n) {
                    return n >= this.start && n < this.end;
                }

                public boolean isBefore(int n) {
                    return this.start == -1 || n < this.start;
                }

                public void reset() {
                    this.end = -1;
                    this.start = -1;
                }

                private boolean isEmpty() {
                    return this.start == this.end;
                }
            }
        }
    }

    private class Source {
        private int maxBufferSize = 16384;
        private FileObject fo = null;
        private ByteBuffer buffer;
        private InputStream istream;
        private BufferedInputStream bstream;
        private int bufferSize;

        @Deprecated
        public Source(InputStream inputStream, long l) {
            this.bstream = new BufferedInputStream(inputStream);
            this.bstream.mark(Integer.MAX_VALUE);
            this.bufferSize = this.getBufferSize(l);
            this.buffer = this.newBuffer();
            this.buffer.position(this.buffer.limit());
        }

        public Source(FileObject fileObject, long l) {
            this.fo = fileObject;
            this.bufferSize = this.getBufferSize(l);
            this.initStreams();
            this.buffer = this.newBuffer();
            this.buffer.position(this.buffer.limit());
        }

        public String toString() {
            return "source=[stream = " + this.bstream.toString() + ", buffer = " + this.buffer + "]";
        }

        private ByteBuffer newBuffer() {
            return ByteBuffer.allocate(this.bufferSize);
        }

        public void reset() {
            try {
                if (this.fo == null) {
                    this.bstream.reset();
                } else {
                    this.closeStreams();
                    this.initStreams();
                }
            }
            catch (IOException iOException) {
                throw new SourceIOException(iOException);
            }
            this.buffer.clear();
            this.buffer.position(this.buffer.limit());
        }

        private int read() {
            try {
                if (this.buffer.hasArray()) {
                    if (this.buffer.capacity() == 0) {
                        return -1;
                    }
                    int n = this.bstream.read(this.buffer.array(), this.buffer.position(), this.buffer.remaining());
                    if (n > 0) {
                        this.buffer.position(n + this.buffer.position());
                    }
                    return n;
                }
                throw new IOException("No byte array");
            }
            catch (IOException iOException) {
                throw new SourceIOException(iOException);
            }
        }

        public void close() throws IOException {
            this.closeStreams();
        }

        private void initStreams() {
            try {
                this.istream = this.fo.getInputStream();
                try {
                    this.bstream = new BufferedInputStream(this.istream, this.bufferSize);
                }
                catch (Throwable throwable) {
                    if (this.istream != null) {
                        this.istream.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                throw new SourceIOException(new IOException(throwable));
            }
        }

        private void closeStreams() throws IOException {
            IOException iOException = null;
            try {
                if (this.bstream != null) {
                    this.bstream.close();
                    this.bstream = null;
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (this.istream != null) {
                this.istream.close();
                this.istream = null;
            }
            if (iOException != null) {
                throw iOException;
            }
        }

        public int getSize(long l) {
            if (l > Integer.MAX_VALUE) {
                LOG.warning("File size is " + l + "bytes. " + "Only first " + Integer.MAX_VALUE + " bytes will be processed.");
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        private int getBufferSize(long l) {
            int n = Math.min(this.getSize(l), this.maxBufferSize);
            return n;
        }

        public boolean readNext() {
            this.buffer.compact();
            int n = this.read();
            this.buffer.flip();
            return n == -1;
        }

        private int getCapacity() {
            return this.buffer.capacity();
        }
    }

    static interface UnicodeLineTerminator {
        public static final char LF = '\n';
        public static final char CR = '\r';
        public static final char LS = '\u2028';
        public static final char PS = '\u2029';
        public static final char NEL = '\u0085';
    }
}

