/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import org.openide.util.Lookup;

public abstract class LifecycleManager {
    protected LifecycleManager() {
    }

    public static LifecycleManager getDefault() {
        LifecycleManager lifecycleManager = (LifecycleManager)Lookup.getDefault().lookup(LifecycleManager.class);
        if (lifecycleManager == null) {
            lifecycleManager = new Trivial();
        }
        return lifecycleManager;
    }

    public abstract void saveAll();

    public abstract void exit();

    public void exit(int n) {
        this.exit();
    }

    public void markForRestart() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private static final class Trivial
    extends LifecycleManager {
        @Override
        public void exit() {
            System.exit(0);
        }

        @Override
        public void exit(int n) {
            System.exit(n);
        }

        @Override
        public void saveAll() {
        }
    }
}

