/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;

public class EnhancedTreeCellRenderer
extends JPanel
implements TreeCellRendererPersistent {
    protected Color backgroundNonSelectionColor;
    protected Color backgroundSelectionColor = UIConstants.TABLE_SELECTION_BACKGROUND_COLOR;
    protected Color borderSelectionColor;
    protected Color textNonSelectionColor;
    protected Color textSelectionColor = UIConstants.TABLE_SELECTION_FOREGROUND_COLOR;
    protected boolean hasFocus;
    protected boolean selected;
    private transient Icon closedIcon = UIManager.getIcon("Tree.closedIcon");
    private transient Icon leafIcon = UIManager.getIcon("Tree.leafIcon");
    private transient Icon openIcon = UIManager.getIcon("Tree.openIcon");
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JTree tree;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);

    public EnhancedTreeCellRenderer() {
        super(null);
        this.setOpaque(false);
        this.label1 = new InternalLabel();
        this.label2 = new InternalLabel();
        this.label3 = new InternalLabel();
        this.label2.setFont(this.label1.getFont().deriveFont(1));
        this.add(this.label1);
        this.add(this.label2);
        this.add(this.label3);
        this.label1.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    @Override
    public void doLayout() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.label1.getPreferredSize();
        Dimension dimension3 = this.label2.getPreferredSize();
        Dimension dimension4 = this.label3.getPreferredSize();
        dimension.height = Math.max(dimension.height, dimension2.height);
        dimension.height = Math.max(dimension.height, dimension3.height);
        dimension.height = Math.max(dimension.height, dimension4.height);
        int n = 0;
        if ("".equals(this.label1.getText())) {
            dimension2.width += this.label1.getIconTextGap();
        }
        this.label1.setBounds(n, 0, dimension2.width, dimension.height);
        this.label2.setBounds(n += dimension2.width, 0, dimension3.width, dimension.height);
        this.label3.setBounds(n += dimension3.width, 0, dimension4.width, dimension.height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.label1.getPreferredSize();
        if ("".equals(this.label1.getText())) {
            dimension.width += this.label1.getIconTextGap();
        }
        dimension.width += this.label2.getPreferredSize().width;
        dimension.width += this.label3.getPreferredSize().width;
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = object != null ? object.toString() : "";
        this.tree = jTree;
        this.hasFocus = bl4;
        this.label1.setText(this.getLabel1Text(object, string));
        this.label2.setText(this.getLabel2Text(object, string));
        this.label3.setText(this.getLabel3Text(object, string));
        if (bl) {
            this.label1.setForeground(this.getTextSelectionColor());
            this.label2.setForeground(this.getTextSelectionColor());
            Color color = this.getTextSelectionColor();
            this.label3.setForeground(UIUtils.getDisabledForeground(color));
        } else {
            this.label1.setForeground(this.getTextNonSelectionColor());
            this.label2.setForeground(this.getTextNonSelectionColor());
            Color color = this.getTextNonSelectionColor();
            this.label3.setForeground(UIUtils.getDisabledForeground(color));
        }
        if (!jTree.isEnabled()) {
            this.label1.setEnabled(false);
            this.label2.setEnabled(false);
            this.label3.setEnabled(false);
            if (bl3) {
                this.label1.setDisabledIcon(this.getLeafIcon(object));
            } else if (bl2) {
                this.label1.setDisabledIcon(this.getOpenIcon(object));
            } else {
                this.label1.setDisabledIcon(this.getClosedIcon(object));
            }
        } else {
            this.label1.setEnabled(true);
            this.label2.setEnabled(true);
            this.label3.setEnabled(true);
            if (bl3) {
                this.label1.setIcon(this.getLeafIcon(object));
            } else if (bl2) {
                this.label1.setIcon(this.getOpenIcon(object));
            } else {
                this.label1.setIcon(this.getClosedIcon(object));
            }
        }
        this.label1.setComponentOrientation(jTree.getComponentOrientation());
        this.selected = bl;
        return this;
    }

    @Override
    public Component getTreeCellRendererComponentPersistent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        EnhancedTreeCellRenderer enhancedTreeCellRenderer = new EnhancedTreeCellRenderer();
        enhancedTreeCellRenderer.setLeafIcon(this.leafIcon);
        enhancedTreeCellRenderer.setClosedIcon(this.closedIcon);
        enhancedTreeCellRenderer.setOpenIcon(this.openIcon);
        return enhancedTreeCellRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    @Override
    public void paint(Graphics graphics) {
        Color color;
        Color color2;
        if (this.selected) {
            color2 = this.getBackgroundSelectionColor();
        } else {
            color2 = this.getBackgroundNonSelectionColor();
            if (color2 == null) {
                color2 = this.getBackground();
            }
        }
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.hasFocus && (color = this.getBorderSelectionColor()) != null) {
            graphics.setColor(color);
            graphics.drawRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(graphics);
    }

    protected Icon getClosedIcon(Object object) {
        return this.getClosedIcon();
    }

    protected String getLabel1Text(Object object, String string) {
        return string;
    }

    protected String getLabel2Text(Object object, String string) {
        return "";
    }

    protected String getLabel3Text(Object object, String string) {
        return "";
    }

    protected Icon getLeafIcon(Object object) {
        return this.getLeafIcon();
    }

    protected Icon getOpenIcon(Object object) {
        return this.getOpenIcon();
    }

    @Override
    public Insets getInsets() {
        return ZERO_INSETS;
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            this.doLayout();
        }
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    private static class InternalLabel
    extends JLabel {
        private FontMetrics fontMetrics;
        private String text;
        private Color foreground;
        private boolean enabled;

        private InternalLabel() {
        }

        @Override
        public void setText(String string) {
            this.text = string;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void setForeground(Color color) {
            this.foreground = color;
        }

        @Override
        public Color getForeground() {
            return this.foreground;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            if (this.fontMetrics == null) {
                this.fontMetrics = super.getFontMetrics(font);
            }
            return this.fontMetrics;
        }

        @Override
        public void setFont(Font font) {
            this.fontMetrics = null;
            super.setFont(font);
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public void repaint(Rectangle rectangle) {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void setDisplayedMnemonic(int n) {
        }

        @Override
        public void setDisplayedMnemonic(char c) {
        }

        @Override
        public void setDisplayedMnemonicIndex(int n) {
        }

        @Override
        public void firePropertyChange(String string, byte by, byte by2) {
        }

        @Override
        public void firePropertyChange(String string, char c, char c2) {
        }

        @Override
        public void firePropertyChange(String string, short s, short s2) {
        }

        @Override
        public void firePropertyChange(String string, int n, int n2) {
        }

        @Override
        public void firePropertyChange(String string, long l, long l2) {
        }

        @Override
        public void firePropertyChange(String string, float f, float f2) {
        }

        @Override
        public void firePropertyChange(String string, double d, double d2) {
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics) {
            Graphics graphics2 = this.getComponentGraphics(graphics);
            Graphics graphics3 = graphics2 == null ? null : graphics2.create();
            try {
                this.paintComponent(graphics3);
            }
            finally {
                graphics3.dispose();
            }
        }
    }
}

