/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.utils.StringUtils;

public class CodeRegionLivePanel
extends JPanel
implements LiveResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String PANEL_NAME = messages.getString("CodeRegionLivePanel_PanelName");
    private static final String NO_RESULTS_TERMINATED_MSG = messages.getString("CodeRegionLivePanel_NoResultsTerminatedMsg");
    private static final String NO_RESULTS_REGION_MSG = messages.getString("CodeRegionLivePanel_NoResultsRegionMsg");
    private static final String INDIVIDUAL_TIMES_MSG = messages.getString("CodeRegionLivePanel_IndividualTimesMsg");
    private static final String SUMMARY_TIMES_MSG = messages.getString("CodeRegionLivePanel_SummaryTimesMsg");
    private static final String TOTAL_INVOCATIONS_MSG = messages.getString("CodeRegionLivePanel_TotalInvocationsMsg");
    private static final String ALL_REMEMBERED_MSG = messages.getString("CodeRegionLivePanel_AllRememberedMsg");
    private static final String LAST_REMEMBERED_MSG = messages.getString("CodeRegionLivePanel_LastRememberedMsg");
    private static final String INVOCATIONS_LISTED_MSG = messages.getString("CodeRegionLivePanel_InvocationsListedMsg");
    private static final String AREA_ACCESS_NAME = messages.getString("CodeRegionLivePanel_AreaAccessName");
    private HTMLTextArea resArea;
    private ProfilerClient profilerClient;

    public CodeRegionLivePanel(ProfilerClient profilerClient) {
        this.profilerClient = profilerClient;
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout());
        this.resArea = new HTMLTextArea();
        this.resArea.getAccessibleContext().setAccessibleName(AREA_ACCESS_NAME);
        this.add((Component)new JScrollPane(this.resArea), "Center");
    }

    @Override
    public int getSortingColumn() {
        return -1;
    }

    @Override
    public boolean getSortingOrder() {
        return false;
    }

    public String getTitle() {
        return PANEL_NAME;
    }

    @Override
    public BufferedImage getViewImage(boolean bl) {
        return null;
    }

    @Override
    public String getViewName() {
        return null;
    }

    @Override
    public boolean fitsVisibleArea() {
        return true;
    }

    @Override
    public void handleRemove() {
    }

    @Override
    public void handleShutdown() {
    }

    @Override
    public boolean hasView() {
        return false;
    }

    @Override
    public void reset() {
        this.updateLiveResults();
    }

    @Override
    public boolean supports(int n) {
        return n == 1;
    }

    @Override
    public void updateLiveResults() {
        try {
            CodeRegionResultsSnapshot codeRegionResultsSnapshot = this.profilerClient.getCodeRegionProfilingResultsSnapshot();
            this.resArea.setText(this.getResultsText(codeRegionResultsSnapshot.getTimes(), codeRegionResultsSnapshot.getTimerCountsInSecond()));
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            this.resArea.setText("<i>" + NO_RESULTS_TERMINATED_MSG + "</i>");
        }
    }

    private String getResultsText(long[] lArray, long l) {
        StringBuilder stringBuilder = new StringBuilder(lArray.length * 10);
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        if (lArray.length < 2) {
            stringBuilder.append("<i>").append(NO_RESULTS_REGION_MSG).append("</i>");
        } else {
            long l3;
            long l4 = l3 = lArray[1];
            int n = lArray.length - 1;
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 1; i < lArray.length; ++i) {
                long l5 = lArray[i];
                l2 += l5;
                if (l5 > l3) {
                    l3 = l5;
                } else if (l5 < l4) {
                    l4 = l5;
                }
                stringBuffer2.append(MessageFormat.format(INDIVIDUAL_TIMES_MSG, StringUtils.mcsTimeToString((long)(l5 * 1000000L / l))));
                stringBuffer2.append("<br>");
            }
            stringBuffer.append(MessageFormat.format(SUMMARY_TIMES_MSG, StringUtils.mcsTimeToString((long)(l2 * 1000000L / l)), StringUtils.mcsTimeToString((long)((long)((double)l2 * 1000000.0 / (double)n / (double)l))), StringUtils.mcsTimeToString((long)(l4 * 1000000L / l)), StringUtils.mcsTimeToString((long)(l3 * 1000000L / l))));
            stringBuilder.append(MessageFormat.format(TOTAL_INVOCATIONS_MSG, "" + lArray[0]));
            stringBuilder.append(", ");
            if (lArray[0] <= (long)n) {
                stringBuilder.append(ALL_REMEMBERED_MSG);
            } else {
                stringBuilder.append(MessageFormat.format(LAST_REMEMBERED_MSG, "" + n));
            }
            stringBuilder.append("<br>");
            stringBuilder.append(stringBuffer);
            stringBuilder.append("<br><br><hr><br>");
            stringBuilder.append(stringBuffer2);
            stringBuilder.append("<br><hr><br>");
            stringBuilder.append(MessageFormat.format(INVOCATIONS_LISTED_MSG, "" + n));
            stringBuilder.append(", ");
            stringBuilder.append(stringBuffer);
        }
        return stringBuilder.toString();
    }
}

