/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.naming.spi.NamingManager;

class ServiceLocator {
    private static final String SRV_RR = "SRV";
    private static final String[] SRV_RR_ATTR = new String[]{"SRV"};
    private static final Random random = new Random();

    private ServiceLocator() {
    }

    static String mapDnToDomainName(String dn) throws InvalidNameException {
        if (dn == null) {
            return null;
        }
        StringBuffer domain = new StringBuffer();
        LdapName ldapName = new LdapName(dn);
        List<Rdn> rdnList = ldapName.getRdns();
        for (int i = rdnList.size() - 1; i >= 0; --i) {
            Rdn rdn = rdnList.get(i);
            if (rdn.size() == 1 && "dc".equalsIgnoreCase(rdn.getType())) {
                Object attrval = rdn.getValue();
                if (attrval instanceof String) {
                    if (attrval.equals(".") || domain.length() == 1 && domain.charAt(0) == '.') {
                        domain.setLength(0);
                    }
                    if (domain.length() > 0) {
                        domain.append('.');
                    }
                    domain.append(attrval);
                    continue;
                }
                domain.setLength(0);
                continue;
            }
            domain.setLength(0);
        }
        return domain.length() != 0 ? domain.toString() : null;
    }

    static String[] getLdapService(String domainName, Hashtable environment) {
        if (domainName == null || domainName.length() == 0) {
            return null;
        }
        String dnsUrl = "dns:///_ldap._tcp." + domainName;
        String[] hostports = null;
        try {
            Attribute attr;
            Context ctx = NamingManager.getURLContext("dns", environment);
            if (!(ctx instanceof DirContext)) {
                return null;
            }
            Attributes attrs = ((DirContext)ctx).getAttributes(dnsUrl, SRV_RR_ATTR);
            if (attrs != null && (attr = attrs.get(SRV_RR)) != null) {
                int numValues = attr.size();
                int numRecords = 0;
                Object[] srvRecords = new SrvRecord[numValues];
                int j = 0;
                for (int i = 0; i < numValues; ++i) {
                    try {
                        srvRecords[j] = new SrvRecord((String)attr.get(i));
                        ++j;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                numRecords = j;
                if (numRecords < numValues) {
                    SrvRecord[] trimmed = new SrvRecord[numRecords];
                    System.arraycopy(srvRecords, 0, trimmed, 0, numRecords);
                    srvRecords = trimmed;
                }
                if (numRecords > 1) {
                    Arrays.sort(srvRecords);
                }
                hostports = ServiceLocator.extractHostports((SrvRecord[])srvRecords);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return hostports;
    }

    private static String[] extractHostports(SrvRecord[] srvRecords) {
        String[] hostports = null;
        int head = 0;
        int tail = 0;
        int sublistLength = 0;
        int k = 0;
        for (int i = 0; i < srvRecords.length; ++i) {
            if (hostports == null) {
                hostports = new String[srvRecords.length];
            }
            head = i;
            while (i < srvRecords.length - 1 && srvRecords[i].priority == srvRecords[i + 1].priority) {
                ++i;
            }
            tail = i;
            sublistLength = tail - head + 1;
            for (int j = 0; j < sublistLength; ++j) {
                hostports[k++] = ServiceLocator.selectHostport(srvRecords, head, tail);
            }
        }
        return hostports;
    }

    private static String selectHostport(SrvRecord[] srvRecords, int head, int tail) {
        if (head == tail) {
            return srvRecords[head].hostport;
        }
        int sum = 0;
        for (int i = head; i <= tail; ++i) {
            if (srvRecords[i] == null) continue;
            srvRecords[i].sum = sum += srvRecords[i].weight;
        }
        String hostport = null;
        int target = sum == 0 ? 0 : random.nextInt(sum + 1);
        for (int i = head; i <= tail; ++i) {
            if (srvRecords[i] == null || srvRecords[i].sum < target) continue;
            hostport = srvRecords[i].hostport;
            srvRecords[i] = null;
            break;
        }
        return hostport;
    }

    static class SrvRecord
    implements Comparable {
        int priority;
        int weight;
        int sum;
        String hostport;

        SrvRecord(String srvRecord) throws Exception {
            StringTokenizer tokenizer = new StringTokenizer(srvRecord, " ");
            if (tokenizer.countTokens() != 4) {
                throw new IllegalArgumentException();
            }
            this.priority = Integer.parseInt(tokenizer.nextToken());
            this.weight = Integer.parseInt(tokenizer.nextToken());
            String port = tokenizer.nextToken();
            this.hostport = tokenizer.nextToken() + ":" + port;
        }

        public int compareTo(Object o) {
            SrvRecord that = (SrvRecord)o;
            if (this.priority > that.priority) {
                return 1;
            }
            if (this.priority < that.priority) {
                return -1;
            }
            if (this.weight == 0 && that.weight != 0) {
                return -1;
            }
            if (this.weight != 0 && that.weight == 0) {
                return 1;
            }
            return 0;
        }
    }
}

