/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.list;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class TaskInfo
implements Writeable<TaskInfo>,
ToXContent {
    private final DiscoveryNode node;
    private final TaskId taskId;
    private final String type;
    private final String action;
    private final String description;
    private final long startTime;
    private final long runningTimeNanos;
    private final Task.Status status;
    private final TaskId parentTaskId;

    public TaskInfo(DiscoveryNode node, long id, String type, String action, String description, Task.Status status, long startTime, long runningTimeNanos, TaskId parentTaskId) {
        this.node = node;
        this.taskId = new TaskId(node.getId(), id);
        this.type = type;
        this.action = action;
        this.description = description;
        this.status = status;
        this.startTime = startTime;
        this.runningTimeNanos = runningTimeNanos;
        this.parentTaskId = parentTaskId;
    }

    public TaskInfo(StreamInput in) throws IOException {
        this.node = DiscoveryNode.readNode(in);
        this.taskId = new TaskId(this.node.getId(), in.readLong());
        this.type = in.readString();
        this.action = in.readString();
        this.description = in.readOptionalString();
        this.status = in.readBoolean() ? in.readTaskStatus() : null;
        this.startTime = in.readLong();
        this.runningTimeNanos = in.readLong();
        this.parentTaskId = new TaskId(in);
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public DiscoveryNode getNode() {
        return this.node;
    }

    public long getId() {
        return this.taskId.getId();
    }

    public String getType() {
        return this.type;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public Task.Status getStatus() {
        return this.status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getRunningTimeNanos() {
        return this.runningTimeNanos;
    }

    public TaskId getParentTaskId() {
        return this.parentTaskId;
    }

    @Override
    public TaskInfo readFrom(StreamInput in) throws IOException {
        return new TaskInfo(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.node.writeTo(out);
        out.writeLong(this.taskId.getId());
        out.writeString(this.type);
        out.writeString(this.action);
        out.writeOptionalString(this.description);
        if (this.status != null) {
            out.writeBoolean(true);
            out.writeTaskStatus(this.status);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.startTime);
        out.writeLong(this.runningTimeNanos);
        this.parentTaskId.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("node", this.node.getId());
        builder.field("id", this.taskId.getId());
        builder.field("type", this.type);
        builder.field("action", this.action);
        if (this.status != null) {
            builder.field("status", this.status, params);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        builder.dateValueField("start_time_in_millis", "start_time", this.startTime);
        builder.timeValueField("running_time_in_nanos", "running_time", this.runningTimeNanos, TimeUnit.NANOSECONDS);
        if (this.parentTaskId.isSet()) {
            builder.field("parent_task_id", this.parentTaskId.toString());
        }
        return builder;
    }
}

