/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.component;

import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public abstract class AbstractComponent {
    protected final ESLogger logger;
    protected final DeprecationLogger deprecationLogger;
    protected final Settings settings;

    public AbstractComponent(Settings settings) {
        this.logger = Loggers.getLogger(this.getClass(), settings, new String[0]);
        this.deprecationLogger = new DeprecationLogger(this.logger);
        this.settings = settings;
    }

    public AbstractComponent(Settings settings, Class customClass) {
        this.logger = Loggers.getLogger(customClass, settings, new String[0]);
        this.deprecationLogger = new DeprecationLogger(this.logger);
        this.settings = settings;
    }

    public final String nodeName() {
        return this.settings.get("name", "");
    }

    protected void logDeprecatedSetting(String settingName, String alternativeName) {
        if (!Strings.isNullOrEmpty(this.settings.get(settingName))) {
            this.deprecationLogger.deprecated("Setting [{}] is deprecated, use [{}] instead", settingName, alternativeName);
        }
    }

    protected void logRemovedSetting(String settingName, String alternativeName) {
        if (!Strings.isNullOrEmpty(this.settings.get(settingName))) {
            this.deprecationLogger.deprecated("Setting [{}] has been removed, use [{}] instead", settingName, alternativeName);
        }
    }
}

