/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;

public abstract class IndexCacheableQuery
extends Query {
    private Object readerCacheKey;

    public Query rewrite(IndexReader reader) throws IOException {
        if (reader.getCoreCacheKey() != this.readerCacheKey) {
            IndexCacheableQuery rewritten = (IndexCacheableQuery)this.clone();
            rewritten.readerCacheKey = reader.getCoreCacheKey();
            return rewritten;
        }
        return super.rewrite(reader);
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.readerCacheKey == ((IndexCacheableQuery)((Object)obj)).readerCacheKey;
    }

    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.readerCacheKey);
    }

    public final Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (this.readerCacheKey == null) {
            throw new IllegalStateException("Rewrite first");
        }
        if (this.readerCacheKey != searcher.getIndexReader().getCoreCacheKey()) {
            throw new IllegalStateException("Must create weight on the same reader which has been used for rewriting");
        }
        return this.doCreateWeight(searcher, needsScores);
    }

    public abstract Weight doCreateWeight(IndexSearcher var1, boolean var2) throws IOException;
}

