/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.routes;

import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.internal.routes.RoutesCompiler;
import org.gradle.play.internal.routes.RoutesCompilerAdapterV22X;
import org.gradle.play.internal.routes.RoutesCompilerAdapterV23X;
import org.gradle.play.internal.routes.RoutesCompilerAdapterV24X;
import org.gradle.play.internal.routes.VersionedRoutesCompilerAdapter;
import org.gradle.play.platform.PlayPlatform;

public class RoutesCompilerFactory {
    public static RoutesCompiler create(PlayPlatform playPlatform) {
        return new RoutesCompiler(RoutesCompilerFactory.createAdapter(playPlatform));
    }

    public static VersionedRoutesCompilerAdapter createAdapter(PlayPlatform playPlatform) {
        String playVersion = playPlatform.getPlayVersion();
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_2_X: {
                return new RoutesCompilerAdapterV22X(playVersion);
            }
            case PLAY_2_3_X: {
                return new RoutesCompilerAdapterV23X(playVersion);
            }
            case PLAY_2_4_X: {
                return new RoutesCompilerAdapterV24X(playVersion);
            }
        }
        throw new RuntimeException("Could not create routes compile spec for Play version: " + playVersion);
    }
}

