/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;

public class DirectBuildDependencies
extends AbstractTaskDependency {
    private final DependencySet dependencies;
    private final PublishArtifactSet publishArtifacts;

    public static TaskDependency forDependenciesOnly(Configuration configuration) {
        return new DirectBuildDependencies(configuration.getAllDependencies(), null);
    }

    public static TaskDependency forDependenciesAndArtifacts(Configuration configuration) {
        return new DirectBuildDependencies(configuration.getAllDependencies(), configuration.getAllArtifacts());
    }

    private DirectBuildDependencies(DependencySet dependencies, PublishArtifactSet artifacts) {
        this.dependencies = dependencies;
        this.publishArtifacts = artifacts;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        for (SelfResolvingDependency dependency : this.dependencies.withType(SelfResolvingDependency.class)) {
            if (dependency instanceof ProjectDependency) continue;
            context.add((Object)dependency);
        }
        if (this.publishArtifacts != null) {
            context.add((Object)this.publishArtifacts);
        }
    }
}

