/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.Nullable;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.groovy.scripts.internal.StatementTransformer;
import org.gradle.internal.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstUtils {
    private AstUtils() {
    }

    public static boolean isMethodOnThis(MethodCallExpression call, String name) {
        boolean hasName = call.getMethod() instanceof ConstantExpression && call.getMethod().getText().equals(name);
        return hasName && AstUtils.targetIsThis(call);
    }

    public static boolean targetIsThis(MethodCallExpression call) {
        Expression target = call.getObjectExpression();
        return target instanceof VariableExpression && target.getText().equals("this");
    }

    public static void visitScriptCode(SourceUnit source, GroovyCodeVisitor transformer) {
        source.getAST().getStatementBlock().visit(transformer);
        for (Object method : source.getAST().getMethods()) {
            MethodNode methodNode = (MethodNode)method;
            methodNode.getCode().visit(transformer);
        }
    }

    public static ClassNode getScriptClass(SourceUnit source) {
        if (source.getAST().getStatementBlock().getStatements().isEmpty() && source.getAST().getMethods().isEmpty()) {
            return null;
        }
        return (ClassNode)source.getAST().getClasses().get(0);
    }

    public static void removeMethod(ClassNode declaringClass, MethodNode methodNode) {
        declaringClass.getMethods().remove(methodNode);
        declaringClass.getDeclaredMethods(methodNode.getName()).clear();
    }

    public static void filterAndTransformStatements(SourceUnit source, StatementTransformer transformer) {
        ListIterator<Statement> statementIterator = source.getAST().getStatementBlock().getStatements().listIterator();
        while (statementIterator.hasNext()) {
            Statement originalStatement = (Statement)statementIterator.next();
            Statement transformedStatement = transformer.transform(source, originalStatement);
            if (transformedStatement == null) {
                statementIterator.remove();
                continue;
            }
            if (transformedStatement == originalStatement) continue;
            statementIterator.set(transformedStatement);
        }
    }

    public static boolean isVisible(SourceUnit source, String className) {
        try {
            source.getClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Nullable
    public static MethodCallExpression extractBareMethodCall(Statement statement) {
        if (!(statement instanceof ExpressionStatement)) {
            return null;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        if (!(expressionStatement.getExpression() instanceof MethodCallExpression)) {
            return null;
        }
        MethodCallExpression methodCall = (MethodCallExpression)expressionStatement.getExpression();
        if (!AstUtils.targetIsThis(methodCall)) {
            return null;
        }
        return methodCall;
    }

    @Nullable
    public static String extractConstantMethodName(MethodCallExpression methodCall) {
        if (!(methodCall.getMethod() instanceof ConstantExpression)) {
            return null;
        }
        return methodCall.getMethod().getText();
    }

    @Nullable
    public static ScriptBlock detectScriptBlock(Statement statement) {
        MethodCallExpression methodCall = AstUtils.extractBareMethodCall(statement);
        if (methodCall == null) {
            return null;
        }
        String methodName = AstUtils.extractConstantMethodName(methodCall);
        if (methodName == null) {
            return null;
        }
        ClosureExpression closureExpression = AstUtils.getSingleClosureArg((MethodCall)methodCall);
        return closureExpression == null ? null : new ScriptBlock(methodName, closureExpression);
    }

    public static Pair<ClassExpression, ClosureExpression> getClassAndClosureArgs(MethodCall methodCall) {
        if (!(methodCall.getArguments() instanceof ArgumentListExpression)) {
            return null;
        }
        ArgumentListExpression args = (ArgumentListExpression)methodCall.getArguments();
        if (args.getExpressions().size() == 2 && args.getExpression(0) instanceof ClassExpression && args.getExpression(1) instanceof ClosureExpression) {
            return Pair.of((Object)((ClassExpression)args.getExpression(0)), (Object)((ClosureExpression)args.getExpression(1)));
        }
        return null;
    }

    public static ClassExpression getClassArg(MethodCall methodCall) {
        if (!(methodCall.getArguments() instanceof ArgumentListExpression)) {
            return null;
        }
        ArgumentListExpression args = (ArgumentListExpression)methodCall.getArguments();
        if (args.getExpressions().size() == 1 && args.getExpression(0) instanceof ClassExpression) {
            return (ClassExpression)args.getExpression(0);
        }
        return null;
    }

    public static ClosureExpression getSingleClosureArg(MethodCall methodCall) {
        if (!(methodCall.getArguments() instanceof ArgumentListExpression)) {
            return null;
        }
        ArgumentListExpression args = (ArgumentListExpression)methodCall.getArguments();
        if (args.getExpressions().size() == 1 && args.getExpression(0) instanceof ClosureExpression) {
            return (ClosureExpression)args.getExpression(0);
        }
        return null;
    }

    @Nullable
    public static ScriptBlock detectScriptBlock(Statement statement, Predicate<? super ScriptBlock> predicate) {
        ScriptBlock scriptBlock = AstUtils.detectScriptBlock(statement);
        if (scriptBlock != null && predicate.apply((Object)scriptBlock)) {
            return scriptBlock;
        }
        return null;
    }

    @Nullable
    public static ScriptBlock detectScriptBlock(Statement statement, final Collection<String> names) {
        return AstUtils.detectScriptBlock(statement, (Predicate<? super ScriptBlock>)new Predicate<ScriptBlock>(){

            public boolean apply(ScriptBlock input) {
                return names.contains(input.getName());
            }
        });
    }

    public static boolean isString(ConstantExpression constantExpression) {
        return constantExpression.getType().getName().equals(String.class.getName());
    }

    @Nullable
    public static ConstantExpression hasSingleConstantStringArg(MethodCallExpression call) {
        ConstantExpression constantArgumentExpression;
        Expression argumentExpression;
        ArgumentListExpression argumentList = (ArgumentListExpression)call.getArguments();
        if (argumentList.getExpressions().size() == 1 && (argumentExpression = (Expression)argumentList.getExpressions().get(0)) instanceof ConstantExpression && AstUtils.isString(constantArgumentExpression = (ConstantExpression)argumentExpression)) {
            return constantArgumentExpression;
        }
        return null;
    }

    public static Iterable<? extends Statement> unpack(Statement statement) {
        if (statement instanceof BlockStatement) {
            return ((BlockStatement)statement).getStatements();
        }
        return Collections.singleton(statement);
    }

    public static MethodNode getGeneratedClosureImplMethod(ClassNode classNode) {
        if (!classNode.implementsInterface(ClassHelper.GENERATED_CLOSURE_Type)) {
            throw new IllegalArgumentException("expecting generated closure class node");
        }
        List doCallMethods = classNode.getDeclaredMethods("doCall");
        return (MethodNode)doCallMethods.get(0);
    }

    public static boolean mayHaveAnEffect(Statement statement) {
        if (statement instanceof ReturnStatement) {
            ReturnStatement returnStatement = (ReturnStatement)statement;
            if (returnStatement.getExpression() instanceof ConstantExpression) {
                return false;
            }
        } else if (statement instanceof ExpressionStatement) {
            DeclarationExpression declarationExpression;
            ExpressionStatement expressionStatement = (ExpressionStatement)statement;
            if (expressionStatement.getExpression() instanceof ConstantExpression) {
                return false;
            }
            if (expressionStatement.getExpression() instanceof DeclarationExpression && ((declarationExpression = (DeclarationExpression)expressionStatement.getExpression()).getRightExpression() instanceof EmptyExpression || declarationExpression.getRightExpression() instanceof ConstantExpression)) {
                return false;
            }
        }
        return true;
    }
}

