/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import org.gradle.api.internal.tasks.compile.daemon.CompileResult;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonProtocol;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerDaemonServer
implements CompilerDaemonProtocol {
    private static final Logger LOGGER = Logging.getLogger(CompilerDaemonServer.class);

    @Override
    public <T extends CompileSpec> CompileResult execute(Compiler<T> compiler, T spec) {
        try {
            LOGGER.info("Executing {} in compiler daemon.", compiler);
            WorkResult result = compiler.execute(spec);
            LOGGER.info("Successfully executed {} in compiler daemon.", compiler);
            return new CompileResult(result.getDidWork(), null);
        }
        catch (Throwable t) {
            LOGGER.info("Exception executing {} in compiler daemon: {}.", compiler, (Object)t);
            return new CompileResult(true, t);
        }
    }
}

