/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.binding;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import org.gradle.api.Named;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.Methods;
import org.gradle.model.Managed;
import org.gradle.model.Unmanaged;
import org.gradle.model.internal.manage.binding.AbstractStructMethodBinding;
import org.gradle.model.internal.manage.binding.BridgeMethodBinding;
import org.gradle.model.internal.manage.binding.DefaultStructBindings;
import org.gradle.model.internal.manage.binding.DelegateMethodBinding;
import org.gradle.model.internal.manage.binding.DirectMethodBinding;
import org.gradle.model.internal.manage.binding.InvalidManagedTypeException;
import org.gradle.model.internal.manage.binding.ManagedProperty;
import org.gradle.model.internal.manage.binding.ManagedPropertyMethodBinding;
import org.gradle.model.internal.manage.binding.StructBindingExtractionContext;
import org.gradle.model.internal.manage.binding.StructBindingValidationProblemCollector;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.binding.StructMethodBinding;
import org.gradle.model.internal.manage.binding.StructMethodImplementationBinding;
import org.gradle.model.internal.manage.schema.CollectionSchema;
import org.gradle.model.internal.manage.schema.ManagedImplSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.RuleSourceSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.ScalarValueSchema;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaUtils;
import org.gradle.model.internal.manage.schema.extract.PropertyAccessorType;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStructBindingsStore
implements StructBindingsStore {
    private final LoadingCache<CacheKey, StructBindings<?>> bindings = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<CacheKey, StructBindings<?>>(){

        public StructBindings<?> load(CacheKey key) throws Exception {
            return DefaultStructBindingsStore.this.extract(key.publicType, key.viewTypes, key.delegateType);
        }
    });
    private final ModelSchemaStore schemaStore;

    public DefaultStructBindingsStore(ModelSchemaStore schemaStore) {
        this.schemaStore = schemaStore;
    }

    @Override
    public <T> StructBindings<T> getBindings(ModelType<T> publicType) {
        return this.getBindings(publicType, Collections.emptySet(), null);
    }

    @Override
    public <T> StructBindings<T> getBindings(ModelType<T> publicType, Iterable<? extends ModelType<?>> internalViewTypes, ModelType<?> delegateType) {
        try {
            return (StructBindings)Cast.uncheckedCast((Object)this.bindings.get((Object)new CacheKey(publicType, internalViewTypes, delegateType)));
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (UncheckedExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
    }

    <T, D> StructBindings<T> extract(ModelType<T> publicType, Iterable<? extends ModelType<?>> internalViewTypes, ModelType<D> delegateType) {
        if (delegateType != null && Modifier.isAbstract(delegateType.getConcreteClass().getModifiers())) {
            throw new InvalidManagedTypeException(String.format("Type '%s' is not a valid managed type: delegate type must be null or a non-abstract type instead of '%s'.", publicType.getDisplayName(), delegateType.getDisplayName()));
        }
        Set<ModelType<?>> implementedViews = DefaultStructBindingsStore.collectImplementedViews(publicType, internalViewTypes, delegateType);
        StructSchema<T> publicSchema = this.getStructSchema(publicType);
        Iterable<StructSchema<T>> declaredViewSchemas = this.getStructSchemas(Iterables.concat(Collections.singleton(publicType), internalViewTypes));
        Iterable<StructSchema<?>> implementedSchemas = this.getStructSchemas(implementedViews);
        StructSchema<D> delegateSchema = delegateType == null ? null : this.getStructSchema(delegateType);
        StructBindingExtractionContext<T> extractionContext = new StructBindingExtractionContext<T>(publicSchema, implementedSchemas, delegateSchema);
        if (!(publicSchema instanceof RuleSourceSchema)) {
            DefaultStructBindingsStore.validateTypeHierarchy(extractionContext, publicType);
            for (ModelType<?> internalViewType : internalViewTypes) {
                DefaultStructBindingsStore.validateTypeHierarchy(extractionContext, internalViewType);
            }
        }
        TreeMap propertyBindings = Maps.newTreeMap();
        Set<StructMethodBinding> methodBindings = DefaultStructBindingsStore.collectMethodBindings(extractionContext, propertyBindings);
        ImmutableSortedMap<String, ManagedProperty<?>> managedProperties = this.collectManagedProperties(extractionContext, propertyBindings);
        if (extractionContext.problems.hasProblems()) {
            throw new InvalidManagedTypeException(extractionContext.problems.format());
        }
        return new DefaultStructBindings<T>(publicSchema, declaredViewSchemas, implementedSchemas, delegateSchema, (Map<String, ManagedProperty<?>>)managedProperties, (Iterable<StructMethodBinding>)methodBindings);
    }

    private static <T> void validateTypeHierarchy(final StructBindingValidationProblemCollector problems, ModelType<T> type) {
        ModelSchemaUtils.walkTypeHierarchy(type.getConcreteClass(), new ModelSchemaUtils.TypeVisitor<T>(){

            @Override
            public void visitType(Class<? super T> type) {
                if (type.isAnnotationPresent(Managed.class)) {
                    DefaultStructBindingsStore.validateManagedType(problems, type);
                }
                DefaultStructBindingsStore.validateType(problems, type);
            }
        });
    }

    private static void validateManagedType(StructBindingValidationProblemCollector problems, Class<?> typeClass) {
        if (!typeClass.isInterface() && !Modifier.isAbstract(typeClass.getModifiers())) {
            problems.add("Must be defined as an interface or an abstract class.");
        }
        if (typeClass.getTypeParameters().length > 0) {
            problems.add("Cannot be a parameterized type.");
        }
    }

    private static void validateType(StructBindingValidationProblemCollector problems, Class<?> typeClass) {
        Constructor<?> customConstructor = DefaultStructBindingsStore.findCustomConstructor(typeClass);
        if (customConstructor != null) {
            problems.add(customConstructor, "Custom constructors are not supported.");
        }
        DefaultStructBindingsStore.ensureNoInstanceScopedFields(problems, typeClass);
        Method[] methods = typeClass.getDeclaredMethods();
        Arrays.sort(methods, Ordering.usingToString());
        DefaultStructBindingsStore.ensureNoProtectedOrPrivateMethods(problems, methods);
        DefaultStructBindingsStore.ensureNoDefaultMethods(problems, typeClass, methods);
    }

    private static Constructor<?> findCustomConstructor(Class<?> typeClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = typeClass.getConstructors()) {
            if (constructor.getParameterTypes().length <= 0) continue;
            return constructor;
        }
        return null;
    }

    private static void ensureNoInstanceScopedFields(StructBindingValidationProblemCollector problems, Class<?> typeClass) {
        List<Field> declaredFields = Arrays.asList(typeClass.getDeclaredFields());
        for (Field field : declaredFields) {
            int fieldModifiers = field.getModifiers();
            if (field.isSynthetic() || Modifier.isStatic(fieldModifiers) && Modifier.isFinal(fieldModifiers)) continue;
            problems.add(field, "Fields must be static final.");
        }
    }

    private static void ensureNoProtectedOrPrivateMethods(StructBindingValidationProblemCollector problems, Method[] declaredMethods) {
        for (Method declaredMethod : declaredMethods) {
            int modifiers = declaredMethod.getModifiers();
            if (declaredMethod.isSynthetic() || Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            problems.add(declaredMethod, "Protected and private methods are not supported.");
        }
    }

    private static void ensureNoDefaultMethods(StructBindingValidationProblemCollector problems, Class<?> typeClass, Method[] declaredMethods) {
        if (!typeClass.isInterface()) {
            return;
        }
        for (Method declaredMethod : declaredMethods) {
            if (!DefaultStructBindingsStore.isDefaultInterfaceMethod(declaredMethod) || PropertyAccessorType.of(declaredMethod) != null) continue;
            problems.add(declaredMethod, "Default interface methods are only supported for getters and setters.");
        }
    }

    private static boolean isDefaultInterfaceMethod(Method method) {
        return (method.getModifiers() & 0x409) == 1;
    }

    private <T> ImmutableSortedMap<String, ManagedProperty<?>> collectManagedProperties(StructBindingExtractionContext<T> extractionContext, Map<String, Multimap<PropertyAccessorType, StructMethodBinding>> propertyBindings) {
        ImmutableSortedMap.Builder managedPropertiesBuilder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<String, Multimap<PropertyAccessorType, StructMethodBinding>> propertyEntry : propertyBindings.entrySet()) {
            Multimap<PropertyAccessorType, StructMethodBinding> accessorBindings;
            String propertyName = propertyEntry.getKey();
            if (!DefaultStructBindingsStore.isManagedProperty(extractionContext, propertyName, accessorBindings = propertyEntry.getValue())) continue;
            if (PropertyAccessorType.hasSetter(accessorBindings.keySet()) && !PropertyAccessorType.hasGetter(accessorBindings.keySet())) {
                extractionContext.add(propertyName, "it must both have an abstract getter and a setter");
                continue;
            }
            ModelType<?> propertyType = DefaultStructBindingsStore.determineManagedPropertyType(extractionContext, propertyName, accessorBindings);
            ModelSchema<?> propertySchema = this.schemaStore.getSchema(propertyType);
            managedPropertiesBuilder.put((Object)propertyName, DefaultStructBindingsStore.createManagedProperty(extractionContext, propertyName, propertySchema, accessorBindings));
        }
        return managedPropertiesBuilder.build();
    }

    private static boolean isManagedProperty(StructBindingExtractionContext<?> extractionContext, String propertyName, Multimap<PropertyAccessorType, StructMethodBinding> accessorBindings) {
        Boolean managed = null;
        for (Map.Entry accessorEntry : accessorBindings.asMap().entrySet()) {
            Collection bindings = (Collection)accessorEntry.getValue();
            boolean managedPropertyAccessor = DefaultStructBindingsStore.isManagedPropertyAccessor(extractionContext, propertyName, bindings);
            if (managed == null) {
                managed = managedPropertyAccessor;
                continue;
            }
            if (managed == managedPropertyAccessor) continue;
            extractionContext.add(propertyName, "it must have either only abstract accessor methods or only implemented accessor methods");
            managed = false;
            break;
        }
        assert (managed != null);
        return managed;
    }

    private static boolean isManagedPropertyAccessor(StructBindingExtractionContext<?> extractionContext, String propertyName, Collection<StructMethodBinding> bindings) {
        LinkedHashSet implMethods = Sets.newLinkedHashSet();
        for (StructMethodBinding binding : bindings) {
            if (!(binding instanceof StructMethodImplementationBinding)) continue;
            implMethods.add(((StructMethodImplementationBinding)binding).getImplementorMethod());
        }
        switch (implMethods.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        extractionContext.add(propertyName, String.format("it has multiple implementations for accessor method: %s", Joiner.on((String)", ").join((Iterable)implMethods)));
        return false;
    }

    private static ModelType<?> determineManagedPropertyType(StructBindingExtractionContext<?> extractionContext, String propertyName, Multimap<PropertyAccessorType, StructMethodBinding> accessorBindings) {
        Collection isGetter = accessorBindings.get((Object)PropertyAccessorType.IS_GETTER);
        for (StructMethodBinding isGetterBinding : isGetter) {
            if (((ManagedPropertyMethodBinding)isGetterBinding).getDeclaredPropertyType().equals(ModelType.of(Boolean.TYPE))) continue;
            WeaklyTypeReferencingMethod<?, ?> isGetterMethod = isGetterBinding.getViewMethod();
            extractionContext.add(isGetterMethod, String.format("it should either return 'boolean', or its name should be '%s()'", "get" + isGetterMethod.getName().substring(2)));
        }
        LinkedHashSet potentialPropertyTypes = Sets.newLinkedHashSet();
        for (StructMethodBinding binding : accessorBindings.values()) {
            if (binding.getAccessorType() == PropertyAccessorType.SETTER) continue;
            ManagedPropertyMethodBinding propertyBinding = (ManagedPropertyMethodBinding)binding;
            potentialPropertyTypes.add(propertyBinding.getDeclaredPropertyType());
        }
        Collection<ModelType<?>> convergingPropertyTypes = DefaultStructBindingsStore.findConvergingTypes(potentialPropertyTypes);
        if (convergingPropertyTypes.size() != 1) {
            extractionContext.add(propertyName, String.format("it must have a consistent type, but it's defined as %s", Joiner.on((String)", ").join(ModelTypes.getDisplayNames(convergingPropertyTypes))));
            return convergingPropertyTypes.iterator().next();
        }
        ModelType propertyType = (ModelType)Iterables.getOnlyElement(convergingPropertyTypes);
        for (StructMethodBinding setterBinding : accessorBindings.get((Object)PropertyAccessorType.SETTER)) {
            ManagedPropertyMethodBinding propertySetterBinding = (ManagedPropertyMethodBinding)setterBinding;
            ModelType<?> declaredSetterType = propertySetterBinding.getDeclaredPropertyType();
            if (declaredSetterType.equals(propertyType)) continue;
            extractionContext.add(setterBinding.getViewMethod(), String.format("it should take parameter with type '%s'", propertyType.getDisplayName()));
        }
        return propertyType;
    }

    private static <T, D> Set<ModelType<?>> collectImplementedViews(ModelType<T> publicType, Iterable<? extends ModelType<?>> internalViewTypes, ModelType<D> delegateType) {
        final LinkedHashSet viewsToImplement = Sets.newLinkedHashSet();
        viewsToImplement.add(publicType);
        Iterables.addAll((Collection)viewsToImplement, internalViewTypes);
        if (delegateType != null) {
            ModelSchemaUtils.walkTypeHierarchy(delegateType.getConcreteClass(), new ModelSchemaUtils.TypeVisitor<D>(){

                @Override
                public void visitType(Class<? super D> type) {
                    if (type.isInterface()) {
                        viewsToImplement.add(ModelType.of(type));
                    }
                }
            });
        }
        return ModelTypes.collectHierarchy(viewsToImplement);
    }

    private static <T> Set<StructMethodBinding> collectMethodBindings(StructBindingExtractionContext<T> extractionContext, Map<String, Multimap<PropertyAccessorType, StructMethodBinding>> propertyBindings) {
        Collection<WeaklyTypeReferencingMethod<?, ?>> implementedMethods = DefaultStructBindingsStore.collectImplementedMethods(extractionContext.getImplementedSchemas());
        Map<Equivalence.Wrapper<Method>, WeaklyTypeReferencingMethod<?, ?>> publicViewImplMethods = DefaultStructBindingsStore.collectPublicViewImplMethods(extractionContext.getPublicSchema());
        Map<Equivalence.Wrapper<Method>, WeaklyTypeReferencingMethod<?, ?>> delegateMethods = DefaultStructBindingsStore.collectDelegateMethods(extractionContext.getDelegateSchema());
        ImmutableSet.Builder methodBindingsBuilder = ImmutableSet.builder();
        for (WeaklyTypeReferencingMethod<?, ?> weakImplementedMethod : implementedMethods) {
            AbstractStructMethodBinding binding;
            String propertyName;
            Method implementedMethod = weakImplementedMethod.getMethod();
            PropertyAccessorType accessorType = PropertyAccessorType.of(implementedMethod);
            Equivalence.Wrapper methodKey = Methods.SIGNATURE_EQUIVALENCE.wrap((Object)implementedMethod);
            WeaklyTypeReferencingMethod<?, ?> weakDelegateImplMethod = delegateMethods.get(methodKey);
            WeaklyTypeReferencingMethod<?, ?> weakPublicImplMethod = publicViewImplMethods.get(methodKey);
            if (weakDelegateImplMethod != null && weakPublicImplMethod != null) {
                extractionContext.add(weakImplementedMethod, String.format("it is both implemented by the view '%s' and the delegate type '%s'", extractionContext.getPublicSchema().getType().getDisplayName(), extractionContext.getDelegateSchema().getType().getDisplayName()));
            }
            String string = propertyName = accessorType == null ? null : accessorType.propertyNameFor(implementedMethod);
            if (!Modifier.isAbstract(implementedMethod.getModifiers())) {
                binding = new DirectMethodBinding(weakImplementedMethod, accessorType);
            } else if (weakPublicImplMethod != null) {
                binding = new BridgeMethodBinding(weakImplementedMethod, weakPublicImplMethod, accessorType);
            } else if (weakDelegateImplMethod != null) {
                binding = new DelegateMethodBinding(weakImplementedMethod, weakDelegateImplMethod, accessorType);
            } else if (propertyName != null) {
                binding = new ManagedPropertyMethodBinding(weakImplementedMethod, propertyName, accessorType);
            } else {
                DefaultStructBindingsStore.handleNoMethodImplementation(extractionContext, weakImplementedMethod);
                continue;
            }
            methodBindingsBuilder.add((Object)binding);
            if (accessorType == null) continue;
            ArrayListMultimap accessorBindings = propertyBindings.get(propertyName);
            if (accessorBindings == null) {
                accessorBindings = ArrayListMultimap.create();
                propertyBindings.put(propertyName, (Multimap<PropertyAccessorType, StructMethodBinding>)accessorBindings);
            }
            accessorBindings.put((Object)accessorType, (Object)binding);
        }
        return methodBindingsBuilder.build();
    }

    private static void handleNoMethodImplementation(StructBindingValidationProblemCollector problems, WeaklyTypeReferencingMethod<?, ?> method) {
        block8: {
            block7: {
                String methodName = method.getName();
                PropertyAccessorType accessorType = PropertyAccessorType.fromName(methodName);
                if (accessorType == null) break block7;
                switch (accessorType) {
                    case GET_GETTER: 
                    case IS_GETTER: {
                        if (!PropertyAccessorType.takesNoParameter(method.getMethod())) {
                            problems.add(method, "property accessor", "getter method must not take parameters");
                        }
                        break block8;
                    }
                    case SETTER: {
                        if (!PropertyAccessorType.hasVoidReturnType(method.getMethod())) {
                            problems.add(method, "property accessor", "setter method must have void return type");
                        }
                        if (!PropertyAccessorType.takesSingleParameter(method.getMethod())) {
                            problems.add(method, "property accessor", "setter method must take exactly one parameter");
                        }
                        break block8;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            problems.add(method, "managed type", "it must have an implementation");
        }
    }

    private static Map<Equivalence.Wrapper<Method>, WeaklyTypeReferencingMethod<?, ?>> collectDelegateMethods(StructSchema<?> delegateSchema) {
        return delegateSchema == null ? Collections.emptyMap() : DefaultStructBindingsStore.indexBySignature(delegateSchema.getAllMethods());
    }

    private static <T> Map<Equivalence.Wrapper<Method>, WeaklyTypeReferencingMethod<?, ?>> collectPublicViewImplMethods(StructSchema<T> publicSchema) {
        return DefaultStructBindingsStore.indexBySignature(Sets.filter(publicSchema.getAllMethods(), (Predicate)new Predicate<WeaklyTypeReferencingMethod<?, ?>>(){

            public boolean apply(WeaklyTypeReferencingMethod<?, ?> weakMethod) {
                return !Modifier.isAbstract(weakMethod.getModifiers());
            }
        }));
    }

    private static ImmutableMap<Equivalence.Wrapper<Method>, WeaklyTypeReferencingMethod<?, ?>> indexBySignature(Iterable<WeaklyTypeReferencingMethod<?, ?>> methods) {
        return Maps.uniqueIndex(methods, (Function)new Function<WeaklyTypeReferencingMethod<?, ?>, Equivalence.Wrapper<Method>>(){

            public Equivalence.Wrapper<Method> apply(WeaklyTypeReferencingMethod<?, ?> weakMethod) {
                return Methods.SIGNATURE_EQUIVALENCE.wrap((Object)weakMethod.getMethod());
            }
        });
    }

    private static Collection<WeaklyTypeReferencingMethod<?, ?>> collectImplementedMethods(Iterable<StructSchema<?>> implementedSchemas) {
        LinkedHashMap implementedMethodsBuilder = Maps.newLinkedHashMap();
        for (StructSchema<?> implementedSchema : implementedSchemas) {
            for (WeaklyTypeReferencingMethod<?, ?> viewMethod : implementedSchema.getAllMethods()) {
                implementedMethodsBuilder.put(Methods.DESCRIPTOR_EQUIVALENCE.wrap((Object)viewMethod.getMethod()), viewMethod);
            }
        }
        return implementedMethodsBuilder.values();
    }

    private static <T> ManagedProperty<T> createManagedProperty(StructBindingExtractionContext<?> extractionContext, String propertyName, ModelSchema<T> propertySchema, Multimap<PropertyAccessorType, StructMethodBinding> accessors) {
        boolean writable = accessors.containsKey((Object)PropertyAccessorType.SETTER);
        boolean declaredAsUnmanaged = DefaultStructBindingsStore.isDeclaredAsHavingUnmanagedType(accessors.get((Object)PropertyAccessorType.GET_GETTER)) || DefaultStructBindingsStore.isDeclaredAsHavingUnmanagedType(accessors.get((Object)PropertyAccessorType.IS_GETTER));
        boolean internal = !extractionContext.getPublicSchema().hasProperty(propertyName);
        DefaultStructBindingsStore.validateManagedProperty(extractionContext, propertyName, propertySchema, writable, declaredAsUnmanaged);
        return new ManagedProperty<T>(propertyName, propertySchema.getType(), writable, declaredAsUnmanaged, internal);
    }

    private static void validateManagedProperty(StructBindingExtractionContext<?> extractionContext, String propertyName, ModelSchema<?> propertySchema, boolean writable, boolean isDeclaredAsHavingUnmanagedType) {
        if (propertyName.equals("name") && Named.class.isAssignableFrom(extractionContext.getPublicSchema().getType().getRawClass())) {
            if (writable) {
                extractionContext.add(propertyName, String.format("it must not have a setter, because the type implements '%s'", Named.class.getName()));
            }
            return;
        }
        boolean isAllowedPropertyTypeOfManagedType = propertySchema instanceof ManagedImplSchema || propertySchema instanceof ScalarValueSchema;
        ModelType<?> propertyType = propertySchema.getType();
        if (isAllowedPropertyTypeOfManagedType && isDeclaredAsHavingUnmanagedType) {
            extractionContext.add(propertyName, String.format("it is marked as @Unmanaged, but is of @Managed type '%s'; please remove the @Managed annotation", propertyType.getDisplayName()));
        }
        if (!writable && isDeclaredAsHavingUnmanagedType) {
            extractionContext.add(propertyName, "it must not be read only, because it is marked as @Unmanaged");
        }
        if (!(extractionContext.getPublicSchema() instanceof RuleSourceSchema) && propertySchema instanceof CollectionSchema && !(propertySchema instanceof ScalarCollectionSchema) && writable) {
            extractionContext.add(propertyName, String.format("it cannot have a setter (%s properties must be read only)", propertyType.getRawClass().getSimpleName()));
        }
    }

    private static boolean isDeclaredAsHavingUnmanagedType(Collection<StructMethodBinding> accessorBindings) {
        for (StructMethodBinding accessorBinding : accessorBindings) {
            if (!accessorBinding.getViewMethod().getMethod().isAnnotationPresent(Unmanaged.class)) continue;
            return true;
        }
        return false;
    }

    private <T> Iterable<StructSchema<? extends T>> getStructSchemas(Iterable<? extends ModelType<? extends T>> types) {
        return Iterables.transform(types, (Function)new Function<ModelType<? extends T>, StructSchema<? extends T>>(){

            public StructSchema<? extends T> apply(ModelType<? extends T> type) {
                return DefaultStructBindingsStore.this.getStructSchema(type);
            }
        });
    }

    private <T> StructSchema<T> getStructSchema(ModelType<T> type) {
        ModelSchema<T> schema = this.schemaStore.getSchema(type);
        if (!(schema instanceof StructSchema)) {
            throw new IllegalArgumentException(String.format("Type '%s' is not a struct.", type.getDisplayName()));
        }
        return (StructSchema)Cast.uncheckedCast(schema);
    }

    static Collection<ModelType<?>> findConvergingTypes(Collection<ModelType<?>> allTypes) {
        if (allTypes.size() == 0) {
            throw new IllegalArgumentException("No types given");
        }
        if (allTypes.size() == 1) {
            return allTypes;
        }
        LinkedHashSet typesToCheck = Sets.newLinkedHashSet(allTypes);
        LinkedHashSet convergingTypes = Sets.newLinkedHashSet(allTypes);
        while (!typesToCheck.isEmpty()) {
            Iterator iTypeToCheck = typesToCheck.iterator();
            ModelType typeToCheck = (ModelType)iTypeToCheck.next();
            iTypeToCheck.remove();
            Iterator iRemainingType = convergingTypes.iterator();
            while (iRemainingType.hasNext()) {
                ModelType remainingType = (ModelType)iRemainingType.next();
                if (remainingType.equals(typeToCheck) || !remainingType.isAssignableFrom(typeToCheck)) continue;
                iRemainingType.remove();
                typesToCheck.remove(remainingType);
            }
        }
        return convergingTypes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheKey {
        private final ModelType<?> publicType;
        private final Set<ModelType<?>> viewTypes;
        private final ModelType<?> delegateType;

        public CacheKey(ModelType<?> publicType, Iterable<? extends ModelType<?>> viewTypes, ModelType<?> delegateType) {
            this.publicType = publicType;
            this.viewTypes = ImmutableSet.copyOf(viewTypes);
            this.delegateType = delegateType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equal(this.publicType, cacheKey.publicType) && Objects.equal(this.viewTypes, cacheKey.viewTypes) && Objects.equal(this.delegateType, cacheKey.delegateType);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.publicType, this.viewTypes, this.delegateType});
        }
    }
}

