/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.gc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GarbageCollectorMonitoringStrategy {
    ORACLE_PARALLEL_CMS("PS Old Gen", "PS MarkSweep", 1.2, 80),
    ORACLE_6_CMS("CMS Old Gen", "ConcurrentMarkSweep", 1.2, 80),
    ORACLE_SERIAL("Tenured Gen", "MarkSweepCompact", 1.2, 80),
    ORACLE_G1("G1 Old Gen", "G1 Old Generation", 0.4, 75),
    IBM_ALL("Java heap", "MarkSweepCompact", 0.8, 70),
    UNKNOWN(null, null, -1.0, -1);

    private final String tenuredPoolName;
    private final String garbageCollectorName;
    private final double gcRateThreshold;
    private final int tenuredUsageThreshold;

    private GarbageCollectorMonitoringStrategy(String tenuredPoolName, String garbageCollectorName, double gcRateThreshold, int tenuredUsageThreshold) {
        this.tenuredPoolName = tenuredPoolName;
        this.garbageCollectorName = garbageCollectorName;
        this.gcRateThreshold = gcRateThreshold;
        this.tenuredUsageThreshold = tenuredUsageThreshold;
    }

    public String getTenuredPoolName() {
        return this.tenuredPoolName;
    }

    public String getGarbageCollectorName() {
        return this.garbageCollectorName;
    }

    public double getGcRateThreshold() {
        return this.gcRateThreshold;
    }

    public int getTenuredUsageThreshold() {
        return this.tenuredUsageThreshold;
    }
}

