/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.logging.LogLevel;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonUsageSuggestingBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters> {
    public static final String PLEASE_USE_DAEMON_MESSAGE_PREFIX = "This build could be faster, please consider using the Gradle Daemon: ";
    private final BuildActionExecuter<BuildActionParameters> executer;
    private final StyledTextOutputFactory textOutputFactory;
    private final DocumentationRegistry documentationRegistry;
    private final OperatingSystem operatingSystem;

    public DaemonUsageSuggestingBuildActionExecuter(BuildActionExecuter<BuildActionParameters> executer, StyledTextOutputFactory textOutputFactory, DocumentationRegistry documentationRegistry) {
        this(executer, textOutputFactory, documentationRegistry, OperatingSystem.current());
    }

    DaemonUsageSuggestingBuildActionExecuter(BuildActionExecuter<BuildActionParameters> executer, StyledTextOutputFactory textOutputFactory, DocumentationRegistry documentationRegistry, OperatingSystem operatingSystem) {
        this.executer = executer;
        this.textOutputFactory = textOutputFactory;
        this.documentationRegistry = documentationRegistry;
        this.operatingSystem = operatingSystem;
    }

    @Override
    public Object execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        Object result = this.executer.execute(action, requestContext, actionParameters, contextServices);
        this.possiblySuggestUsingDaemon(actionParameters);
        return result;
    }

    private void possiblySuggestUsingDaemon(BuildActionParameters actionParameters) {
        if (actionParameters.getDaemonUsage().isExplicitlySet() || this.operatingSystem.isWindows() || this.isCIEnvironment(actionParameters)) {
            return;
        }
        StyledTextOutput styledTextOutput = this.textOutputFactory.create(DaemonUsageSuggestingBuildActionExecuter.class, LogLevel.LIFECYCLE);
        styledTextOutput.println();
        styledTextOutput.println((Object)(PLEASE_USE_DAEMON_MESSAGE_PREFIX + this.documentationRegistry.getDocumentationFor("gradle_daemon")));
    }

    private boolean isCIEnvironment(BuildActionParameters actionParameters) {
        return actionParameters.getEnvVariables().get("CI") != null && !actionParameters.getEnvVariables().get("CI").equals("false");
    }
}

