/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.api.Nullable;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.internal.plugins.ExtraPropertiesDynamicObjectAdapter;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.CompositeDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.GetPropertyResult;
import org.gradle.internal.metaobject.InvokeMethodResult;
import org.gradle.internal.metaobject.MixInClosurePropertiesAsMethodsDynamicObject;
import org.gradle.internal.metaobject.SetPropertyResult;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleDynamicObject
extends MixInClosurePropertiesAsMethodsDynamicObject
implements HasConvention {
    private final AbstractDynamicObject dynamicDelegate;
    private DynamicObject parent;
    private Convention convention;
    private DynamicObject beforeConvention;
    private DynamicObject afterConvention;
    private DynamicObject extraPropertiesDynamicObject;

    public ExtensibleDynamicObject(Object delegate, Class<?> publicType, Instantiator instantiator) {
        this(delegate, (AbstractDynamicObject)ExtensibleDynamicObject.createDynamicObject(delegate, publicType), new DefaultConvention(instantiator));
    }

    public ExtensibleDynamicObject(Object delegate, AbstractDynamicObject dynamicDelegate, Instantiator instantiator) {
        this(delegate, dynamicDelegate, new DefaultConvention(instantiator));
    }

    public ExtensibleDynamicObject(Object delegate, AbstractDynamicObject dynamicDelegate, Convention convention) {
        this.dynamicDelegate = dynamicDelegate;
        this.convention = convention;
        this.extraPropertiesDynamicObject = new ExtraPropertiesDynamicObjectAdapter(delegate.getClass(), convention.getExtraProperties());
        this.updateDelegates();
    }

    private static BeanDynamicObject createDynamicObject(Object delegate, Class<?> publicType) {
        return new BeanDynamicObject(delegate, publicType);
    }

    private void updateDelegates() {
        DynamicObject[] delegates = new DynamicObject[6];
        delegates[0] = this.dynamicDelegate;
        delegates[1] = this.extraPropertiesDynamicObject;
        int idx = 2;
        if (this.beforeConvention != null) {
            delegates[idx++] = this.beforeConvention;
        }
        if (this.convention != null) {
            delegates[idx++] = this.convention.getExtensionsAsDynamicObject();
        }
        if (this.afterConvention != null) {
            delegates[idx++] = this.afterConvention;
        }
        boolean addedParent = false;
        if (this.parent != null) {
            addedParent = true;
            delegates[idx++] = this.parent;
        }
        DynamicObject[] objects = new DynamicObject[idx];
        System.arraycopy(delegates, 0, objects, 0, idx);
        this.setObjects(objects);
        if (addedParent) {
            --idx;
        }
        objects = new DynamicObject[idx];
        System.arraycopy(delegates, 0, objects, 0, idx);
        this.setObjectsForUpdate(objects);
    }

    @Override
    public String getDisplayName() {
        return this.dynamicDelegate.getDisplayName();
    }

    @Override
    @Nullable
    public Class<?> getPublicType() {
        return this.dynamicDelegate.getPublicType();
    }

    @Override
    public boolean hasUsefulDisplayName() {
        return this.dynamicDelegate.hasUsefulDisplayName();
    }

    public ExtraPropertiesExtension getDynamicProperties() {
        return this.convention.getExtraProperties();
    }

    public void addProperties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.getDynamicProperties().set(entry.getKey(), entry.getValue());
        }
    }

    public DynamicObject getParent() {
        return this.parent;
    }

    public void setParent(DynamicObject parent) {
        this.parent = parent;
        this.updateDelegates();
    }

    @Override
    public Convention getConvention() {
        return this.convention;
    }

    public void addObject(DynamicObject object, Location location) {
        switch (location) {
            case BeforeConvention: {
                this.beforeConvention = object;
                break;
            }
            case AfterConvention: {
                this.afterConvention = object;
            }
        }
        this.updateDelegates();
    }

    public DynamicObject getInheritable() {
        return new InheritedDynamicObject();
    }

    private DynamicObject snapshotInheritable() {
        final ArrayList<DynamicObject> delegates = new ArrayList<DynamicObject>(4);
        if (this.parent != null) {
            delegates.add(this.parent);
        }
        delegates.add(this.convention.getExtensionsAsDynamicObject());
        delegates.add(this.extraPropertiesDynamicObject);
        if (this.beforeConvention != null) {
            delegates.add(this.beforeConvention);
        }
        return new CompositeDynamicObject(){
            {
                this.setObjects(delegates.toArray(new DynamicObject[0]));
            }

            public String getDisplayName() {
                return ExtensibleDynamicObject.this.dynamicDelegate.getDisplayName();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InheritedDynamicObject
    implements DynamicObject {
        private InheritedDynamicObject() {
        }

        @Override
        public void setProperty(String name, Object value) {
            throw new MissingPropertyException(String.format("Could not find property '%s' inherited from %s.", name, ExtensibleDynamicObject.this.dynamicDelegate.getDisplayName()));
        }

        @Override
        public MissingPropertyException getMissingProperty(String name) {
            return ExtensibleDynamicObject.this.dynamicDelegate.getMissingProperty(name);
        }

        @Override
        public MissingPropertyException setMissingProperty(String name) {
            return ExtensibleDynamicObject.this.dynamicDelegate.setMissingProperty(name);
        }

        @Override
        public MissingMethodException methodMissingException(String name, Object ... params) {
            return ExtensibleDynamicObject.this.dynamicDelegate.methodMissingException(name, params);
        }

        @Override
        public void setProperty(String name, Object value, SetPropertyResult result) {
            this.setProperty(name, value);
        }

        @Override
        public boolean hasProperty(String name) {
            return ExtensibleDynamicObject.this.snapshotInheritable().hasProperty(name);
        }

        @Override
        public Object getProperty(String name) {
            return ExtensibleDynamicObject.this.snapshotInheritable().getProperty(name);
        }

        @Override
        public void getProperty(String name, GetPropertyResult result) {
            ExtensibleDynamicObject.this.snapshotInheritable().getProperty(name, result);
        }

        @Override
        public Map<String, ?> getProperties() {
            return ExtensibleDynamicObject.this.snapshotInheritable().getProperties();
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return ExtensibleDynamicObject.this.snapshotInheritable().hasMethod(name, arguments);
        }

        @Override
        public void invokeMethod(String name, InvokeMethodResult result, Object ... arguments) {
            ExtensibleDynamicObject.this.snapshotInheritable().invokeMethod(name, result, arguments);
        }

        @Override
        public Object invokeMethod(String name, Object ... arguments) {
            return ExtensibleDynamicObject.this.snapshotInheritable().invokeMethod(name, arguments);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        BeforeConvention,
        AfterConvention;

    }
}

