/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.Closeable;
import java.io.IOException;
import org.gradle.api.internal.changedetection.state.CachingTreeVisitor;
import org.gradle.api.internal.changedetection.state.OverlappingDirectoriesDetector;
import org.gradle.api.internal.changedetection.state.TreeVisitorCacheExpirationStrategy;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.Factory;

public class CachingTreeVisitorCleaner
implements Closeable {
    private final Gradle gradle;
    private final TreeVisitorCacheExpirationStrategy cacheExpirationStrategy;

    public CachingTreeVisitorCleaner(CachingTreeVisitor cachingTreeVisitor, Gradle gradle) {
        this.gradle = gradle;
        this.cacheExpirationStrategy = new TreeVisitorCacheExpirationStrategy(cachingTreeVisitor, new Factory<OverlappingDirectoriesDetector>(){

            public OverlappingDirectoriesDetector create() {
                return new OverlappingDirectoriesDetector();
            }
        });
        gradle.getTaskGraph().addTaskExecutionGraphListener(this.cacheExpirationStrategy);
        gradle.getTaskGraph().addTaskExecutionListener(this.cacheExpirationStrategy);
        gradle.addBuildListener(this.cacheExpirationStrategy);
    }

    public void close() throws IOException {
        this.gradle.removeListener(this.cacheExpirationStrategy);
        this.gradle.getTaskGraph().removeTaskExecutionGraphListener(this.cacheExpirationStrategy);
        this.gradle.getTaskGraph().removeTaskExecutionListener(this.cacheExpirationStrategy);
    }
}

