/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.AntFileCollectionBuilder;
import org.gradle.api.internal.file.AntFileCollectionMatchingTaskBuilder;
import org.gradle.api.internal.file.AntFileSetBuilder;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileBackedDirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.util.CollectionUtils;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileCollection
implements FileCollectionInternal {
    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public File getSingleFile() throws IllegalStateException {
        Set<File> files = this.getFiles();
        if (files.isEmpty()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains no files.", this.getDisplayName()));
        }
        if (files.size() != 1) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains %d files.", this.getDisplayName(), files.size()));
        }
        return (File)files.iterator().next();
    }

    @Override
    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    @Override
    public String getAsPath() {
        return GUtil.asPath(this.getFiles());
    }

    @Override
    public boolean contains(File file) {
        return this.getFiles().contains(file);
    }

    @Override
    public FileCollection plus(FileCollection collection) {
        return new UnionFileCollection(this, collection);
    }

    public FileCollection plus(Iterable<FileCollection> collections) {
        DeprecationLogger.nagUserWith((String)("The plus(Iterable<FileCollection>) method and using the '+' operator in conjunction with an Iterable<FileCollection> object have been deprecated and are scheduled to be removed in " + GradleVersion.current().getNextMajor().getVersion() + ".  Please use the plus(FileCollection) method or the '+' operator with a FileCollection object instead."));
        return this.plus(new UnionFileCollection(collections));
    }

    @Override
    public FileCollection minus(final FileCollection collection) {
        return new AbstractFileCollection(){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return AbstractFileCollection.this.getBuildDependencies();
            }

            @Override
            public Set<File> getFiles() {
                LinkedHashSet<File> files = new LinkedHashSet<File>(AbstractFileCollection.this.getFiles());
                files.removeAll(collection.getFiles());
                return files;
            }
        };
    }

    public FileCollection minus(Iterable<FileCollection> collections) {
        DeprecationLogger.nagUserWith((String)("The minus(Iterable<FileCollection>) method and using the '-' operator in conjunction with an Iterable<FileCollection> object have been deprecated and are scheduled to be removed in " + GradleVersion.current().getNextMajor().getVersion() + ".  Please use the minus(FileCollection) method or the '-' operator with a FileCollection object instead."));
        return this.minus(new UnionFileCollection(collections));
    }

    @Override
    public FileCollection add(FileCollection collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(String.format("%s does not allow modification.", this.getCapDisplayName()));
    }

    @Override
    public void addToAntBuilder(Object builder, String nodeName, FileCollection.AntType type) {
        if (type == FileCollection.AntType.ResourceCollection) {
            this.addAsResourceCollection(builder, nodeName);
        } else if (type == FileCollection.AntType.FileSet) {
            this.addAsFileSet(builder, nodeName);
        } else {
            this.addAsMatchingTask(builder, nodeName);
        }
    }

    protected void addAsMatchingTask(Object builder, String nodeName) {
        new AntFileCollectionMatchingTaskBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsFileSet(Object builder, String nodeName) {
        new AntFileSetBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileCollectionBuilder(this).addToAntBuilder(builder, nodeName);
    }

    protected Collection<DirectoryFileTree> getAsFileTrees() {
        ArrayList<DirectoryFileTree> fileTrees = new ArrayList<DirectoryFileTree>();
        for (File file : this.getFiles()) {
            if (!file.isFile()) continue;
            fileTrees.add(new FileBackedDirectoryFileTree(file));
        }
        return fileTrees;
    }

    @Override
    public Object addToAntBuilder(Object node, String childNodeName) {
        this.addToAntBuilder(node, childNodeName, FileCollection.AntType.ResourceCollection);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    @Override
    public FileCollection stopExecutionIfEmpty() {
        if (this.isEmpty()) {
            throw new StopExecutionException(String.format("%s does not contain any files.", this.getCapDisplayName()));
        }
        return this;
    }

    @Override
    public Object asType(Class<?> type) throws UnsupportedOperationException {
        if (type.isAssignableFrom(Set.class)) {
            return this.getFiles();
        }
        if (type.isAssignableFrom(List.class)) {
            return new ArrayList<File>(this.getFiles());
        }
        if (type.isAssignableFrom(File[].class)) {
            Set<File> files = this.getFiles();
            return files.toArray(new File[0]);
        }
        if (type.isAssignableFrom(File.class)) {
            return this.getSingleFile();
        }
        if (type.isAssignableFrom(FileCollection.class)) {
            return this;
        }
        if (type.isAssignableFrom(FileTree.class)) {
            return this.getAsFileTree();
        }
        throw new UnsupportedOperationException(String.format("Cannot convert %s to type %s, as this type is not supported.", this.getDisplayName(), type.getSimpleName()));
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return new DefaultTaskDependency();
    }

    @Override
    public FileTree getAsFileTree() {
        return new CompositeFileTree(){

            public void visitContents(FileCollectionResolveContext context) {
                ResolvableFileCollectionResolveContext nested = context.newContext();
                nested.add(AbstractFileCollection.this);
                context.add(nested.resolveAsFileTrees());
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add(AbstractFileCollection.this);
            }

            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }
        };
    }

    @Override
    public FileCollection filter(Closure filterClosure) {
        return this.filter((Spec<? super File>)Specs.convertClosureToSpec((Closure)filterClosure));
    }

    @Override
    public FileCollection filter(final Spec<? super File> filterSpec) {
        return new AbstractFileCollection(){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return AbstractFileCollection.this.getBuildDependencies();
            }

            @Override
            public Set<File> getFiles() {
                return (Set)CollectionUtils.filter((Iterable)AbstractFileCollection.this, new LinkedHashSet(), (Spec)filterSpec);
            }
        };
    }

    protected String getCapDisplayName() {
        return StringUtils.capitalize((String)this.getDisplayName());
    }

    @Override
    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        for (File file : this.getFiles()) {
            builder.add(file);
        }
    }
}

