/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.gradle.internal.SystemProperties;

public class LineFilter
extends Reader {
    private final Closure closure;
    private String transformedLine;
    private int transformedIndex;
    private final BufferedReader bufferedIn;
    private final Reader in;
    private State state = State.NORMAL;

    public LineFilter(Reader in, Closure closure) {
        this.in = in;
        this.bufferedIn = new BufferedReader(in);
        this.closure = closure;
    }

    private void readTransformedLine() throws IOException {
        int ch;
        StringBuilder line = new StringBuilder();
        boolean eol = false;
        while (!eol && (ch = this.bufferedIn.read()) >= 0) {
            if (ch == 10) {
                eol = true;
                continue;
            }
            if (ch == 13) {
                eol = true;
                this.bufferedIn.mark(1);
                if (this.bufferedIn.read() == 10) continue;
                this.bufferedIn.reset();
                continue;
            }
            line.append((char)ch);
        }
        if (line.length() == 0 && !eol) {
            this.state = State.EOF;
            return;
        }
        Object result = this.closure.call((Object)line.toString());
        if (result == null) {
            this.state = State.SKIP_LINE;
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(result.toString());
        if (eol) {
            builder.append(SystemProperties.getInstance().getLineSeparator());
        }
        this.state = State.NORMAL;
        this.transformedLine = builder.toString();
    }

    private void ensureData() throws IOException {
        while (this.state == State.SKIP_LINE || this.state == State.NORMAL && (this.transformedLine == null || this.transformedIndex >= this.transformedLine.length())) {
            this.readTransformedLine();
            this.transformedIndex = 0;
        }
    }

    public int read() throws IOException {
        this.ensureData();
        if (this.state == State.EOF) {
            return -1;
        }
        return this.transformedLine.charAt(this.transformedIndex++);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)c;
        }
        return len;
    }

    public void close() throws IOException {
        this.in.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NORMAL,
        SKIP_LINE,
        EOF;

    }
}

