/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.worker;

import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestMethodDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.worker.WorkerTestClassProcessor;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.id.CompositeIdGenerator;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

public class TestEventSerializer {
    public static SerializerRegistry create() {
        BaseSerializerFactory factory = new BaseSerializerFactory();
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(DefaultTestClassRunInfo.class, (Serializer)new DefaultTestClassRunInfoSerializer());
        registry.register(CompositeIdGenerator.CompositeId.class, (Serializer)new IdSerializer());
        registry.register(DefaultTestSuiteDescriptor.class, (Serializer)new DefaultTestSuiteDescriptorSerializer());
        registry.register(WorkerTestClassProcessor.WorkerTestSuiteDescriptor.class, (Serializer)new WorkerTestSuiteDescriptorSerializer());
        registry.register(DefaultTestClassDescriptor.class, (Serializer)new DefaultTestClassDescriptorSerializer());
        registry.register(DefaultTestMethodDescriptor.class, (Serializer)new DefaultTestMethodDescriptorSerializer());
        registry.register(DefaultTestDescriptor.class, (Serializer)new DefaultTestDescriptorSerializer());
        registry.register(TestStartEvent.class, (Serializer)new TestStartEventSerializer());
        registry.register(TestCompleteEvent.class, (Serializer)new TestCompleteEventSerializer());
        registry.register(DefaultTestOutputEvent.class, (Serializer)new DefaultTestOutputEventSerializer());
        registry.register(Throwable.class, factory.getSerializerFor(Throwable.class));
        return registry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTestMethodDescriptorSerializer
    implements Serializer<DefaultTestMethodDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestMethodDescriptorSerializer() {
        }

        public DefaultTestMethodDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String className = decoder.readString();
            String name = decoder.readString();
            return new DefaultTestMethodDescriptor(id, className, name);
        }

        public void write(Encoder encoder, DefaultTestMethodDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getClassName());
            encoder.writeString((CharSequence)value.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTestDescriptorSerializer
    implements Serializer<DefaultTestDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestDescriptorSerializer() {
        }

        public DefaultTestDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String className = decoder.readString();
            String name = decoder.readString();
            return new DefaultTestDescriptor(id, className, name);
        }

        public void write(Encoder encoder, DefaultTestDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getClassName());
            encoder.writeString((CharSequence)value.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTestClassDescriptorSerializer
    implements Serializer<DefaultTestClassDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestClassDescriptorSerializer() {
        }

        public DefaultTestClassDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            return new DefaultTestClassDescriptor(id, name);
        }

        public void write(Encoder encoder, DefaultTestClassDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkerTestSuiteDescriptorSerializer
    implements Serializer<WorkerTestClassProcessor.WorkerTestSuiteDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private WorkerTestSuiteDescriptorSerializer() {
        }

        public WorkerTestClassProcessor.WorkerTestSuiteDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            return new WorkerTestClassProcessor.WorkerTestSuiteDescriptor(id, name);
        }

        public void write(Encoder encoder, WorkerTestClassProcessor.WorkerTestSuiteDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTestSuiteDescriptorSerializer
    implements Serializer<DefaultTestSuiteDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestSuiteDescriptorSerializer() {
        }

        public DefaultTestSuiteDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            return new DefaultTestSuiteDescriptor(id, name);
        }

        public void write(Encoder encoder, DefaultTestSuiteDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTestOutputEventSerializer
    implements Serializer<DefaultTestOutputEvent> {
        private final Serializer<TestOutputEvent.Destination> destinationSerializer = new BaseSerializerFactory().getSerializerFor(TestOutputEvent.Destination.class);

        private DefaultTestOutputEventSerializer() {
        }

        public DefaultTestOutputEvent read(Decoder decoder) throws Exception {
            TestOutputEvent.Destination destination = (TestOutputEvent.Destination)((Object)this.destinationSerializer.read(decoder));
            String message = decoder.readString();
            return new DefaultTestOutputEvent(destination, message);
        }

        public void write(Encoder encoder, DefaultTestOutputEvent value) throws Exception {
            this.destinationSerializer.write(encoder, (Object)value.getDestination());
            encoder.writeString((CharSequence)value.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestCompleteEventSerializer
    implements Serializer<TestCompleteEvent> {
        private final Serializer<TestResult.ResultType> typeSerializer = new NullableSerializer<TestResult.ResultType>(new BaseSerializerFactory().getSerializerFor(TestResult.ResultType.class));

        private TestCompleteEventSerializer() {
        }

        public TestCompleteEvent read(Decoder decoder) throws Exception {
            long endTime = decoder.readLong();
            TestResult.ResultType result = (TestResult.ResultType)((Object)this.typeSerializer.read(decoder));
            return new TestCompleteEvent(endTime, result);
        }

        public void write(Encoder encoder, TestCompleteEvent value) throws Exception {
            encoder.writeLong(value.getEndTime());
            this.typeSerializer.write(encoder, (Object)value.getResultType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestStartEventSerializer
    implements Serializer<TestStartEvent> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new NullableSerializer<CompositeIdGenerator.CompositeId>(new IdSerializer());

        private TestStartEventSerializer() {
        }

        public TestStartEvent read(Decoder decoder) throws Exception {
            long time = decoder.readLong();
            Object id = this.idSerializer.read(decoder);
            return new TestStartEvent(time, id);
        }

        public void write(Encoder encoder, TestStartEvent value) throws Exception {
            encoder.writeLong(value.getStartTime());
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getParentId()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTestClassRunInfoSerializer
    implements Serializer<DefaultTestClassRunInfo> {
        private DefaultTestClassRunInfoSerializer() {
        }

        public DefaultTestClassRunInfo read(Decoder decoder) throws Exception {
            return new DefaultTestClassRunInfo(decoder.readString());
        }

        public void write(Encoder encoder, DefaultTestClassRunInfo value) throws Exception {
            encoder.writeString((CharSequence)value.getTestClassName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdSerializer
    implements Serializer<CompositeIdGenerator.CompositeId> {
        private IdSerializer() {
        }

        public CompositeIdGenerator.CompositeId read(Decoder decoder) throws Exception {
            return new CompositeIdGenerator.CompositeId((Object)decoder.readLong(), (Object)decoder.readLong());
        }

        public void write(Encoder encoder, CompositeIdGenerator.CompositeId value) throws Exception {
            encoder.writeLong(((Long)value.getScope()).longValue());
            encoder.writeLong(((Long)value.getId()).longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullableSerializer<T>
    implements Serializer<T> {
        private final Serializer<T> serializer;

        private NullableSerializer(Serializer<T> serializer) {
            this.serializer = serializer;
        }

        public T read(Decoder decoder) throws Exception {
            if (!decoder.readBoolean()) {
                return null;
            }
            return (T)this.serializer.read(decoder);
        }

        public void write(Encoder encoder, T value) throws Exception {
            encoder.writeBoolean(value != null);
            if (value != null) {
                this.serializer.write(encoder, value);
            }
        }
    }
}

