/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericColor;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import jspecview.api.PlatformDialog;
import jspecview.common.Annotation;
import jspecview.dialog.DialogManager;
import jspecview.dialog.JSVDialog;
import jspecview.java.AwtDialogManager;
import jspecview.java.DialogTableModel;

public class AwtDialog
extends JDialog
implements PlatformDialog {
    protected String optionKey;
    protected String registryKey;
    protected Map<String, Object> options;
    protected DialogManager manager;
    private Annotation.AType type;
    protected JPanel leftPanel;
    private JSplitPane mainSplitPane;
    private JPanel rightPanel;
    private JPanel thisPanel;
    private JTable dataTable;
    private int iRow;
    private boolean haveColors;
    protected boolean tableCellAlignLeft;
    private boolean haveTwoPanels = true;
    private Insets buttonInsets = new Insets(5, 5, 5, 5);
    private Insets panelInsets = new Insets(0, 0, 2, 2);
    private int defaultHeight = 350;
    protected int selectedRow = -1;
    private DialogTableModel tableModel;

    public AwtDialog(DialogManager manager, JSVDialog jsvDialog, String registryKey) {
        this.manager = manager;
        this.registryKey = registryKey;
        this.type = jsvDialog.getAType();
        this.optionKey = jsvDialog.optionKey;
        this.options = jsvDialog.options;
        if (this.options == null) {
            this.options = new Hashtable<String, Object>();
        }
        this.addFocusListener((AwtDialogManager)manager);
    }

    @Override
    public void setFocus(boolean tf) {
        if (tf) {
            this.requestFocus();
            this.toFront();
        }
    }

    @Override
    public void setVisible(boolean tf) {
        super.setVisible(tf);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    protected int getColumnCentering(int column) {
        return this.tableCellAlignLeft ? 2 : (column == 0 ? 0 : 4);
    }

    @Override
    public Object addButton(String name, String text) {
        JButton btn = new JButton();
        btn.setPreferredSize(new Dimension(120, 25));
        btn.setText(text);
        btn.setName(String.valueOf(this.registryKey) + "/" + name);
        btn.addActionListener((AwtDialogManager)this.manager);
        this.thisPanel.add((Component)btn, new GridBagConstraints(0, this.iRow++, 3, 1, 0.0, 0.0, 10, 0, this.buttonInsets, 0, 0));
        return btn;
    }

    @Override
    public Object addCheckBox(String name, String title, int level, boolean isSelected) {
        if (name == null) {
            this.iRow = 0;
            this.thisPanel = this.rightPanel;
            return null;
        }
        JCheckBox cb = new JCheckBox();
        cb.setSelected(isSelected);
        cb.setText(title);
        cb.setName(String.valueOf(this.registryKey) + "/" + name);
        cb.addActionListener((AwtDialogManager)this.manager);
        Insets insets = new Insets(0, 20 * level, 2, 2);
        this.thisPanel.add((Component)cb, new GridBagConstraints(0, this.iRow++, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        return cb;
    }

    private void addPanelLine(String name, String label, JComponent obj, String units) {
        this.thisPanel.add((Component)new JLabel(label == null ? name : label), new GridBagConstraints(0, this.iRow, 1, 1, 0.0, 0.0, 13, 0, this.panelInsets, 0, 0));
        if (units == null) {
            this.thisPanel.add((Component)obj, new GridBagConstraints(1, this.iRow, 2, 1, 0.0, 0.0, 17, 0, this.panelInsets, 0, 0));
        } else {
            this.thisPanel.add((Component)obj, new GridBagConstraints(1, this.iRow, 1, 1, 0.0, 0.0, 10, 0, this.panelInsets, 0, 0));
            this.thisPanel.add((Component)new JLabel(units), new GridBagConstraints(2, this.iRow, 1, 1, 0.0, 0.0, 17, 0, this.panelInsets, 0, 0));
        }
        ++this.iRow;
    }

    @Override
    public Object addSelectOption(String name, String label, String[] info, int iPt, boolean visible) {
        JComboBox<String> combo = new JComboBox<String>(info);
        combo.setSelectedIndex(iPt);
        combo.setName(String.valueOf(this.registryKey) + "/" + name);
        if (visible) {
            combo.addActionListener((AwtDialogManager)this.manager);
            this.addPanelLine(name, label, combo, null);
        }
        return combo;
    }

    @Override
    public Object addTextField(String name, String label, String value, String units, String defaultValue, boolean visible) {
        String key = String.valueOf(this.optionKey) + "_" + name;
        if (value == null && (value = (String)this.options.get(key)) == null) {
            value = defaultValue;
            this.options.put(key, value);
        }
        JTextField obj = new JTextField(value);
        obj.setName(String.valueOf(this.registryKey) + "/" + name);
        if (visible) {
            obj.setPreferredSize(new Dimension(75, 25));
            obj.addActionListener((AwtDialogManager)this.manager);
            this.addPanelLine(name, label, obj, units);
        }
        return obj;
    }

    @Override
    public void createTable(Object[][] data, String[] header, int[] widths) {
        try {
            this.dataTable = this.getDataTable(data, header, widths, this.leftPanel == null ? this.defaultHeight : this.leftPanel.getHeight() - 50);
            JScrollPane scrollPane = new JScrollPane(this.dataTable);
            if (this.mainSplitPane == null) {
                this.getContentPane().add(scrollPane);
            } else {
                this.mainSplitPane.setRightComponent(scrollPane);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void endLayout() {
        this.getContentPane().removeAll();
        this.getContentPane().add(this.mainSplitPane);
        this.pack();
    }

    private synchronized JTable getDataTable(Object[][] data, String[] columnNames, int[] columnWidths, int height) {
        this.selectedRow = -1;
        this.tableModel = new DialogTableModel(columnNames, data, !this.haveColors);
        JTable table = new JTable(this.tableModel);
        table.setSelectionMode(0);
        if (this.haveColors) {
            table.setDefaultRenderer(GenericColor.class, new ColorRenderer());
        }
        table.setDefaultRenderer(String.class, new TitleRenderer());
        table.setCellSelectionEnabled(true);
        ListSelectionModel selector = table.getSelectionModel();
        selector.addListSelectionListener((AwtDialogManager)this.manager);
        this.manager.registerSelector(String.valueOf(this.registryKey) + "/ROW", selector);
        selector = table.getColumnModel().getSelectionModel();
        selector.addListSelectionListener((AwtDialogManager)this.manager);
        this.manager.registerSelector(String.valueOf(this.registryKey) + "/COL", selector);
        int n = 0;
        int i = 0;
        while (i < columnNames.length) {
            table.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
            n += columnWidths[i];
            ++i;
        }
        table.setPreferredScrollableViewportSize(new Dimension(n, height));
        return table;
    }

    @Override
    public int getSelectedIndex(Object c) {
        return ((JComboBox)c).getSelectedIndex();
    }

    @Override
    public Object getSelectedItem(Object combo) {
        return ((JComboBox)combo).getSelectedItem();
    }

    @Override
    public String getText(Object o) {
        return o instanceof JTextComponent ? ((JTextComponent)o).getText() : ((AbstractButton)o).getText();
    }

    @Override
    public boolean isSelected(Object chkbox) {
        return ((JCheckBox)chkbox).isSelected();
    }

    @Override
    public void selectTableRow(int i) {
        this.selectedRow = i;
        this.dataTable.clearSelection();
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void setCellSelectionEnabled(boolean enabled) {
        this.dataTable.setCellSelectionEnabled(enabled);
    }

    @Override
    public void setEnabled(Object btn, boolean b) {
        ((Component)btn).setEnabled(b);
    }

    @Override
    public void setIntLocation(int[] loc) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        loc[0] = Math.min(d.width - 50, loc[0]);
        loc[1] = Math.min(d.height - 50, loc[1]);
        Point pt = new Point(loc[0], loc[1]);
        this.setLocation(pt);
    }

    @Override
    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void setSelected(Object chkbox, boolean b) {
        ((JCheckBox)chkbox).setSelected(b);
    }

    @Override
    public void setSelectedIndex(Object combo, int i) {
        ((JComboBox)combo).setSelectedIndex(i);
    }

    @Override
    public void setText(Object o, String text) {
        if (o instanceof JTextComponent) {
            ((JTextComponent)o).setText(text);
        } else {
            ((AbstractButton)o).setText(text);
        }
    }

    @Override
    public void startLayout() {
        this.setPreferredSize(new Dimension(600, 370));
        this.getContentPane().removeAll();
        this.thisPanel = this.rightPanel = new JPanel();
        switch (this.type) {
            case Integration: 
            case PeakList: 
            case Measurements: 
            case NONE: {
                break;
            }
            case OverlayLegend: {
                this.tableCellAlignLeft = true;
                this.haveColors = true;
                this.haveTwoPanels = false;
                break;
            }
            case Views: {
                this.rightPanel = new JPanel(new GridBagLayout());
            }
        }
        if (this.haveTwoPanels) {
            this.thisPanel = this.leftPanel = new JPanel(new GridBagLayout());
            this.leftPanel.setMinimumSize(new Dimension(200, 300));
            this.mainSplitPane = new JSplitPane(1);
            this.mainSplitPane.setOneTouchExpandable(true);
            this.mainSplitPane.setResizeWeight(0.0);
            this.mainSplitPane.setLeftComponent(this.leftPanel);
            this.mainSplitPane.setRightComponent(new JScrollPane(this.rightPanel));
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground((Color)color);
            if (isSelected) {
                MatteBorder border = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                this.setBorder(border);
            } else {
                MatteBorder border = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                this.setBorder(border);
            }
            return this;
        }
    }

    class TitleRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public TitleRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object title, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(AwtDialog.this.getColumnCentering(column));
            this.setText(title.toString());
            isSelected = row == AwtDialog.this.selectedRow;
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return this;
        }
    }
}

