/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInLineAction
extends JosmAction {
    public AlignInLineAction() {
        super(I18n.tr("Align Nodes in Line", new Object[0]), "alignline", I18n.tr("Move the selected nodes in to a line.", new Object[0]), Shortcut.registerShortcut("tools:alignline", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Line", new Object[0])), 76, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/AlignInLine"));
    }

    private static Node[] nodePairFurthestApart(List<Node> list) {
        Object object;
        Node node2;
        HashSet<Way> hashSet = null;
        for (Node node2 : list) {
            object = OsmPrimitive.getFilteredList(node2.getReferrers(), Way.class);
            if (hashSet == null) {
                hashSet = new HashSet<Way>((Collection<Way>)object);
                continue;
            }
            hashSet.retainAll((Collection<?>)object);
        }
        if (hashSet == null) {
            throw new IllegalArgumentException();
        }
        if (hashSet.size() != 1) {
            return AlignInLineAction.nodeFurthestAppart(list);
        }
        Way way = (Way)hashSet.iterator().next();
        if (way.isClosed()) {
            return AlignInLineAction.nodeFurthestAppart(list);
        }
        node2 = null;
        object = null;
        HashSet<Node> hashSet2 = new HashSet<Node>(list);
        for (Node node3 : way.getNodes()) {
            if (!hashSet2.contains(node3)) continue;
            if (node2 == null) {
                node2 = node3;
            }
            if (hashSet2.size() == 1) {
                object = (Node)hashSet2.iterator().next();
                break;
            }
            hashSet2.remove(node3);
        }
        return new Node[]{node2, object};
    }

    private static Node[] nodeFurthestAppart(List<Node> list) {
        Node node = null;
        Node node2 = null;
        double d = 0.0;
        int n = list.size();
        for (int i = 0; i < n - 1; ++i) {
            Node node3 = list.get(i);
            for (int j = i + 1; j < n; ++j) {
                Node node4 = list.get(j);
                double d2 = node3.getEastNorth().distanceSq(node4.getEastNorth());
                if (!(d2 > d)) continue;
                node = node3;
                node2 = node4;
                d = d2;
            }
        }
        return new Node[]{node, node2};
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(AlignInLineAction.getCurrentDataSet().getSelectedNodes());
        ArrayList<Way> arrayList2 = new ArrayList<Way>(AlignInLineAction.getCurrentDataSet().getSelectedWays());
        try {
            Command command;
            if (arrayList.isEmpty() && !arrayList2.isEmpty()) {
                command = AlignInLineAction.alignMultiWay(arrayList2);
            } else if (arrayList.size() == 1) {
                List<Way> list;
                Node node = (Node)arrayList.get(0);
                List<Line> list2 = AlignInLineAction.getInvolvedLines(node, list = arrayList2.isEmpty() ? OsmPrimitive.getFilteredList(node.getReferrers(), Way.class) : arrayList2);
                if (list2.size() > 2 || list2.isEmpty()) {
                    throw new InvalidSelection();
                }
                command = AlignInLineAction.alignSingleNode((Node)arrayList.get(0), list2);
            } else if (arrayList.size() >= 3) {
                command = AlignInLineAction.alignOnlyNodes(arrayList);
            } else {
                throw new InvalidSelection();
            }
            Main.main.undoRedo.add(command);
            Main.map.repaint();
        }
        catch (InvalidSelection invalidSelection) {
            new Notification(invalidSelection.getMessage()).setIcon(1).show();
        }
    }

    private static Command alignOnlyNodes(List<Node> list) throws InvalidSelection {
        Node[] nodeArray = AlignInLineAction.nodePairFurthestApart(list);
        ArrayList<Command> arrayList = new ArrayList<Command>(list.size());
        Line line = new Line(nodeArray[0], nodeArray[1]);
        for (Node node : list) {
            if (node == nodeArray[0] || node == nodeArray[1]) continue;
            arrayList.add(line.projectionCommand(node));
        }
        return new SequenceCommand(I18n.tr("Align Nodes in Line", new Object[0]), arrayList);
    }

    private static Command alignMultiWay(Collection<Way> collection) throws InvalidSelection {
        HashSet<Node> hashSet = new HashSet<Node>();
        HashMap<Way, Line> hashMap = new HashMap<Way, Line>();
        for (Way object2 : collection) {
            if (object2.isClosed()) {
                throw new InvalidSelection(I18n.tr("Can not align a polygon. Abort.", new Object[0]));
            }
            hashSet.addAll(object2.getNodes());
            hashMap.put(object2, new Line(object2));
        }
        ArrayList arrayList = new ArrayList(hashSet.size());
        ArrayList<Way> arrayList2 = new ArrayList<Way>(collection.size());
        for (Node node : hashSet) {
            Object object;
            arrayList2.clear();
            for (OsmPrimitive osmPrimitive : node.getReferrers()) {
                if (!collection.contains(osmPrimitive)) continue;
                arrayList2.add((Way)osmPrimitive);
            }
            if (arrayList2.size() == 1) {
                object = (Way)arrayList2.get(0);
                if (((Way)object).isFirstLastNode(node)) continue;
                arrayList.add(((Line)hashMap.get(object)).projectionCommand(node));
                continue;
            }
            if (arrayList2.size() == 2) {
                object = ((Line)hashMap.get(arrayList2.get(0))).intersectionCommand(node, (Line)hashMap.get(arrayList2.get(1)));
                arrayList.add(object);
                continue;
            }
            throw new InvalidSelection(I18n.tr("Intersection of three or more ways can not be solved. Abort.", new Object[0]));
        }
        return new SequenceCommand(I18n.tr("Align Nodes in Line", new Object[0]), arrayList);
    }

    private static List<Line> getInvolvedLines(Node node, List<Way> list) throws InvalidSelection {
        ArrayList<Line> arrayList = new ArrayList<Line>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (Way way : list) {
            List<Node> list2 = way.getNodes();
            arrayList2.clear();
            for (int i = 1; i < list2.size() - 1; ++i) {
                if (list2.get(i) != node) continue;
                arrayList2.add(list2.get(i - 1));
                arrayList2.add(list2.get(i + 1));
            }
            if (arrayList2.isEmpty()) continue;
            if (arrayList2.size() == 2) {
                arrayList.add(new Line((Node)arrayList2.get(0), (Node)arrayList2.get(1)));
                continue;
            }
            if (arrayList2.size() == 4) {
                int n;
                EastNorth eastNorth = node.getEastNorth();
                double[] dArray = new double[4];
                for (int i = 0; i < 4; ++i) {
                    EastNorth eastNorth2 = ((Node)arrayList2.get(i)).getEastNorth();
                    dArray[i] = Math.atan2(eastNorth2.north() - eastNorth.north(), eastNorth2.east() - eastNorth.east());
                }
                double[] dArray2 = new double[3];
                for (n = 0; n < 3; ++n) {
                    dArray2[n] = dArray[n + 1] - dArray[0];
                    if (!(dArray2[n] < 0.0)) continue;
                    int n2 = n;
                    dArray2[n2] = dArray2[n2] + Math.PI * 2;
                }
                n = 0;
                if (dArray2[1] < dArray2[0]) {
                    ++n;
                }
                if (dArray2[2] < dArray2[0]) {
                    ++n;
                }
                if (n == 1) {
                    arrayList.add(new Line((Node)arrayList2.get(0), (Node)arrayList2.get(1)));
                    arrayList.add(new Line((Node)arrayList2.get(2), (Node)arrayList2.get(3)));
                    continue;
                }
                arrayList.add(new Line((Node)arrayList2.get(0), (Node)arrayList2.get(2)));
                arrayList.add(new Line((Node)arrayList2.get(1), (Node)arrayList2.get(3)));
                continue;
            }
            throw new InvalidSelection("cannot treat more than 4 neighbours, got " + arrayList2.size());
        }
        return arrayList;
    }

    private static Command alignSingleNode(Node node, List<Line> list) throws InvalidSelection {
        if (list.size() == 1) {
            return list.get(0).projectionCommand(node);
        }
        if (list.size() == 2) {
            return list.get(0).intersectionCommand(node, list.get(1));
        }
        throw new InvalidSelection();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(AlignInLineAction.getCurrentDataSet() != null && !AlignInLineAction.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private static class Line {
        private double a;
        private double b;
        private double c;
        private double xM;
        private double yM;

        Line(Node node, Node node2) throws InvalidSelection {
            this.xM = node.getEastNorth().getX();
            this.yM = node.getEastNorth().getY();
            double d = node2.getEastNorth().getX();
            double d2 = node2.getEastNorth().getY();
            this.a = d2 - this.yM;
            this.b = this.xM - d;
            double d3 = Math.sqrt(this.a * this.a + this.b * this.b);
            if (d3 == 0.0) {
                throw new InvalidSelection("Nodes have same coordinates!");
            }
            this.a /= d3;
            this.b /= d3;
            this.c = -(this.a * this.xM + this.b * this.yM);
        }

        Line(Way way) throws InvalidSelection {
            this(way.firstNode(), way.lastNode());
        }

        public Command projectionCommand(Node node) {
            double d = (this.xM - node.getEastNorth().getX()) * this.a + (this.yM - node.getEastNorth().getY()) * this.b;
            return new MoveCommand((OsmPrimitive)node, this.a * d, this.b * d);
        }

        public Command intersectionCommand(Node node, Line line) throws InvalidSelection {
            double d = this.a * line.b - line.a * this.b;
            if (Math.abs(d) < 1.0E-5) {
                throw new InvalidSelection(I18n.tr("Two parallels ways found. Abort.", new Object[0]));
            }
            double d2 = (this.b * line.c - line.b * this.c) / d;
            double d3 = (line.a * this.c - this.a * line.c) / d;
            return new MoveCommand((OsmPrimitive)node, d2 - node.getEastNorth().getX(), d3 - node.getEastNorth().getY());
        }
    }

    private static class InvalidSelection
    extends Exception {
        InvalidSelection() {
            super(I18n.tr("Please select at least three nodes.", new Object[0]));
        }

        InvalidSelection(String string) {
            super(string);
        }
    }
}

