/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class JosmAction
extends AbstractAction
implements Destroyable {
    protected transient Shortcut sc;
    private transient LayerChangeAdapter layerChangeAdapter;
    private transient SelectionChangeAdapter selectionChangeAdapter;

    public Shortcut getShortcut() {
        if (this.sc == null) {
            this.sc = Shortcut.registerShortcut("core:none", I18n.tr("No Shortcut", new Object[0]), 65535, 5000);
        }
        return this.sc;
    }

    public JosmAction(String string, ImageProvider imageProvider, String string2, Shortcut shortcut, boolean bl, String string3, boolean bl2) {
        super(string);
        if (imageProvider != null) {
            imageProvider.getResource().getImageIcon(this);
        }
        this.setHelpId();
        this.sc = shortcut;
        if (this.sc != null) {
            Main.registerActionShortcut(this, this.sc);
        }
        this.setTooltip(string2);
        if (this.getValue("toolbar") == null) {
            this.putValue("toolbar", string3);
        }
        if (bl && Main.toolbar != null) {
            Main.toolbar.register(this);
        }
        if (bl2) {
            this.installAdapters();
        }
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, String string4, boolean bl2) {
        this(string, string2 == null ? null : new ImageProvider(string2), string3, shortcut, bl, string4 == null ? string2 : string4, bl2);
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, boolean bl2) {
        this(string, string2, string3, shortcut, bl, null, bl2);
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        this(string, string2, string3, shortcut, bl, null, true);
    }

    public JosmAction() {
        this(true);
    }

    public JosmAction(boolean bl) {
        this.setHelpId();
        if (bl) {
            this.installAdapters();
        }
    }

    @Override
    public void destroy() {
        if (this.sc != null) {
            Main.unregisterActionShortcut(this);
        }
        MapView.removeLayerChangeListener(this.layerChangeAdapter);
        DataSet.removeSelectionListener(this.selectionChangeAdapter);
    }

    private void setHelpId() {
        String string = "Action/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        if (string.endsWith("Action")) {
            string = string.substring(0, string.length() - 6);
        }
        this.putValue("help", string);
    }

    public final void setTooltip(String string) {
        if (string != null) {
            this.putValue("ShortDescription", Main.platform.makeTooltip(string, this.sc));
        }
    }

    public static OsmDataLayer getEditLayer() {
        return Main.main != null ? Main.main.getEditLayer() : null;
    }

    public static DataSet getCurrentDataSet() {
        return Main.main != null ? Main.main.getCurrentDataSet() : null;
    }

    protected void installAdapters() {
        this.layerChangeAdapter = new LayerChangeAdapter();
        this.selectionChangeAdapter = new SelectionChangeAdapter();
        MapView.addLayerChangeListener(this.layerChangeAdapter);
        DataSet.addSelectionListener(this.selectionChangeAdapter);
        this.initEnabledState();
    }

    protected static void waitFuture(final Future<?> future, final PleaseWaitProgressMonitor pleaseWaitProgressMonitor) {
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    future.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {
                    Main.error(exception);
                    return;
                }
                pleaseWaitProgressMonitor.close();
            }
        });
    }

    protected void initEnabledState() {
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
    }

    protected class SelectionChangeAdapter
    implements SelectionChangedListener {
        protected SelectionChangeAdapter() {
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            JosmAction.this.updateEnabledState(collection);
        }
    }

    protected class LayerChangeAdapter
    implements MapView.LayerChangeListener {
        protected LayerChangeAdapter() {
        }

        private void updateEnabledStateInEDT() {
            GuiHelper.runInEDT(new Runnable(){

                @Override
                public void run() {
                    JosmAction.this.updateEnabledState();
                }
            });
        }

        @Override
        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledStateInEDT();
        }

        @Override
        public void layerAdded(Layer layer) {
            this.updateEnabledStateInEDT();
        }

        @Override
        public void layerRemoved(Layer layer) {
            this.updateEnabledStateInEDT();
        }
    }
}

