/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberConflictResolverCommand
extends ConflictResolveCommand {
    private final Relation my;
    private final Relation their;
    private final List<RelationMember> mergedMembers;

    public RelationMemberConflictResolverCommand(Relation relation, Relation relation2, List<RelationMember> list) {
        this.my = relation;
        this.their = relation2;
        this.mergedMembers = list;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in member list of relation {0}", this.my.getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.my.setMembers(this.mergedMembers);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.my);
    }

    @Override
    public void undoCommand() {
        OsmDataLayer osmDataLayer = this.getLayer();
        if (!Main.map.mapView.hasLayer(osmDataLayer)) {
            Main.warn(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), osmDataLayer.toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(osmDataLayer);
        OsmDataLayer osmDataLayer2 = Main.main.getEditLayer();
        super.undoCommand();
        if (!osmDataLayer2.getConflicts().hasConflictForMy(this.my)) {
            osmDataLayer2.getConflicts().add(this.my, this.their);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.my, this.their, this.mergedMembers);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RelationMemberConflictResolverCommand relationMemberConflictResolverCommand = (RelationMemberConflictResolverCommand)object;
        return Objects.equals(this.my, relationMemberConflictResolverCommand.my) && Objects.equals(this.their, relationMemberConflictResolverCommand.their) && Objects.equals(this.mergedMembers, relationMemberConflictResolverCommand.mergedMembers);
    }
}

