/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class Version {
    public static final int JOSM_UNKNOWN_VERSION = 0;
    private static Version instance;
    private int version;
    private String releaseDescription;
    private String time;
    private String buildName;
    private boolean isLocalBuild;

    public static synchronized Version getInstance() {
        if (instance == null) {
            instance = new Version();
            instance.init();
        }
        return instance;
    }

    protected void initFromRevisionInfo(InputStream inputStream) {
        if (inputStream == null) {
            this.releaseDescription = I18n.tr("UNKNOWN", new Object[0]);
            this.version = 0;
            this.time = null;
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            Main.warn(I18n.tr("Error reading revision info from revision file: {0}", iOException.getMessage()));
        }
        String string = properties.getProperty("Revision");
        if (string != null) {
            string = string.trim();
            try {
                this.version = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.version = 0;
                Main.warn(I18n.tr("Unexpected JOSM version number in revision file, value is ''{0}''", string));
            }
        } else {
            this.version = 0;
        }
        this.time = properties.getProperty("Last Changed Date");
        if (this.time == null) {
            this.time = properties.getProperty("Build-Date");
        }
        this.isLocalBuild = false;
        string = properties.getProperty("Is-Local-Build");
        if (string != null && "true".equalsIgnoreCase(string.trim())) {
            this.isLocalBuild = true;
        }
        this.buildName = null;
        string = properties.getProperty("Build-Name");
        if (string != null && !string.trim().isEmpty()) {
            this.buildName = string.trim();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            stringBuilder.append(entry.getKey()).append(':').append(entry.getValue()).append('\n');
        }
        this.releaseDescription = stringBuilder.toString();
    }

    public void init() {
        try (InputStream inputStream = Main.class.getResourceAsStream("/REVISION");){
            if (inputStream == null) {
                Main.warn(I18n.tr("The revision file ''/REVISION'' is missing.", new Object[0]));
                this.version = 0;
                this.releaseDescription = "";
                return;
            }
            this.initFromRevisionInfo(inputStream);
        }
        catch (IOException iOException) {
            Main.warn(iOException);
        }
    }

    public String getVersionString() {
        return this.version == 0 ? I18n.tr("UNKNOWN", new Object[0]) : Integer.toString(this.version);
    }

    public String getReleaseAttributes() {
        return this.releaseDescription;
    }

    public String getTime() {
        return this.time;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isLocalBuild() {
        return this.isLocalBuild;
    }

    public String getAgentString() {
        return this.getAgentString(true);
    }

    public String getAgentString(boolean bl) {
        String string;
        int n = this.getVersion();
        String string2 = string = n == 0 ? "UNKNOWN" : Integer.toString(n);
        if (this.buildName != null) {
            string = string + ' ' + this.buildName;
        }
        if (this.isLocalBuild() && n != 0) {
            string = string + " SVN";
        }
        String string3 = "JOSM/1.5 (" + string + ' ' + LanguageInfo.getJOSMLocaleCode() + ')';
        if (bl && Main.platform != null) {
            string3 = string3 + ' ' + Main.platform.getOSDescription();
        }
        return string3;
    }

    public String getFullAgentString() {
        return this.getAgentString() + " Java/" + System.getProperty("java.version");
    }
}

